/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.jetbrains.php.drupal.DrupalUtil;
import com.jetbrains.php.drupal.hooks.DrupalHookInvocationMethod;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public enum DrupalVersion {
    SIX(6),
    SEVEN(7),
    EIGHT(8),
    NINE(9);

    private static final Map<DrupalVersion, DrupalHookInvocationMethod[]> myVersionToMethodMap;
    private static final Map<DrupalHookInvocationMethod, DrupalVersion> myMethodToOldestVersionMap;
    private final int myNumber;

    private DrupalVersion(int number) {
        this.myNumber = number;
    }

    public int getNumber() {
        return this.myNumber;
    }

    @Nullable
    public static DrupalVersion getFromNumber(int number) {
        for (DrupalVersion version : DrupalVersion.values()) {
            if (version.getNumber() != number) continue;
            return version;
        }
        return null;
    }

    @Nullable
    public DrupalHookInvocationMethod findMethod(FunctionReference reference, boolean slowCheck) {
        String name = reference.getName();
        DrupalHookInvocationMethod result = null;
        for (DrupalHookInvocationMethod invocation : myVersionToMethodMap.get((Object)this)) {
            if (!invocation.sameNameAndType(name, reference)) continue;
            result = invocation;
            break;
        }
        if (result != null && slowCheck && !result.suitsSlow(reference)) {
            return null;
        }
        return result;
    }

    public static DrupalVersion findOldestVersion(DrupalHookInvocationMethod method) {
        DrupalVersion version = myMethodToOldestVersionMap.get((Object)method);
        if (version == null) {
            throw new IllegalStateException("Hook invocation method belongs to no version: " + String.valueOf((Object)method));
        }
        return version;
    }

    @Nullable
    public static DrupalHookInvocationMethod findOldestMethod(FunctionReference reference, boolean slowCheck) {
        for (DrupalVersion version : DrupalVersion.values()) {
            DrupalHookInvocationMethod method = version.findMethod(reference, slowCheck);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public Collection<DrupalVersion> getSmallerOfEqual() {
        SmartList versionList = new SmartList();
        for (DrupalVersion drupalVersion : DrupalVersion.values()) {
            if (drupalVersion.getNumber() > this.getNumber()) continue;
            versionList.add(drupalVersion);
        }
        return versionList;
    }

    @Nullable
    public static DrupalVersion findNewestSuitable(VirtualFile file) {
        DrupalVersion[] values = DrupalVersion.values();
        for (int i = values.length - 1; i >= 0; --i) {
            DrupalVersion version = values[i];
            if (DrupalUtil.validateDrupalInstallation(file, version) != null) continue;
            return version;
        }
        return null;
    }

    static {
        myVersionToMethodMap = new HashMap<DrupalVersion, DrupalHookInvocationMethod[]>();
        myVersionToMethodMap.put(SIX, new DrupalHookInvocationMethod[]{DrupalHookInvocationMethod.MODULE_INVOKE_ALL_6_7_8, DrupalHookInvocationMethod.MODULE_INVOKE_6_7_8, DrupalHookInvocationMethod.DRUPAL_ALTER_6_7_8});
        myVersionToMethodMap.put(SEVEN, new DrupalHookInvocationMethod[]{DrupalHookInvocationMethod.MODULE_INVOKE_ALL_6_7_8, DrupalHookInvocationMethod.MODULE_INVOKE_6_7_8, DrupalHookInvocationMethod.DRUPAL_ALTER_6_7_8});
        myVersionToMethodMap.put(EIGHT, new DrupalHookInvocationMethod[]{DrupalHookInvocationMethod.MODULE_INVOKE_ALL_6_7_8, DrupalHookInvocationMethod.MODULE_INVOKE_6_7_8, DrupalHookInvocationMethod.DRUPAL_ALTER_6_7_8, DrupalHookInvocationMethod.MODULE_HANDLER_INVOKE_ALL_8, DrupalHookInvocationMethod.MODULE_HANDLER_INVOKE_8, DrupalHookInvocationMethod.MODULE_HANDLER_ALTER_8});
        myVersionToMethodMap.put(NINE, new DrupalHookInvocationMethod[]{DrupalHookInvocationMethod.MODULE_INVOKE_ALL_6_7_8, DrupalHookInvocationMethod.MODULE_INVOKE_6_7_8, DrupalHookInvocationMethod.DRUPAL_ALTER_6_7_8, DrupalHookInvocationMethod.MODULE_HANDLER_INVOKE_ALL_8, DrupalHookInvocationMethod.MODULE_HANDLER_INVOKE_8, DrupalHookInvocationMethod.MODULE_HANDLER_ALTER_8});
        myMethodToOldestVersionMap = new HashMap<DrupalHookInvocationMethod, DrupalVersion>();
        for (Map.Entry<DrupalVersion, DrupalHookInvocationMethod[]> entry : myVersionToMethodMap.entrySet()) {
            DrupalVersion version = entry.getKey();
            for (DrupalHookInvocationMethod method : entry.getValue()) {
                DrupalVersion oldVersion = myMethodToOldestVersionMap.get((Object)method);
                if (oldVersion != null && oldVersion.getNumber() <= version.getNumber()) continue;
                myMethodToOldestVersionMap.put(method, version);
            }
        }
    }
}

