/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.hooks;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.php.drupal.DrupalSearchDocsAction;
import com.jetbrains.php.drupal.hooks.DrupalHooksCompletionContributor;
import com.jetbrains.php.drupal.hooks.DrupalHooksUtils;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import com.jetbrains.php.lang.documentation.PhpDocumentationProvider;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DrupalHookDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        DrupalDataService dataService = DrupalDataService.getInstance(element.getProject());
        if (!dataService.isEnabled() || !dataService.isVersionValid()) {
            return null;
        }
        ArrayList<String> urls = new ArrayList<String>();
        PhpDocumentationProvider.addDocUrls((PsiElement)element, urls);
        if (urls.isEmpty()) {
            String functionName;
            String name;
            String string = element instanceof PhpNamedElement ? ((PhpNamedElement)element).getName() : (name = element instanceof PhpReference ? ((PhpReference)element).getName() : null);
            if (name != null) {
                urls.add(DrupalSearchDocsAction.getSearchUrl(name, dataService.getVersion()));
            }
            if ((functionName = DrupalHooksUtils.getHookNameFromDocFunction(element)) != null) {
                urls.add(DrupalSearchDocsAction.getSearchUrl(functionName, dataService.getVersion()));
            }
        }
        return urls;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (!(object instanceof DrupalHooksCompletionContributor.HookImplementationLookupElement)) {
            return null;
        }
        DrupalHooksCompletionContributor.HookImplementationLookupElement lookup = (DrupalHooksCompletionContributor.HookImplementationLookupElement)((Object)object);
        Function function = DrupalHooksUtils.getDescriptiveFunctionByHookName(lookup.getSimpleHookName(), psiManager.getProject());
        if (function != null) {
            return function;
        }
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        Function definition;
        if (editor == null) {
            DrupalHookDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DrupalHookDocumentationProvider.$$$reportNull$$$0(1);
        }
        if ((definition = DrupalHookDocumentationProvider.findHookDefinition(contextElement)) != null) {
            return definition;
        }
        return null;
    }

    @Nullable
    private static Function findHookDefinition(@Nullable PsiElement contextElement) {
        if (contextElement == null) {
            return null;
        }
        PsiElement parent = contextElement.getParent();
        if (!(contextElement instanceof Function) && !(parent instanceof Function)) {
            return null;
        }
        Function function = contextElement instanceof Function ? (Function)contextElement : (Function)parent;
        String hookName = DrupalHooksUtils.getPotentialHookName((PsiElement)function, null);
        if (hookName == null) {
            return null;
        }
        return DrupalHooksUtils.getDescriptiveFunctionByHookName(hookName, function.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/drupal/hooks/DrupalHookDocumentationProvider";
        objectArray[2] = "getCustomDocumentationElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

