/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.Git;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.stash.GitShelveChangesSaver;
import git4idea.stash.GitStashChangesSaver;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitChangesSaver.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final ProgressIndicator myProgressIndicator;
    @NotNull
    protected final String myStashMessage;
    @NotNull
    private final GitSaveChangesPolicy mySaveMethod;
    protected GitConflictResolver.Params myParams;

    @NotNull
    public static GitChangesSaver getSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator progressIndicator, @NotNull @Nls String stashMessage, @NotNull GitSaveChangesPolicy saveMethod) {
        if (project == null) {
            GitChangesSaver.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitChangesSaver.$$$reportNull$$$0(1);
        }
        if (progressIndicator == null) {
            GitChangesSaver.$$$reportNull$$$0(2);
        }
        if (stashMessage == null) {
            GitChangesSaver.$$$reportNull$$$0(3);
        }
        if (saveMethod == null) {
            GitChangesSaver.$$$reportNull$$$0(4);
        }
        return GitChangesSaver.getSaver(project, git, progressIndicator, stashMessage, saveMethod, true);
    }

    @ApiStatus.Internal
    @NotNull
    public static GitChangesSaver getSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator progressIndicator, @NotNull @Nls String stashMessage, @NotNull GitSaveChangesPolicy saveMethod, boolean reportLocalHistoryActivity) {
        if (project == null) {
            GitChangesSaver.$$$reportNull$$$0(5);
        }
        if (git == null) {
            GitChangesSaver.$$$reportNull$$$0(6);
        }
        if (progressIndicator == null) {
            GitChangesSaver.$$$reportNull$$$0(7);
        }
        if (stashMessage == null) {
            GitChangesSaver.$$$reportNull$$$0(8);
        }
        if (saveMethod == null) {
            GitChangesSaver.$$$reportNull$$$0(9);
        }
        if (saveMethod == GitSaveChangesPolicy.SHELVE) {
            GitShelveChangesSaver shelveSaver = new GitShelveChangesSaver(project, git, progressIndicator, stashMessage);
            shelveSaver.setReportLocalHistoryActivity(reportLocalHistoryActivity);
            GitShelveChangesSaver gitShelveChangesSaver = shelveSaver;
            if (gitShelveChangesSaver == null) {
                GitChangesSaver.$$$reportNull$$$0(10);
            }
            return gitShelveChangesSaver;
        }
        GitStashChangesSaver stashSaver = new GitStashChangesSaver(project, git, progressIndicator, stashMessage);
        stashSaver.setReportLocalHistoryActivity(reportLocalHistoryActivity);
        GitStashChangesSaver gitStashChangesSaver = stashSaver;
        if (gitStashChangesSaver == null) {
            GitChangesSaver.$$$reportNull$$$0(11);
        }
        return gitStashChangesSaver;
    }

    protected GitChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator, @NotNull GitSaveChangesPolicy saveMethod, @NotNull String stashMessage) {
        if (project == null) {
            GitChangesSaver.$$$reportNull$$$0(12);
        }
        if (git == null) {
            GitChangesSaver.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            GitChangesSaver.$$$reportNull$$$0(14);
        }
        if (saveMethod == null) {
            GitChangesSaver.$$$reportNull$$$0(15);
        }
        if (stashMessage == null) {
            GitChangesSaver.$$$reportNull$$$0(16);
        }
        this.myProject = project;
        this.myGit = git;
        this.myProgressIndicator = indicator;
        this.mySaveMethod = saveMethod;
        this.myStashMessage = stashMessage;
    }

    public void saveLocalChanges(@Nullable Collection<? extends VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null || rootsToSave.isEmpty()) {
            return;
        }
        this.save(rootsToSave);
    }

    @Nullable
    @Nls
    public String saveLocalChangesOrError(@Nullable Collection<? extends VirtualFile> rootsToSave) {
        try {
            this.saveLocalChanges(rootsToSave);
            return null;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            String message = this.getSaveMethod().selectBundleMessage(GitBundle.message((String)"save.notification.failed.stash.text", (Object[])new Object[0]), GitBundle.message((String)"save.notification.failed.shelf.text", (Object[])new Object[0]));
            return new HtmlBuilder().append(message).br().appendRaw(e.getMessage()).toString();
        }
    }

    public boolean trySaveLocalChanges(@Nullable Collection<? extends VirtualFile> rootsToSave) {
        String errorMessage = this.saveLocalChangesOrError(rootsToSave);
        if (errorMessage == null) {
            return true;
        }
        VcsNotifier.getInstance((Project)this.myProject).notifyError("vcs.uncommitted.changes.saving.error", VcsBundle.message((String)"notification.title.couldn.t.save.uncommitted.changes", (Object[])new Object[0]), errorMessage);
        return false;
    }

    public void notifyLocalChangesAreNotRestored(@NotNull @Nls String operationName) {
        if (operationName == null) {
            GitChangesSaver.$$$reportNull$$$0(17);
        }
        if (this.wereChangesSaved()) {
            LOG.info("Local changes are not restored");
            VcsNotifier.importantNotification().createNotification(GitBundle.message((String)"restore.notification.failed.title", (Object[])new Object[0]), this.getSaveMethod().selectBundleMessage(GitBundle.message((String)"restore.notification.failed.stash.message", (Object[])new Object[]{operationName}), GitBundle.message((String)"restore.notification.failed.shelf.message", (Object[])new Object[]{operationName})), NotificationType.WARNING).setDisplayId("git.local.changes.not.restored").addAction((AnAction)NotificationAction.createSimple((Supplier)GitBundle.messagePointer((String)"restore.notification.failed.show.changes.action", (Object[])new Object[0]), () -> this.showSavedChanges())).notify(this.myProject);
        }
    }

    public void setConflictResolverParams(GitConflictResolver.Params params) {
        this.myParams = params;
    }

    protected abstract void save(Collection<? extends VirtualFile> var1) throws VcsException;

    public abstract void load();

    public abstract boolean wereChangesSaved();

    @NotNull
    public GitSaveChangesPolicy getSaveMethod() {
        GitSaveChangesPolicy gitSaveChangesPolicy = this.mySaveMethod;
        if (gitSaveChangesPolicy == null) {
            GitChangesSaver.$$$reportNull$$$0(18);
        }
        return gitSaveChangesPolicy;
    }

    public abstract void showSavedChanges();

    @NotNull
    protected static String getConflictRightPanelTitle() {
        String string = GitBundle.message((String)"save.load.conflict.dialog.diff.right.title", (Object[])new Object[0]);
        if (string == null) {
            GitChangesSaver.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    protected static String getConflictLeftPanelTitle() {
        String string = GitBundle.message((String)"save.load.conflict.dialog.diff.left.title", (Object[])new Object[0]);
        if (string == null) {
            GitChangesSaver.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 3: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stashMessage";
                break;
            }
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "saveMethod";
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/stash/GitChangesSaver";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/stash/GitChangesSaver";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSaver";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSaveMethod";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictRightPanelTitle";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictLeftPanelTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSaver";
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "notifyLocalChangesAreNotRestored";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

