/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.configuration;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SqlDialects;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.ChangeDialectAction;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguageUtils;
import com.intellij.sql.psi.SqlUnknownStatement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SqlDialectInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "SqlDialectInspection";
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        boolean addSelected;
        if (file == null) {
            SqlDialectInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlDialectInspection.$$$reportNull$$$0(1);
        }
        if (!isOnTheFly || !(file instanceof SqlFile) || ((SqlFile)file).getSqlLanguage() != SqlDialects.getGenericDialect() || SqlDialectInspection.isGenericExplicitly(file)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = manager.getProject();
        if (DbPsiFacade.getInstance((Project)project).getDataSources().isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file);
        VirtualFile vfile = topLevelFile.getVirtualFile();
        if (vfile instanceof LightVirtualFile || DbSrcUtilsCore.isDbSrcFile((VirtualFile)vfile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        String fileText = file.getText();
        CharSequence fileSnippet = fileText.subSequence(0, Math.min(fileText.length(), 10240));
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)project);
        LinkedHashMap<SqlLanguageDialect, Double> dialectMap = new LinkedHashMap<SqlLanguageDialect, Double>();
        MyMetric metric = new MyMetric();
        for (SqlLanguageDialect dialect : SqlDialects.getTopLevelSqlDialects()) {
            if (dialect.getDbms() == Dbms.UNKNOWN) continue;
            PsiFile sqlFile = fileFactory.createFileFromText("a.sql", (Language)dialect, fileSnippet);
            sqlFile.accept((PsiElementVisitor)metric);
            dialectMap.put(dialect, metric.getMetric());
        }
        ArrayList sortedDialects = new ArrayList(dialectMap.keySet());
        Object2IntOpenHashMap usagesMap = new Object2IntOpenHashMap();
        for (DbDataSource ds : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            usagesMap.mergeInt((Object)DbSqlUtilCore.getSqlDialect((DbDataSource)ds), 1, (sum, n) -> sum + n);
        }
        sortedDialects.sort((arg_0, arg_1) -> SqlDialectInspection.lambda$checkFile$1((Object2IntMap)usagesMap, arg_0, arg_1));
        sortedDialects.sort((o1, o2) -> ((Double)dialectMap.get(o2)).compareTo((Double)dialectMap.get(o1)));
        if (sortedDialects.isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SqlLanguageDialect topDialect = (SqlLanguageDialect)sortedDialects.get(0);
        double topMetric = (Double)dialectMap.get(topDialect);
        if (topMetric > 0.0 && topMetric < 10.0) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<String> selectedNames = new ArrayList<String>();
        if (topMetric > 0.0) {
            for (SqlLanguageDialect dialect : sortedDialects) {
                if (!((Double)dialectMap.get(dialect) / topMetric > 0.9)) continue;
                selectedNames.add(dialect.getDisplayName());
            }
        }
        Object message = SqlBundle.message((String)"inspection.message.sql.dialect.not.configured", (Object[])new Object[0]);
        boolean bl = addSelected = selectedNames.size() < 4;
        if (!selectedNames.isEmpty() && addSelected) {
            message = (String)message + SqlBundle.message((String)"inspection.message.choice.matches.match.best", (Object[])new Object[]{StringUtil.join(selectedNames, (String)", "), selectedNames.size() == 1 ? 0 : 1});
        }
        ChooseDialectQuickFix settingsFix = new ChooseDialectQuickFix(null);
        ChooseDialectQuickFix useTopDialectFix = topMetric > 0.0 && addSelected ? new ChooseDialectQuickFix(topDialect) : null;
        CancelQuickFix useGenericDialectFix = new CancelQuickFix();
        LocalQuickFix[] fixes = (LocalQuickFix[])Stream.of(new ChooseDialectQuickFix[]{useTopDialectFix, settingsFix, useGenericDialectFix}).filter(Objects::nonNull).toArray(LocalQuickFix[]::new);
        return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)file, (String)message, true, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
    }

    private static boolean isGenericExplicitly(PsiFile file) {
        VirtualFile vfile = file.getVirtualFile();
        if (ScratchUtil.isScratch((VirtualFile)vfile)) {
            return true;
        }
        SqlLanguageDialect dialect = SqlLanguageUtils.getConfiguredSqlLanguageDialect((VirtualFile)vfile, (Project)file.getProject());
        if (dialect == SqlDialects.getGenericDialect()) {
            return true;
        }
        if (dialect != null) {
            return false;
        }
        SqlDialectMappings instance = SqlDialectMappings.getInstance((Project)file.getProject());
        return instance != null && instance.getDirectlyConfiguredMapping(null) == SqlDialects.getGenericDialect();
    }

    @TestOnly
    @Nullable
    public static SqlLanguageDialect getSuggestedLanguage(@NotNull IntentionAction fix) {
        ChooseDialectQuickFix quickFix;
        if (fix == null) {
            SqlDialectInspection.$$$reportNull$$$0(2);
        }
        return (quickFix = (ChooseDialectQuickFix)((Object)ObjectUtils.tryCast((Object)fix, ChooseDialectQuickFix.class))) == null ? null : quickFix.myDialect;
    }

    private static /* synthetic */ int lambda$checkFile$1(Object2IntMap usagesMap, SqlLanguageDialect o1, SqlLanguageDialect o2) {
        return Integer.compare(usagesMap.getOrDefault((Object)o2, 0), usagesMap.getOrDefault((Object)o1, 0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlDialectInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuggestedLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyMetric
    extends PsiRecursiveElementWalkingVisitor {
        int errors;
        int composites;

        private MyMetric() {
        }

        public double getMetric() {
            try {
                double d = this.errors == 0 ? 2.147483647E9 : (double)this.composites / (double)this.errors;
                return d;
            }
            finally {
                this.errors = 0;
                this.composites = 0;
            }
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                MyMetric.$$$reportNull$$$0(0);
            }
            if (element instanceof PsiErrorElement || element instanceof SqlUnknownStatement) {
                ++this.errors;
            } else if (element instanceof SqlCompositeElement) {
                ++this.composites;
            }
            super.visitElement(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/configuration/SqlDialectInspection$MyMetric", "visitElement"));
        }
    }

    private static class ChooseDialectQuickFix
    extends IntentionAndQuickFixAction {
        private final SqlLanguageDialect myDialect;

        private ChooseDialectQuickFix(@Nullable SqlLanguageDialect dialect) {
            this.myDialect = dialect;
        }

        @NotNull
        public String getName() {
            String string = this.myDialect == null ? SqlBundle.message((String)"intention.name.change.dialect.to", (Object[])new Object[0]) : SqlBundle.message((String)"intention.name.use.dialect", (Object[])new Object[]{this.myDialect.getDisplayName()});
            if (string == null) {
                ChooseDialectQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                ChooseDialectQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
            boolean injected;
            PsiFile topLevelFile;
            VirtualFile virtualFile;
            if (project == null) {
                ChooseDialectQuickFix.$$$reportNull$$$0(2);
            }
            if ((virtualFile = (topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)psiFile)).getVirtualFile()) == null) {
                return;
            }
            boolean bl = injected = topLevelFile != psiFile;
            if (virtualFile instanceof VirtualFileWindow) {
                VirtualFileWindow window = (VirtualFileWindow)virtualFile;
                virtualFile = window.getDelegate();
            }
            if (this.myDialect == null) {
                if (injected || !ScratchUtil.isScratch((VirtualFile)virtualFile)) {
                    SqlDialectsConfigurable.openDialectsConfigurable(project, virtualFile);
                } else {
                    RelativePoint point = RelativePoint.fromScreen((Point)MouseInfo.getPointerInfo().getLocation());
                    ListPopup popup = ChangeDialectAction.buildDialectsPopup(project, (JBIterable<? extends VirtualFile>)JBIterable.of((Object)virtualFile));
                    if (editor == null || !editor.getComponent().isShowing()) {
                        popup.show(point);
                    } else {
                        JRootPane rootPane = editor.getComponent().getRootPane();
                        Component componentAt = rootPane.findComponentAt(point.getPoint((Component)rootPane));
                        if (componentAt instanceof HyperlinkLabel) {
                            popup.setMinimumSize(componentAt.getSize());
                            popup.showUnderneathOf(componentAt);
                        } else {
                            popup.showInBestPositionFor(editor);
                        }
                    }
                }
            } else {
                ChangeDialectAction.setDialectImpl(project, virtualFile, (Language)this.myDialect, injected);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlDialectInspection$ChooseDialectQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlDialectInspection$ChooseDialectQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class CancelQuickFix
    extends ChooseDialectQuickFix {
        @Override
        @NotNull
        public String getName() {
            String string = SqlBundle.message((String)"intention.name.cancel", (Object[])new Object[0]);
            if (string == null) {
                CancelQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private CancelQuickFix() {
            super(SqlDialects.getGenericDialect());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/configuration/SqlDialectInspection$CancelQuickFix", "getName"));
        }
    }
}

