/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlLimitClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class SqlPreviewDmlAction
extends SqlBaseElementAtCaretIntentionAction
implements HighPriorityAction {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        SqlDmlInstruction instruction;
        if (project == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(2);
        }
        if ((instruction = this.getInstruction(element)) == null) {
            return;
        }
        String statement = this.getPreviewStatement(instruction);
        if (statement == null) {
            return;
        }
        SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)element.getContainingFile(), SqlFile.class);
        if (file == null) {
            return;
        }
        JdbcConsole console = JdbcConsoleProvider.getValidConsole((Project)project, (VirtualFile)file.getViewProvider().getVirtualFile());
        if (console != null) {
            this.perform(editor, statement, (PsiElement)instruction, console);
        } else {
            this.chooseAndPerform(project, editor, (PsiElement)instruction, statement);
        }
    }

    @Nullable
    protected abstract String getPreviewStatement(SqlDmlInstruction var1);

    @Nullable
    protected abstract SqlDmlInstruction getInstruction(@NotNull PsiElement var1);

    protected void chooseAndPerform(@NotNull Project project, Editor editor, @NotNull PsiElement element, @NotNull String statement) {
        if (project == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(4);
        }
        if (statement == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(5);
        }
        PsiFile file = element.getContainingFile();
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        @Nls String title = SessionsUtil.getSessionTitle((VirtualFile)virtualFile);
        List runners = DatabaseRunners.getAttachDataSourceRunners((PsiFile)file, (String)title, newSession -> {
            JdbcConsole console = JdbcConsoleProvider.reattachConsole((Project)project, (DatabaseSession)newSession, (VirtualFile)virtualFile);
            if (console == null) {
                return;
            }
            this.perform(editor, statement, element, console);
        });
        RunQueryInConsoleIntentionAction.Manager.chooseAndRunRunners((List)runners, (Editor)editor, null);
    }

    protected void perform(Editor editor, @NotNull String statement, @NotNull PsiElement element, @NotNull JdbcConsole console) {
        if (statement == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(6);
        }
        if (element == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(7);
        }
        if (console == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(8);
        }
        Document document = console.getDocument();
        RangeMarker marker = document.createRangeMarker(element.getTextRange());
        MyRequest request = new MyRequest(console, statement, editor, marker);
        request.getPromise().onProcessed(__ -> marker.dispose());
        console.getMessageBus().getDataProducer().processRequest((GridDataRequest)request);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(10);
        }
        if (element == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(11);
        }
        return this.getInstruction(element) != null;
    }

    @NotNull
    private static List<String> getColumnNames(@NotNull Project project, SqlTableType type, SqlLanguageDialectEx dialect, SqlExpression extra) {
        if (project == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(12);
        }
        SqlTableType extraType = extra == null ? null : (SqlTableType)ObjectUtils.tryCast((Object)extra.getDasType(), SqlTableType.class);
        SqlTableType all = extraType == null ? null : type.join(extraType);
        DatabaseDialectEx dbDialect = dialect.getDatabaseDialect();
        List list = all == null ? DbSqlUtil.getUnambiguousColumnNames((Project)project, (DatabaseDialectEx)dbDialect, (SqlTableType)type, (a, b) -> false) : DbSqlUtil.getUnambiguousColumnNames((Project)project, (DatabaseDialectEx)dbDialect, (SqlTableType)type, (SqlTableType)all, (a, b) -> false);
        if (list == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static void appendNewValue(StringBuilder res, int listStart, List<SqlSetAssignment> assignments, IntList indices, int idx, NamingService ns) {
        for (int k = 0; k < indices.size(); ++k) {
            SqlReferenceExpression r;
            SqlElement value;
            if (indices.getInt(k) != idx || (value = assignments.get(k).getRValue()) == null) continue;
            SqlPreviewDmlAction.leadingComma(res, listStart);
            SqlElement lValue = assignments.get(k).getLValue();
            String name = lValue instanceof SqlReferenceExpression && (r = (SqlReferenceExpression)lValue).getQualifierExpression() == null ? r.getName() : lValue.getText();
            res.append(value.getText()).append(" as ").append(ns.enquote("new " + name, null));
        }
    }

    private static void leadingComma(StringBuilder res, int listStart) {
        if (res.length() != listStart) {
            res.append(", ");
        }
    }

    private static int findIdx(SqlElement value, SqlTableType type) {
        ResolveResult[] resolved;
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)value, SqlReferenceExpression.class);
        for (ResolveResult result : resolved = ref == null ? ResolveResult.EMPTY_ARRAY : ref.multiResolve(false)) {
            int e = type.getColumnCount();
            for (int i = 0; i < e; ++i) {
                if (result.getElement() != type.getColumnElement(i)) continue;
                return i;
            }
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlPreviewDmlAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlPreviewDmlAction";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndPerform";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNames";
                break;
            }
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }

    private static class MyRequest
    extends DataRequest.QueryRequest
    implements DataRequest.CoupledWithEditor {
        private final Editor myEditor;
        private final RangeMarker myMarker;

        MyRequest(@NotNull JdbcConsole owner, @NotNull String query, @NotNull Editor editor, @NotNull RangeMarker marker) {
            if (owner == null) {
                MyRequest.$$$reportNull$$$0(0);
            }
            if (query == null) {
                MyRequest.$$$reportNull$$$0(1);
            }
            if (editor == null) {
                MyRequest.$$$reportNull$$$0(2);
            }
            if (marker == null) {
                MyRequest.$$$reportNull$$$0(3);
            }
            super((DataRequest.Owner)owner, query, DataRequest.newConstraints((Dbms)DbImplUtil.getDbms((JdbcConsoleBase)owner)), null);
            this.myEditor = editor;
            this.myMarker = marker;
        }

        @Nullable
        public Editor getEditor() {
            return this.myEditor;
        }

        @Nullable
        public TextRange getRange() {
            return this.myMarker.isValid() ? this.myMarker.getTextRange() : null;
        }

        @Nullable
        public DataRequest.CoupledWithEditor.ErrorNavigator onError(@NotNull ErrorInfo errorInfo) {
            if (errorInfo == null) {
                MyRequest.$$$reportNull$$$0(4);
            }
            return null;
        }

        @NotNull
        public GridDataRequest getRequest() {
            MyRequest myRequest = this;
            if (myRequest == null) {
                MyRequest.$$$reportNull$$$0(5);
            }
            return myRequest;
        }

        public void onWarning(@NotNull JdbcEngineUtils.EngineWarningExceptionInfo info) {
            if (info == null) {
                MyRequest.$$$reportNull$$$0(6);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "marker";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/intentions/SqlPreviewDmlAction$MyRequest";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/intentions/SqlPreviewDmlAction$MyRequest";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "onError";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "onWarning";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Delete
    extends SqlPreviewDmlAction {
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"preview.delete", (Object[])new Object[0]);
            if (string == null) {
                Delete.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        protected String getPreviewStatement(SqlDmlInstruction instruction) {
            return Delete.getStatement(instruction);
        }

        @Override
        @Nullable
        protected SqlDmlInstruction getInstruction(@NotNull PsiElement element) {
            if (element == null) {
                Delete.$$$reportNull$$$0(1);
            }
            return Delete.getDeleteInstruction(element);
        }

        @Nullable
        private static SqlDmlInstruction getDeleteInstruction(@NotNull PsiElement element) {
            if (element == null) {
                Delete.$$$reportNull$$$0(2);
            }
            return (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlDeleteStatement.class), SqlDmlInstruction.class);
        }

        @Nullable
        private static String getStatement(@NotNull SqlDmlInstruction del) {
            SqlLimitClause limit;
            SqlWhereClause where;
            SqlExpression expression;
            if (del == null) {
                Delete.$$$reportNull$$$0(3);
            }
            if ((expression = del.getTargetExpression()) == null) {
                return null;
            }
            StringBuilder res = new StringBuilder();
            SqlTableType type = del.getTargetType();
            SqlFromClause from = (SqlFromClause)PsiTreeUtil.getChildOfType((PsiElement)del, SqlFromClause.class);
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)del);
            SqlExpression extra = from == null ? null : from.getFromExpression();
            List<String> names = SqlPreviewDmlAction.getColumnNames(del.getProject(), type, dialect, extra);
            SqlWithClause cte = (SqlWithClause)PsiTreeUtil.getChildOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)del, SqlStatement.class), SqlWithClause.class);
            if (cte != null) {
                res.append(cte.getText()).append(" ");
            }
            res.append("select ");
            if (names.isEmpty()) {
                res.append("*");
            } else {
                StringUtil.join(names, (String)", ", (StringBuilder)res);
            }
            res.append(" from ");
            int listStart = res.length();
            if (!Delete.isInFrom(expression, from)) {
                res.append(expression.getText());
            }
            if (extra != null) {
                SqlPreviewDmlAction.leadingComma(res, listStart);
                res.append(extra.getText());
            }
            if ((where = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)del, SqlWhereClause.class)) != null) {
                res.append(" ").append(where.getText());
            }
            if ((limit = (SqlLimitClause)PsiTreeUtil.getChildOfType((PsiElement)del, SqlLimitClause.class)) != null) {
                res.append(" ").append(limit.getText());
            }
            return res.toString();
        }

        private static boolean isInFrom(SqlExpression expression, SqlFromClause from) {
            PsiElement immediate;
            PsiElement resolved;
            if (PsiTreeUtil.isAncestor((PsiElement)from, (PsiElement)expression, (boolean)false)) {
                return true;
            }
            ResolveResult rr = expression instanceof SqlReferenceExpression ? ((SqlReferenceExpression)expression).resolveSingle() : null;
            PsiElement psiElement = resolved = rr == null ? null : rr.getElement();
            if (resolved == null) {
                return false;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)from, (PsiElement)resolved, (boolean)true)) {
                return true;
            }
            return rr instanceof SqlResolveResult && (immediate = ((SqlResolveResult)rr).getImmediateTarget()) != null && PsiTreeUtil.isAncestor((PsiElement)from, (PsiElement)immediate, (boolean)true);
        }

        @TestOnly
        @Nullable
        public static String getStatement(@NotNull PsiElement element) {
            SqlDmlInstruction instruction;
            if (element == null) {
                Delete.$$$reportNull$$$0(4);
            }
            return (instruction = Delete.getDeleteInstruction(element)) == null ? null : Delete.getStatement(instruction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/intentions/SqlPreviewDmlAction$Delete";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "del";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/intentions/SqlPreviewDmlAction$Delete";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstruction";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDeleteInstruction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class Update
    extends SqlPreviewDmlAction {
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"preview.update", (Object[])new Object[0]);
            if (string == null) {
                Update.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        protected String getPreviewStatement(SqlDmlInstruction instruction) {
            return Update.getStatement(instruction);
        }

        @Override
        @Nullable
        protected SqlDmlInstruction getInstruction(@NotNull PsiElement element) {
            if (element == null) {
                Update.$$$reportNull$$$0(1);
            }
            return Update.getUpdateInstruction(element);
        }

        @Nullable
        private static SqlDmlInstruction getUpdateInstruction(@NotNull PsiElement element) {
            if (element == null) {
                Update.$$$reportNull$$$0(2);
            }
            return (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlUpdateStatement.class), SqlDmlInstruction.class);
        }

        @Nullable
        private static String getStatement(@NotNull SqlDmlInstruction upd) {
            SqlWhereClause where;
            SqlExpression expression;
            if (upd == null) {
                Update.$$$reportNull$$$0(3);
            }
            if ((expression = upd.getTargetExpression()) == null) {
                return null;
            }
            StringBuilder res = new StringBuilder();
            SqlTableType type = upd.getTargetType();
            SqlFromClause from = (SqlFromClause)PsiTreeUtil.getChildOfType((PsiElement)upd, SqlFromClause.class);
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)upd);
            NamingService namingService = NamingServices.getNamingService((Dbms)SqlImplUtil.getDbms((PsiElement)upd));
            SqlExpression extra = from == null ? null : from.getFromExpression();
            List<String> names = SqlPreviewDmlAction.getColumnNames(upd.getProject(), type, dialect, extra);
            SqlSetClause set = (SqlSetClause)PsiTreeUtil.getChildOfType((PsiElement)upd, SqlSetClause.class);
            List assignments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)set, SqlSetAssignment.class);
            IntArrayList indices = new IntArrayList();
            for (SqlSetAssignment assignment : assignments) {
                indices.add(SqlPreviewDmlAction.findIdx(assignment.getLValue(), type));
            }
            SqlWithClause cte = (SqlWithClause)PsiTreeUtil.getChildOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)upd, SqlStatement.class), SqlWithClause.class);
            if (cte != null) {
                res.append(cte.getText()).append(" ");
            }
            res.append("select ");
            int listStart = res.length();
            for (int i = 0; i < names.size(); ++i) {
                SqlPreviewDmlAction.leadingComma(res, listStart);
                res.append(names.get(i));
                SqlPreviewDmlAction.appendNewValue(res, listStart, assignments, (IntList)indices, i, namingService);
            }
            SqlPreviewDmlAction.appendNewValue(res, listStart, assignments, (IntList)indices, -1, namingService);
            if (names.isEmpty()) {
                SqlPreviewDmlAction.leadingComma(res, listStart);
                res.append("*");
            }
            res.append(" from ");
            listStart = res.length();
            if (!Update.isInFrom(expression, from)) {
                res.append(expression.getText());
            }
            if (extra != null) {
                SqlPreviewDmlAction.leadingComma(res, listStart);
                res.append(extra.getText());
            }
            if ((where = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)upd, SqlWhereClause.class)) != null) {
                res.append(" ").append(where.getText());
            }
            return res.toString();
        }

        private static boolean isInFrom(SqlExpression expression, SqlFromClause from) {
            PsiElement immediate;
            PsiElement resolved;
            ResolveResult rr = expression instanceof SqlReferenceExpression ? ((SqlReferenceExpression)expression).resolveSingle() : null;
            PsiElement psiElement = resolved = rr == null ? null : rr.getElement();
            if (resolved == null) {
                return false;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)from, (PsiElement)resolved, (boolean)true)) {
                return true;
            }
            return rr instanceof SqlResolveResult && (immediate = ((SqlResolveResult)rr).getImmediateTarget()) != null && PsiTreeUtil.isAncestor((PsiElement)from, (PsiElement)immediate, (boolean)true);
        }

        @TestOnly
        @Nullable
        public static String getStatement(@NotNull PsiElement element) {
            SqlDmlInstruction instruction;
            if (element == null) {
                Update.$$$reportNull$$$0(4);
            }
            return (instruction = Update.getUpdateInstruction(element)) == null ? null : Update.getStatement(instruction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/intentions/SqlPreviewDmlAction$Update";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "upd";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/intentions/SqlPreviewDmlAction$Update";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstruction";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getUpdateInstruction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

