/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.vcs;

import com.intellij.diagram.ChangeTracker;
import com.intellij.diagram.DiagramChangesProvider;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.vcs.DiffUmlProvider;
import com.intellij.diagram.vcs.UmlDiffEdge;
import com.intellij.diagram.vcs.UmlDiffElement;
import com.intellij.diagram.vcs.UmlDiffNode;
import com.intellij.diagram.vcs.UmlDiffNodeWithoutTracker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DiffUmlDataModel
extends DiagramDataModel<UmlDiffElement> {
    private final Map<String, UmlDiffNode> myNodes = new HashMap<String, UmlDiffNode>();
    private final ArrayList<UmlDiffEdge> myEdges = new ArrayList();
    private final Set<Class<? extends DiagramChangesProvider>> myChangeProviders = new HashSet<Class<? extends DiagramChangesProvider>>();
    private PsiFile myStub;

    public DiffUmlDataModel(Project project, UmlDiffElement element, LocalChangeList localChangeList) {
        super(project, (DiagramProvider)DiffUmlProvider.INSTANCE);
        LocalChangeList changeList;
        this.myStub = PsiFileFactory.getInstance((Project)project).createFileFromText("stub.txt", "");
        VcsFileRevision revision = element == null ? null : element.getRevision();
        Object object = changeList = element == null ? localChangeList : element.getVcs().loadRevisions(element.getInitialVirtualFile(), element.getRevision().getRevisionNumber());
        if (changeList != null) {
            Collection<Change> changes = DiffUmlDataModel.removeUnnecessary(changeList.getChanges());
            ArrayList<ChangeTracker> trackers = new ArrayList<ChangeTracker>();
            for (Change change : changes) {
                AbstractVcs vcs;
                DiagramChangesProvider provider = UmlDiffElement.acceptChange(change);
                PsiFile before = this.createPsiFile(project, change.getBeforeRevision());
                PsiFile after = this.createPsiFile(project, change.getAfterRevision());
                if (before == null && after == null) continue;
                VirtualFile vf = change.getVirtualFile();
                Object object2 = element != null ? element.getVcs() : (vcs = vf == null ? null : VcsUtil.getVcsFor((Project)project, (VirtualFile)vf));
                if (provider != null) {
                    ChangeTracker tracker = provider.createTracker(project, before, after);
                    if (tracker == null) continue;
                    trackers.add(tracker);
                    this.myChangeProviders.add(provider.getClass());
                    Map nodeElements = tracker.getNodeElements();
                    for (PsiNamedElement key : nodeElements.keySet()) {
                        UmlDiffNode node = new UmlDiffNode(new UmlDiffElement(vcs, revision, key, tracker, (FileStatus)nodeElements.get(key)));
                        this.myNodes.put(DiffUmlDataModel.createQualifiedName(tracker, key, vf), node);
                    }
                    continue;
                }
                UmlDiffElement diff = new UmlDiffElement(vcs, element == null ? null : revision, (PsiNamedElement)(after == null ? before : after), null, change.getFileStatus());
                if (vf == null) continue;
                this.myNodes.put("unknown://" + vf.getPath(), new UmlDiffNodeWithoutTracker(diff, before, after));
            }
            for (ChangeTracker tracker : trackers) {
                for (ChangeTracker.RelationshipInfo info : tracker.getRelationships()) {
                    PsiNamedElement toElement;
                    UmlDiffNode from = this.myNodes.get(DiffUmlDataModel.createQualifiedName(tracker, info.fromFQN));
                    UmlDiffNode to = this.myNodes.get(DiffUmlDataModel.createQualifiedName(tracker, info.toFQN));
                    if (to == null && (toElement = tracker.findElementByFQN(project, info.toFQN)) != null) {
                        to = new UmlDiffNode(new UmlDiffElement(null, null, toElement, null, FileStatus.NOT_CHANGED));
                        this.myNodes.put(DiffUmlDataModel.createQualifiedName(tracker, info.toFQN), to);
                    }
                    if (from == null || to == null) continue;
                    this.myEdges.add(new UmlDiffEdge(from, to, info));
                }
            }
        }
    }

    public boolean containsChangeProvider(@NotNull DiagramChangesProvider provider) {
        if (provider == null) {
            DiffUmlDataModel.$$$reportNull$$$0(0);
        }
        return this.myChangeProviders.contains(provider.getClass());
    }

    private static String createQualifiedName(ChangeTracker tracker, PsiNamedElement element, VirtualFile virtualFile) {
        return DiffUmlDataModel.createQualifiedName(tracker, tracker.getQualifiedName(element, virtualFile));
    }

    private static String createQualifiedName(ChangeTracker tracker, String name) {
        return tracker.getNotNullFile().getLanguage().getID() + "://" + name;
    }

    private static Collection<Change> removeUnnecessary(Collection<Change> changes) {
        HashMap<String, Change> deleted = new HashMap<String, Change>();
        HashMap<String, Change> moved = new HashMap<String, Change>();
        for (Change change : changes) {
            ContentRevision before;
            if (change.getType() == Change.Type.DELETED) {
                before = change.getBeforeRevision();
                if (before == null) continue;
                deleted.put(before.getFile().getPath(), change);
                continue;
            }
            if (change.getType() != Change.Type.MOVED || (before = change.getBeforeRevision()) == null) continue;
            moved.put(before.getFile().getPath(), change);
        }
        for (String path : moved.keySet()) {
            Change change = (Change)deleted.get(path);
            if (change == null) continue;
            changes.remove(change);
        }
        return changes;
    }

    @Nullable
    private PsiFile createPsiFile(Project project, @Nullable ContentRevision content) {
        if (content != null) {
            FilePath path = content.getFile();
            String text = null;
            try {
                text = content.getContent();
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
            if (text != null) {
                PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(path.getName(), path.getFileType(), (CharSequence)text);
                file.putUserData(PsiFileFactory.ORIGINAL_FILE, (Object)this.myStub);
                return file;
            }
        }
        return null;
    }

    @NotNull
    public Collection<DiagramNode<UmlDiffElement>> getNodes() {
        Collection<UmlDiffNode> nodes = this.myNodes.values();
        return new ArrayList<UmlDiffNode>(nodes);
    }

    @NotNull
    public Collection<DiagramEdge<UmlDiffElement>> getEdges() {
        return new ArrayList<UmlDiffEdge>(this.myEdges);
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<UmlDiffElement> n) {
        if (n == null) {
            DiffUmlDataModel.$$$reportNull$$$0(1);
        }
        String string = ((UmlDiffElement)n.getIdentifyingElement()).getNodeName();
        if (string == null) {
            DiffUmlDataModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public DiagramNode<UmlDiffElement> addElement(@Nullable UmlDiffElement element) {
        return null;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        ModificationTracker modificationTracker = () -> 0L;
        if (modificationTracker == null) {
            DiffUmlDataModel.$$$reportNull$$$0(3);
        }
        return modificationTracker;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/vcs/DiffUmlDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/vcs/DiffUmlDataModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "containsChangeProvider";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

