/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.internal.statistic.eventLog.ExternalEventLogListenerProvider;
import com.intellij.internal.statistic.eventLog.ExternalEventLogListenerProviderExtension;
import com.intellij.internal.statistic.eventLog.ExternalEventLogSettings;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogListener;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J>\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u0016\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\bJ\u0016\u0010!\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\bR/\u0010\u0006\u001a#\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n0\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\f\u001a'\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\u000e\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\u000e0\r\u00a2\u0006\u0002\b\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogListenersManager;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "subscribers", "Lcom/intellij/util/containers/MultiMap;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogListener;", "Lorg/jetbrains/annotations/NotNull;", "listenersFromEP", "Ljava/util/concurrent/ConcurrentMap;", "Lkotlin/jvm/internal/EnhancedNullability;", "subscribeFromExtension", "", "listenerProvider", "Lcom/intellij/internal/statistic/eventLog/ExternalEventLogListenerProvider;", "unsubscribeExtension", "notifySubscribers", "recorderId", "validatedEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "rawEventId", "rawData", "", "isFromLocalRecorder", "", "isLocalAllowed", "listener", "subscribe", "subscriber", "unsubscribe", "Companion", "intellij.platform.statistics"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEventLogListenersManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventLogListenersManager.kt\ncom/intellij/internal/statistic/eventLog/EventLogListenersManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,108:1\n1869#2,2:109\n1869#2,2:111\n774#2:113\n865#2,2:114\n1869#2,2:116\n1869#2,2:118\n13#3:120\n*S KotlinDebug\n*F\n+ 1 EventLogListenersManager.kt\ncom/intellij/internal/statistic/eventLog/EventLogListenersManager\n*L\n28#1:109,2\n41#1:111,2\n54#1:113\n54#1:114,2\n54#1:116,2\n67#1:118,2\n20#1:120\n*E\n"})
public final class EventLogListenersManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiMap<String, StatisticsEventLogListener> subscribers;
    @NotNull
    private ConcurrentMap<String, StatisticsEventLogListener> listenersFromEP;
    @NotNull
    private static final Logger logger;

    public EventLogListenersManager(@NotNull CoroutineScope coroutineScope) {
        ExternalEventLogListenerProvider it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        MultiMap multiMap = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrent(...)");
        this.subscribers = multiMap;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.listenersFromEP = concurrentMap;
        ExtensionsArea extensionsArea = ApplicationManager.getApplication().getExtensionArea();
        ExtensionPointName<ExternalEventLogSettings> extensionPointName = ExternalEventLogSettings.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"EP_NAME");
        if (extensionsArea.hasExtensionPoint(extensionPointName)) {
            $this$forEach$iv = ExternalEventLogSettings.EP_NAME.getExtensionList();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ExternalEventLogSettings)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.subscribeFromExtension(it);
            }
            ExternalEventLogSettings.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ExternalEventLogSettings>(){

                public void extensionAdded(ExternalEventLogSettings extension, PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    this.subscribeFromExtension(extension);
                }

                public void extensionRemoved(ExternalEventLogSettings extension, PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    this.unsubscribeExtension(extension);
                }
            });
        }
        ExtensionsArea extensionsArea2 = ApplicationManager.getApplication().getExtensionArea();
        ExtensionPointName<ExternalEventLogListenerProviderExtension> extensionPointName2 = ExternalEventLogListenerProviderExtension.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName2, (String)"EP_NAME");
        if (extensionsArea2.hasExtensionPoint(extensionPointName2)) {
            $this$forEach$iv = ExternalEventLogListenerProviderExtension.EP_NAME.getExtensionList();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ExternalEventLogListenerProviderExtension)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.subscribeFromExtension(it);
            }
            ExternalEventLogListenerProviderExtension.EP_NAME.addExtensionPointListener(coroutineScope, (ExtensionPointListener)new ExtensionPointListener<ExternalEventLogListenerProviderExtension>(){

                public void extensionAdded(ExternalEventLogListenerProviderExtension extension, PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    this.subscribeFromExtension(extension);
                }

                public void extensionRemoved(ExternalEventLogListenerProviderExtension extension, PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    this.unsubscribeExtension(extension);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void subscribeFromExtension(ExternalEventLogListenerProvider listenerProvider) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = StatisticsEventLogProviderUtil.getEventLogProviders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StatisticsEventLoggerProvider it = (StatisticsEventLoggerProvider)element$iv$iv;
            boolean bl = false;
            if (!it.isLoggingAlwaysActive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatisticsEventLogListener eventLogListener;
            StatisticsEventLoggerProvider loggerProvider = (StatisticsEventLoggerProvider)element$iv;
            boolean bl = false;
            String recorderId = loggerProvider.getRecorderId();
            if (listenerProvider.getEventLogListener(recorderId) == null) continue;
            boolean bl2 = false;
            ((Map)this.listenersFromEP).put(listenerProvider.getClass().getName(), eventLogListener);
            this.subscribe(eventLogListener, recorderId);
        }
    }

    private final void unsubscribeExtension(ExternalEventLogListenerProvider listenerProvider) {
        if (this.listenersFromEP.isEmpty()) {
            return;
        }
        StatisticsEventLogListener statisticsEventLogListener = (StatisticsEventLogListener)this.listenersFromEP.get(listenerProvider.getClass().getName());
        if (statisticsEventLogListener == null) {
            return;
        }
        StatisticsEventLogListener listener = statisticsEventLogListener;
        Iterable $this$forEach$iv = StatisticsEventLogProviderUtil.getEventLogProviders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatisticsEventLoggerProvider it = (StatisticsEventLoggerProvider)element$iv;
            boolean bl = false;
            this.unsubscribe(listener, it.getRecorderId());
        }
    }

    public final void notifySubscribers(@NotNull String recorderId, @NotNull LogEvent validatedEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData, boolean isFromLocalRecorder) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)validatedEvent, (String)"validatedEvent");
        Collection collection = this.subscribers.get((Object)recorderId);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection listeners = collection;
        for (StatisticsEventLogListener listener : listeners) {
            try {
                if (isFromLocalRecorder) {
                    Intrinsics.checkNotNull((Object)listener);
                    if (!this.isLocalAllowed(listener)) continue;
                }
                listener.onLogEvent(validatedEvent, rawEventId, rawData);
            }
            catch (Exception e) {
                logger.warnInProduction((Throwable)e);
            }
        }
    }

    private final boolean isLocalAllowed(StatisticsEventLogListener listener) {
        return Intrinsics.areEqual((Object)listener.getClass().getName(), (Object)"com.intellij.ae.database.core.baseEvents.fus.Listener");
    }

    public final void subscribe(@NotNull StatisticsEventLogListener subscriber, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        if (!PluginInfoDetectorKt.getPluginInfo(subscriber.getClass()).isDevelopedByJetBrains()) {
            return;
        }
        this.subscribers.putValue((Object)recorderId, (Object)subscriber);
    }

    public final void unsubscribe(@NotNull StatisticsEventLogListener subscriber, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        this.subscribers.remove((Object)recorderId, (Object)subscriber);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EventLogListenersManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        EventLogListenersManager.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogListenersManager$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

