/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard.splitApi.frontend.tree;

import com.intellij.execution.Executor;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardServiceDto;
import com.intellij.platform.execution.dashboard.splitApi.ServiceCustomizationDto;
import com.intellij.platform.execution.dashboard.splitApi.TextSegmentWithAttributesDto;
import com.intellij.platform.execution.dashboard.splitApi.frontend.FrontendDashboardLuxComponent;
import com.intellij.platform.execution.dashboard.splitApi.frontend.FrontendRunDashboardLuxHolder;
import com.intellij.platform.execution.dashboard.splitApi.frontend.FrontendRunDashboardManager;
import com.intellij.platform.execution.dashboard.splitApi.frontend.FrontendRunDashboardService;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class FrontendRunConfigurationNode
extends AbstractTreeNode<FrontendRunDashboardService> {
    public FrontendRunConfigurationNode(@NotNull Project project, @NotNull FrontendRunDashboardService value) {
        if (project == null) {
            FrontendRunConfigurationNode.$$$reportNull$$$0(0);
        }
        if (value == null) {
            FrontendRunConfigurationNode.$$$reportNull$$$0(1);
        }
        super(project, (Object)value);
    }

    public @Unmodifiable @NotNull Collection<? extends AbstractTreeNode<?>> getChildren() {
        List list = Collections.emptyList();
        if (list == null) {
            FrontendRunConfigurationNode.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public RunDashboardServiceDto getService() {
        RunDashboardServiceDto runDashboardServiceDto = ((FrontendRunDashboardService)this.getValue()).getRunDashboardServiceDto();
        if (runDashboardServiceDto == null) {
            FrontendRunConfigurationNode.$$$reportNull$$$0(3);
        }
        return runDashboardServiceDto;
    }

    @Nullable
    public Content getContent() {
        RunContentDescriptor descriptor = this.getDescriptor();
        return descriptor == null ? null : descriptor.getAttachedContent();
    }

    @Nullable
    public RunContentDescriptor getDescriptor() {
        return FrontendRunDashboardManager.getInstance(this.getProject()).getServiceRunContentDescriptor((FrontendRunDashboardService)this.getValue());
    }

    @Nullable
    public RunDashboardRunConfigurationStatus getStatus() {
        String statusId = FrontendRunDashboardManager.getInstance(this.getProject()).getStatusById(this.getService().getUuid());
        return RunDashboardRunConfigurationStatus.getStatusById((String)statusId);
    }

    protected void update(@NotNull PresentationData presentation) {
        SimpleTextAttributes nameAttributes;
        RunDashboardServiceDto frontendService;
        if (presentation == null) {
            FrontendRunConfigurationNode.$$$reportNull$$$0(4);
        }
        if ((frontendService = ((FrontendRunDashboardService)this.getValue()).getRunDashboardServiceDto()).isStored()) {
            boolean hasRegularOrLuxedContent = this.getContent() != null || FrontendRunDashboardLuxHolder.getInstance(this.getProject()).getComponentOrNull(frontendService.getUuid()) != null;
            nameAttributes = hasRegularOrLuxedContent ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        } else {
            nameAttributes = SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
        }
        presentation.addText(frontendService.getName(), nameAttributes);
        Icon icon = this.getNodeIcon();
        presentation.setIcon(frontendService.isStored() ? icon : IconLoader.createLazy(() -> IconLoader.getDisabledIcon((Icon)icon)));
        ServiceCustomizationDto customization = FrontendRunDashboardManager.getInstance(this.getProject()).getCustomizationById(((FrontendRunDashboardService)this.getValue()).getRunDashboardServiceDto().getUuid());
        if (customization == null) {
            return;
        }
        FrontendRunConfigurationNode.applyCustomizationToPresentation(presentation, customization);
    }

    private static void applyCustomizationToPresentation(PresentationData mutableTargetPresentation, ServiceCustomizationDto customization) {
        Icon icon;
        if (customization.getShouldClearTextAttributes()) {
            mutableTargetPresentation.clearText();
        }
        for (TextSegmentWithAttributesDto textSegment : customization.getText()) {
            mutableTargetPresentation.addText(textSegment.getValue(), textSegment.getAttributes().getSimpleTextAttributes());
        }
        Icon icon2 = icon = customization.getIconId() == null ? null : IconIdKt.icon((IconId)customization.getIconId());
        if (icon != null) {
            mutableTargetPresentation.setIcon(icon);
        }
    }

    private Icon getNodeIcon() {
        Icon icon = null;
        RunDashboardRunConfigurationStatus status = this.getStatus();
        if (RunDashboardRunConfigurationStatus.STARTED.equals(status)) {
            icon = this.getExecutorIcon();
        } else if (RunDashboardRunConfigurationStatus.FAILED.equals(status)) {
            icon = status.getIcon();
        }
        if (icon == null) {
            IconId iconId = ((FrontendRunDashboardService)this.getValue()).getRunDashboardServiceDto().getIconId();
            icon = iconId == null ? null : IconIdKt.icon((IconId)iconId);
        }
        return icon;
    }

    @Nullable
    private Icon getExecutorIcon() {
        Executor executor;
        FrontendDashboardLuxComponent luxedComponent = FrontendRunDashboardLuxHolder.getInstance(this.myProject).getComponentOrNull(((FrontendRunDashboardService)this.getValue()).getRunDashboardServiceDto().getUuid());
        if (luxedComponent != null && "Run".equals(luxedComponent.getExecutorId())) {
            return DefaultRunExecutor.getRunExecutorInstance().getIcon();
        }
        Content content = this.getContent();
        if (content != null && !RunContentManagerImpl.isTerminated((Content)content) && (executor = RunContentManagerImpl.getExecutorByContent((Content)content)) != null) {
            return executor.getIcon();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/dashboard/splitApi/frontend/tree/FrontendRunConfigurationNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/dashboard/splitApi/frontend/tree/FrontendRunConfigurationNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

