/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.elements;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.elements.TwigArrayLiteral;
import com.jetbrains.twig.elements.TwigArrayValue;
import com.jetbrains.twig.elements.TwigCompositeElement;
import com.jetbrains.twig.elements.TwigElementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigTagWithFileReference
extends TwigCompositeElement {
    public TwigTagWithFileReference(@NotNull ASTNode node) {
        if (node == null) {
            TwigTagWithFileReference.$$$reportNull$$$0(0);
        }
        super(node);
    }

    private static PsiElement[] getNonWhitespaceChildren(@NotNull PsiElement element) {
        if (element == null) {
            TwigTagWithFileReference.$$$reportNull$$$0(1);
        }
        LinkedList<PsiElement> result = new LinkedList<PsiElement>();
        for (PsiElement firstChild = element.getFirstChild(); firstChild != null; firstChild = firstChild.getNextSibling()) {
            if (firstChild instanceof PsiWhiteSpace) continue;
            result.add(firstChild);
        }
        return result.toArray(PsiElement.EMPTY_ARRAY);
    }

    @Nullable
    private static PsiElement extractStringText(@NotNull TwigArrayValue arrayValue) {
        if (arrayValue == null) {
            TwigTagWithFileReference.$$$reportNull$$$0(2);
        }
        for (PsiElement nextSibling = arrayValue.getFirstChild(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (nextSibling.getNode().getElementType() != TwigTokenTypes.STRING_TEXT) continue;
            return nextSibling;
        }
        return null;
    }

    @Nullable
    private static PsiElement getNextSiblingIgnoreWhiteSpace(@NotNull PsiElement element) {
        if (element == null) {
            TwigTagWithFileReference.$$$reportNull$$$0(3);
        }
        for (PsiElement nextSibling = element.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (nextSibling instanceof PsiWhiteSpace) continue;
            return nextSibling;
        }
        return null;
    }

    protected Collection<PsiElement> findFileNameElements() {
        TwigArrayLiteral arrayLiteral = (TwigArrayLiteral)PsiTreeUtil.getChildOfType((PsiElement)this, TwigArrayLiteral.class);
        if (arrayLiteral != null) {
            return TwigTagWithFileReference.extractFileNamesFromArrayLiteral(arrayLiteral);
        }
        PsiElement fileNameFromStringText = this.extractNameElementFromStringText();
        if (fileNameFromStringText != null) {
            return List.of(fileNameFromStringText);
        }
        return ContainerUtil.emptyList();
    }

    private static Collection<PsiElement> extractFileNamesFromArrayLiteral(@NotNull TwigArrayLiteral arrayLiteral) {
        PsiElement nextSibling;
        if (arrayLiteral == null) {
            TwigTagWithFileReference.$$$reportNull$$$0(4);
        }
        if ((nextSibling = TwigTagWithFileReference.getNextSiblingIgnoreWhiteSpace((PsiElement)arrayLiteral)) == null) {
            return ContainerUtil.emptyList();
        }
        if (!TwigTagWithFileReference.isFileNamesPartFinished(nextSibling.getNode().getElementType())) {
            return ContainerUtil.emptyList();
        }
        return arrayLiteral.getArrayValues().stream().map(v -> TwigTagWithFileReference.extractStringText(v)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static boolean isFileNamesPartFinished(IElementType elementType) {
        return elementType == TwigTokenTypes.STATEMENT_BLOCK_END || elementType == TwigTokenTypes.IDENTIFIER || elementType == TwigTokenTypes.WITH_KEYWORD;
    }

    @Nullable
    protected PsiElement extractNameElementFromStringText() {
        IElementType endQuote;
        PsiElement[] children = TwigTagWithFileReference.getNonWhitespaceChildren((PsiElement)this);
        if (children.length < 6) {
            return null;
        }
        IElementType startQuote = children[2].getNode().getElementType();
        if (startQuote != (endQuote = children[4].getNode().getElementType())) {
            return null;
        }
        if (startQuote != TwigTokenTypes.DOUBLE_QUOTE && startQuote != TwigTokenTypes.SINGLE_QUOTE) {
            return null;
        }
        if (!TwigTagWithFileReference.isFileNamesPartFinished(children[5].getNode().getElementType())) {
            return null;
        }
        return children[3];
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])this.findFileNameElements().stream().map(e -> new TwigFileReferenceSet((PsiElement)this, (PsiElement)e)).flatMap(s -> Arrays.stream(s.getAllReferences())).toArray(PsiReference[]::new);
        if (psiReferenceArray == null) {
            TwigTagWithFileReference.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    public int getTextOffset() {
        PsiElement element = this.getNavigationElement();
        return element.getTextRange().getStartOffset();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        Collection<PsiElement> fileNameElements = this.findFileNameElements();
        if (!fileNameElements.isEmpty()) {
            PsiElement psiElement = fileNameElements.iterator().next();
            if (psiElement == null) {
                TwigTagWithFileReference.$$$reportNull$$$0(6);
            }
            return psiElement;
        }
        TwigTagWithFileReference twigTagWithFileReference = this;
        if (twigTagWithFileReference == null) {
            TwigTagWithFileReference.$$$reportNull$$$0(7);
        }
        return twigTagWithFileReference;
    }

    public void changeFileName(String newName, @NotNull TextRange range) {
        if (range == null) {
            TwigTagWithFileReference.$$$reportNull$$$0(8);
        }
        this.findFileNameElements().stream().filter(e -> e.getTextRange().contains(range)).forEach(e -> {
            PsiElement newNameElement = TwigElementFactory.createPsiElement(this.getProject(), "{% block '" + newName + "' %}", TwigTokenTypes.STRING_TEXT);
            if (newNameElement != null) {
                e.replace(newNameElement);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayLiteral";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/elements/TwigTagWithFileReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/elements/TwigTagWithFileReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNonWhitespaceChildren";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractStringText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNextSiblingIgnoreWhiteSpace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractFileNamesFromArrayLiteral";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "changeFileName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    static class TwigFileReferenceSet
    extends FileReferenceSet {
        TwigFileReferenceSet(@NotNull PsiElement refElement, @NotNull PsiElement pathElement) {
            if (refElement == null) {
                TwigFileReferenceSet.$$$reportNull$$$0(0);
            }
            if (pathElement == null) {
                TwigFileReferenceSet.$$$reportNull$$$0(1);
            }
            super(FileUtil.toSystemIndependentName((String)pathElement.getText()), refElement, pathElement.getTextRange().getStartOffset(), null, SystemInfo.isFileSystemCaseSensitive, true);
            this.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> {
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)refElement.getProject());
                List templatedDirectories = Arrays.stream(projectRootManager.getContentRoots()).map(r -> r.findChild("templates")).filter(Objects::nonNull).map(v -> refElement.getManager().findDirectory(v)).filter(Objects::nonNull).collect(Collectors.toList());
                return templatedDirectories.isEmpty() ? Collections.singleton(file.getParent()) : templatedDirectories;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pathElement";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/twig/elements/TwigTagWithFileReference$TwigFileReferenceSet";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

