/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.ui;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.jetbrains.twig.TwigBundle;
import com.jetbrains.twig.TwigConfiguration;
import com.jetbrains.twig.ui.TwigSettingsForm;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private TwigSettingsForm myForm;
    private final Project myProject;

    public TwigConfigurable(Project project) {
        this.myProject = project;
        this.myForm = new TwigSettingsForm();
    }

    @NotNull
    public String getId() {
        return "Configurable.PHP.Twig";
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return TwigBundle.message("language.name", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        this.myForm = new TwigSettingsForm();
        return this.myForm.createComponent();
    }

    public boolean isModified() {
        return this.myForm.isModified(TwigConfiguration.getInstance(this.myProject));
    }

    public String getHelpTopic() {
        return "reference.settings.php.twig";
    }

    public void apply() {
        this.myForm.apply(TwigConfiguration.getInstance(this.myProject));
    }

    public void reset() {
        if (this.myForm != null) {
            this.myForm.reset(TwigConfiguration.getInstance(this.myProject).getState());
        }
    }
}

