/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.apacheConfig.rewriting;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.apacheConfig.lexer.ApacheConfigTokenTypes;
import com.intellij.lang.apacheConfig.psi.ACArgument;
import com.intellij.lang.apacheConfig.psi.ACDirectiveBase;
import com.intellij.lang.apacheConfig.psi.ACPsiUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.List;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;

public class RegexLanguageInjector
implements LanguageInjector {
    public void getLanguagesToInject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces injectionPlacesRegistrar) {
        if (host == null) {
            RegexLanguageInjector.$$$reportNull$$$0(0);
        }
        if (injectionPlacesRegistrar == null) {
            RegexLanguageInjector.$$$reportNull$$$0(1);
        }
        if (!(host instanceof ACArgument)) {
            return;
        }
        ACDirectiveBase directiveBase = ACPsiUtils.getDirectiveBase((PsiElement)host);
        if (directiveBase == null) {
            return;
        }
        String name = directiveBase.getName();
        List<ACArgument> arguments = directiveBase.getArguments();
        if ("RewriteRule".equals(name)) {
            if (arguments.get(0) == host) {
                RegexLanguageInjector.inject(host, injectionPlacesRegistrar);
            }
        } else if ("FilesMatch".equals(name)) {
            RegexLanguageInjector.inject(host, injectionPlacesRegistrar);
        } else if ("Files".equals(name)) {
            if (arguments.size() == 2 && arguments.get(1) == host && arguments.get(0).getText().equals("~")) {
                RegexLanguageInjector.inject(host, injectionPlacesRegistrar);
            }
        } else if ("BrowserMatch".equals(name) || "BrowserMatchNoCase".equals(name)) {
            if (arguments.get(0) == host) {
                RegexLanguageInjector.inject(host, injectionPlacesRegistrar);
            }
        } else if ("RedirectMatch".equals(name)) {
            if (arguments.size() == 3 && arguments.get(1) == host || arguments.size() == 2 && arguments.get(0) == host) {
                RegexLanguageInjector.inject(host, injectionPlacesRegistrar);
            }
        } else if (("SetEnvIf".equals(name) || "SetEnvIfNoCase".equals(name)) && arguments.size() >= 2 && arguments.get(1) == host) {
            RegexLanguageInjector.inject(host, injectionPlacesRegistrar);
        }
    }

    private static void inject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces injectionPlacesRegistrar) {
        if (host == null) {
            RegexLanguageInjector.$$$reportNull$$$0(2);
        }
        if (injectionPlacesRegistrar == null) {
            RegexLanguageInjector.$$$reportNull$$$0(3);
        }
        injectionPlacesRegistrar.addPlace((Language)RegExpLanguage.INSTANCE, RegexLanguageInjector.getInjectionTextRange(host), null, null);
    }

    @NotNull
    private static TextRange getInjectionTextRange(@NotNull PsiLanguageInjectionHost host) {
        ASTNode node;
        if (host == null) {
            RegexLanguageInjector.$$$reportNull$$$0(4);
        }
        if ((node = host.getNode()) != null) {
            ASTNode lexem = node.findChildByType(ApacheConfigTokenTypes.ARG_LEXEM);
            if (lexem != null) {
                TextRange lexemRange;
                TextRange parent = host.getTextRange();
                if (parent.contains(lexemRange = lexem.getTextRange())) {
                    int start = lexemRange.getStartOffset() - parent.getStartOffset();
                    return new TextRange(start, start + lexemRange.getLength());
                }
            } else {
                ASTNode close;
                PsiElement sibling;
                ASTNode open = node.findChildByType(ApacheConfigTokenTypes.QUOTE);
                PsiElement psiElement = sibling = open == null ? null : open.getPsi().getNextSibling();
                if (sibling != null && sibling.getNode() != null && (close = node.findChildByType(ApacheConfigTokenTypes.QUOTE, sibling.getNode())) != null) {
                    TextRange parent = host.getTextRange();
                    int openEndOffset = open.getTextRange().getEndOffset();
                    int start = openEndOffset - parent.getStartOffset();
                    int end = start + (close.getStartOffset() - openEndOffset);
                    if (start >= 0 && end <= parent.getEndOffset()) {
                        return new TextRange(start, end);
                    }
                }
            }
        }
        return new TextRange(0, host.getTextLength());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPlacesRegistrar";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/apacheConfig/rewriting/RegexLanguageInjector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagesToInject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getInjectionTextRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

