/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.text;

import com.github.weisj.jsvg.attributes.PaintOrder;
import com.github.weisj.jsvg.attributes.VectorEffect;
import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.text.Glyph;
import com.github.weisj.jsvg.nodes.text.GlyphCursor;
import com.github.weisj.jsvg.nodes.text.StringTextSegment;
import com.github.weisj.jsvg.renderer.FontRenderContext;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.renderer.ShapeRenderer;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class GlyphRenderer {
    private static final boolean DEBUG = false;

    private GlyphRenderer() {
    }

    static void prepareGlyphRun(@NotNull StringTextSegment segment2, @NotNull GlyphCursor cursor, @NotNull SVGFont font, @NotNull RenderContext context) {
        MeasureContext measure = context.measureContext();
        Shape glyphRun = GlyphRenderer.layoutGlyphRun(segment2, cursor, font, measure, context.fontRenderContext());
        Rectangle2D bounds = glyphRun.getBounds2D();
        if (Length.isUnspecified((float)cursor.completeGlyphRunBounds.getX())) {
            cursor.completeGlyphRunBounds.setRect(bounds);
        } else {
            Rectangle2D.union(cursor.completeGlyphRunBounds, bounds, cursor.completeGlyphRunBounds);
        }
        segment2.currentGlyphRun = glyphRun;
        segment2.currentRenderContext = context;
    }

    static void renderGlyphRun(@NotNull Graphics2D g, @NotNull PaintOrder paintOrder, @NotNull Set<VectorEffect> vectorEffects, @NotNull StringTextSegment segment2, @NotNull Rectangle2D completeGlyphRunBounds) {
        RenderContext context = segment2.currentRenderContext;
        assert (context != null);
        Shape glyphRun = segment2.currentGlyphRun;
        assert (glyphRun != null);
        Stroke stroke2 = context.stroke(1.0f);
        ShapeRenderer.renderWithPaintOrder(g, true, paintOrder, new ShapeRenderer.ShapePaintContext(context, vectorEffects, stroke2, null), new ShapeRenderer.PaintShape(glyphRun, completeGlyphRunBounds), null);
        segment2.currentRenderContext = null;
        segment2.currentGlyphRun = null;
    }

    static Shape layoutGlyphRun(@NotNull StringTextSegment segment2, @NotNull GlyphCursor cursor, @NotNull SVGFont font, @NotNull MeasureContext measure, @NotNull FontRenderContext fontRenderContext) {
        float letterSpacing = fontRenderContext.letterSpacing().resolveLength(measure);
        Path2D.Float glyphPath = new Path2D.Float();
        boolean isLastSegment = segment2.isLastSegmentInParent();
        boolean shouldSkipLastSpacing = isLastSegment && cursor.advancement().shouldSkipLastSpacing();
        char[] codepoints = segment2.codepoints();
        int count2 = codepoints.length;
        for (int i = 0; i < count2; ++i) {
            boolean skipSpacing;
            char codepoint = codepoints[i];
            boolean lastCodepoint = i == count2 - 1;
            Glyph glyph = font.codepointGlyph(codepoint);
            AffineTransform glyphTransform = cursor.advance(measure, glyph);
            boolean bl = skipSpacing = lastCodepoint && shouldSkipLastSpacing;
            if (!skipSpacing) {
                cursor.advanceSpacing(letterSpacing);
            }
            if (glyphTransform == null) break;
            if (!glyph.isRendered()) continue;
            Shape glyphOutline = glyph.glyphOutline();
            float baselineOffset = GlyphRenderer.computeBaselineOffset(font, fontRenderContext);
            glyphTransform.translate(0.0, -baselineOffset);
            Shape renderPath = glyphTransform.createTransformedShape(glyphOutline);
            glyphPath.append(renderPath, false);
        }
        return glyphPath;
    }

    private static float computeBaselineOffset(@NotNull SVGFont font, @NotNull FontRenderContext fontRenderContext) {
        switch (fontRenderContext.dominantBaseline()) {
            default: {
                return font.romanBaseline();
            }
            case Hanging: {
                return font.hangingBaseline();
            }
            case Central: {
                return font.centerBaseline();
            }
            case Middle: {
                return font.middleBaseline();
            }
            case Mathematical: {
                return font.mathematicalBaseline();
            }
            case Ideographic: 
            case TextAfterEdge: 
            case TextBottom: {
                return font.textUnderBaseline();
            }
            case TextBeforeEdge: 
            case TextTop: 
        }
        return font.textOverBaseline();
    }
}

