/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class RegexFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 4269646126155225062L;
    private final Pattern pattern;
    private final transient Function<Path, String> pathToString;

    private static Pattern compile(String pattern2, int flags) {
        Objects.requireNonNull(pattern2, "pattern");
        return Pattern.compile(pattern2, flags);
    }

    private static int toFlags(IOCase ioCase) {
        return IOCase.isCaseSensitive(ioCase) ? 0 : 2;
    }

    public RegexFileFilter(Pattern pattern2) {
        this(pattern2, PathUtils::getFileNameString);
    }

    public RegexFileFilter(Pattern pattern2, Function<Path, String> pathToString) {
        Objects.requireNonNull(pattern2, "pattern");
        this.pattern = pattern2;
        this.pathToString = pathToString != null ? pathToString : Objects::toString;
    }

    public RegexFileFilter(String pattern2) {
        this(pattern2, 0);
    }

    public RegexFileFilter(String pattern2, int flags) {
        this(RegexFileFilter.compile(pattern2, flags));
    }

    public RegexFileFilter(String pattern2, IOCase ioCase) {
        this(RegexFileFilter.compile(pattern2, RegexFileFilter.toFlags(ioCase)));
    }

    @Override
    public boolean accept(File dir, String name) {
        return this.pattern.matcher(name).matches();
    }

    @Override
    public FileVisitResult accept(Path path2, BasicFileAttributes attributes2) {
        String result2 = this.pathToString.apply(path2);
        return this.toFileVisitResult(result2 != null && this.pattern.matcher(result2).matches());
    }

    @Override
    public String toString() {
        return "RegexFileFilter [pattern=" + this.pattern + "]";
    }
}

