/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.interact.context;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.builder.interact.context.DataBoundsFix;
import org.jetbrains.letsPlot.core.plot.builder.interact.context.DataSelectionStrategy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/interact/context/MouseDragSelectionStrategy;", "Lorg/jetbrains/letsPlot/core/plot/builder/interact/context/DataSelectionStrategy;", "()V", "clientRectToDataBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "clientRect", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "plot-builder"})
public final class MouseDragSelectionStrategy
implements DataSelectionStrategy {
    @Override
    @NotNull
    public DoubleRectangle clientRectToDataBounds(@NotNull DoubleRectangle clientRect, @NotNull CoordinateSystem coord) {
        Intrinsics.checkNotNullParameter((Object)clientRect, (String)"clientRect");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        DoubleVector doubleVector = coord.fromClient(clientRect.getOrigin());
        if (doubleVector == null) {
            throw new IllegalStateException(("Can't translate client " + clientRect.getOrigin() + " to data domain.").toString());
        }
        DoubleVector domainPoint0Estimate = doubleVector;
        DoubleVector doubleVector2 = coord.toClient(domainPoint0Estimate);
        if (doubleVector2 == null) {
            doubleVector2 = clientRect.getOrigin();
        }
        DoubleVector clientTopLeft = doubleVector2;
        DoubleVector clientBottomRight = clientTopLeft.add(clientRect.getDimension());
        DoubleVector doubleVector3 = coord.fromClient(clientBottomRight);
        if (doubleVector3 == null) {
            throw new IllegalStateException(("Can't translate client " + clientBottomRight + " to data domain.").toString());
        }
        DoubleVector domainPoint1 = doubleVector3;
        DoubleVector doubleVector4 = coord.toClient(domainPoint1);
        if (doubleVector4 == null) {
            doubleVector4 = clientBottomRight;
        }
        DoubleVector clientBottomRightValid = doubleVector4;
        DoubleVector it = clientBottomRightValid.subtract(clientRect.getDimension());
        boolean bl = false;
        DoubleVector doubleVector5 = coord.fromClient(it);
        if (doubleVector5 == null) {
            throw new IllegalStateException(("Can't translate client " + it + " to data domain.").toString());
        }
        DoubleVector domainPoint0 = doubleVector5;
        DoubleRectangle it2 = DoubleRectangle.Companion.span(domainPoint0, domainPoint1);
        boolean bl2 = false;
        DoubleRectangle dataBounds = DataBoundsFix.INSTANCE.unImplode(it2);
        return dataBounds;
    }
}

