/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.DataType;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.FormatterUtil;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JL\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u000b\u001a\u00020\f2\u001e\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J(\u0010\u0013\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\t0\u00042\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017R)\u0010\u0003\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipFormatting;", "", "()V", "FALLBACK_NUMBER_FORMATTER", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "v", "", "createFormatter", "variable", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "formatters", "", "expFormat", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "fromScale", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "plot-builder"})
public final class TooltipFormatting {
    @NotNull
    public static final TooltipFormatting INSTANCE = new TooltipFormatting();
    @NotNull
    private static final Function1<Number, String> FALLBACK_NUMBER_FORMATTER = (Function1)new Function1<Object, String>((Object)StringFormat.Companion.forOneArg$default(StringFormat.Companion, ".2f", StringFormat.FormatType.NUMBER_FORMAT, null, null, null, 12, null)){

        @NotNull
        public final String invoke(@NotNull Object p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return ((StringFormat)this.receiver).format(p0);
        }
    };

    private TooltipFormatting() {
    }

    @NotNull
    public final Function1<Object, String> fromScale(@NotNull Aes<?> aes2, @NotNull PlotContext ctx2) {
        Function1<Object, String> function1;
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        if (!(!Aes.Companion.isPositionalXY(aes2) || Intrinsics.areEqual(aes2, Aes.Companion.getX()) || Intrinsics.areEqual(aes2, Aes.Companion.getY()))) {
            boolean $i$a$-check-TooltipFormatting$fromScale$22 = false;
            String $i$a$-check-TooltipFormatting$fromScale$22 = "Positional aesthetic should be either X or Y but was " + aes2;
            throw new IllegalStateException($i$a$-check-TooltipFormatting$fromScale$22.toString());
        }
        Scale scale = ctx2.getScale(aes2);
        if (scale.isContinuousDomain()) {
            if (scale.getUserFormatter() != null) {
                Function1<Object, String> function12 = scale.getUserFormatter();
                function1 = function12;
                Intrinsics.checkNotNull(function12);
            } else {
                DoubleSpan domain = ctx2.overallTransformedDomain(aes2);
                function1 = scale.getBreaksGenerator().defaultFormatter(domain, 100);
            }
        } else {
            Map<Object, String> labelsMap = ScaleUtil.INSTANCE.labelByBreak(scale);
            function1 = new Function1<Object, String>(labelsMap){
                final /* synthetic */ Map<Object, String> $labelsMap;
                {
                    this.$labelsMap = $labelsMap;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull Object v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    Object object = v;
                    return this.$labelsMap.containsKey(object) ? (String)MapsKt.getValue(this.$labelsMap, (Object)v) : (object instanceof Number ? (String)TooltipFormatting.access$getFALLBACK_NUMBER_FORMATTER$p().invoke(v) : null);
                }
            };
        }
        Function1<Object, String> formatter2 = function1;
        return (Function1)new Function1<Object, String>(formatter2){
            final /* synthetic */ Function1<Object, String> $formatter;
            {
                this.$formatter = $formatter;
                super(1);
            }

            @NotNull
            public final String invoke(@Nullable Object value) {
                Object object;
                block3: {
                    block2: {
                        object = value;
                        if (object == null) break block2;
                        Object object2 = object;
                        Function1<Object, String> function1 = this.$formatter;
                        Object it = object2;
                        boolean bl = false;
                        String string = (String)function1.invoke(it);
                        object = string;
                        if (string != null) break block3;
                    }
                    object = "n/a";
                }
                return object;
            }
        };
    }

    @NotNull
    public final Function1<Object, String> createFormatter(@NotNull DataFrame.Variable variable, @NotNull Map<Object, ? extends Function1<Object, String>> formatters, @NotNull StringFormat.ExponentFormat expFormat, @Nullable TimeZone tz) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter(formatters, (String)"formatters");
        Intrinsics.checkNotNullParameter((Object)expFormat, (String)"expFormat");
        DataFrame.Variable variable2 = variable;
        if (Intrinsics.areEqual((Object)variable2, (Object)Stats.INSTANCE.getPROP()) ? true : Intrinsics.areEqual((Object)variable2, (Object)Stats.INSTANCE.getSUMPROP())) {
            function1 = (Function1)new Function1<Object, String>((Object)StringFormat.Companion.forOneArg$default(StringFormat.Companion, ".2f", null, variable.getName(), expFormat, tz, 2, null)){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((StringFormat)this.receiver).format(p0);
                }
            };
        } else if (Intrinsics.areEqual((Object)variable2, (Object)Stats.INSTANCE.getPROPPCT()) ? true : Intrinsics.areEqual((Object)variable2, (Object)Stats.INSTANCE.getSUMPCT())) {
            function1 = (Function1)new Function1<Object, String>((Object)StringFormat.Companion.forOneArg$default(StringFormat.Companion, "{.1f} %", null, variable.getName(), expFormat, tz, 2, null)){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((StringFormat)this.receiver).format(p0);
                }
            };
        } else {
            function1 = formatters.get(variable.getName());
            if (function1 == null) {
                function1 = FormatterUtil.INSTANCE.byDataType(DataType.UNKNOWN, expFormat, tz);
            }
        }
        return function1;
    }

    public static final /* synthetic */ Function1 access$getFALLBACK_NUMBER_FORMATTER$p() {
        return FALLBACK_NUMBER_FORMATTER;
    }
}

