/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.base.theme.ExponentFormat;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotAssembler;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.assemble.facet.FacetGrid;
import org.jetbrains.letsPlot.core.plot.builder.assemble.facet.FacetScales;
import org.jetbrains.letsPlot.core.plot.builder.assemble.facet.FacetWrap;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB+\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0016\u0010\u0010\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0016\u0010\u0011\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u001e\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/FacetConfig;", "Lorg/jetbrains/letsPlot/core/spec/config/OptionsAccessor;", "options", "", "", "", "expFormat", "Lorg/jetbrains/letsPlot/core/plot/base/theme/ExponentFormat;", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/base/theme/ExponentFormat;Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;)V", "createFacets", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "dataByLayer", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "createGrid", "createWrap", "getDirOption", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/facet/FacetWrap$Direction;", "getFormatterOption", "Lkotlin/Function1;", "optionName", "getLabWidthOption", "", "getOrderOption", "getScalesOption", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/facet/FacetScales;", "toFormatterVal", "optionVal", "toOrderVal", "Companion", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nFacetConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetConfig.kt\norg/jetbrains/letsPlot/core/spec/config/FacetConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1549#2:282\n1620#2,3:283\n1549#2:287\n1620#2,3:288\n1549#2:291\n1620#2,3:292\n1#3:286\n*S KotlinDebug\n*F\n+ 1 FacetConfig.kt\norg/jetbrains/letsPlot/core/spec/config/FacetConfig\n*L\n113#1:282\n113#1:283,3\n120#1:287\n120#1:288,3\n127#1:291\n127#1:292,3\n*E\n"})
public final class FacetConfig
extends OptionsAccessor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ExponentFormat expFormat;
    @Nullable
    private final TimeZone tz;

    public FacetConfig(@NotNull Map<String, ? extends Object> options, @NotNull ExponentFormat expFormat, @Nullable TimeZone tz) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)expFormat, (String)"expFormat");
        super(options, null, 2, null);
        this.expFormat = expFormat;
        this.tz = tz;
    }

    @NotNull
    public final PlotFacets createFacets(@NotNull List<DataFrame> dataByLayer) {
        PlotFacets plotFacets;
        Intrinsics.checkNotNullParameter(dataByLayer, (String)"dataByLayer");
        String name = this.getStringSafe("name");
        if (Intrinsics.areEqual((Object)name, (Object)"grid")) {
            plotFacets = this.createGrid(dataByLayer);
        } else if (Intrinsics.areEqual((Object)name, (Object)"wrap")) {
            plotFacets = this.createWrap(dataByLayer);
        } else {
            throw new IllegalArgumentException("Facet 'grid' or 'wrap' expected but was: `" + name + '`');
        }
        return plotFacets;
    }

    private final PlotFacets createGrid(List<DataFrame> dataByLayer) {
        String nameX = null;
        LinkedHashSet levelsX = new LinkedHashSet();
        if (this.has("x")) {
            nameX = this.getStringSafe("x");
            for (DataFrame data : dataByLayer) {
                if (!DataFrameUtil.INSTANCE.hasVariable(data, nameX)) continue;
                DataFrame.Variable variable = DataFrameUtil.INSTANCE.findVariableOrFail(data, nameX);
                levelsX.addAll(data.distinctValues(variable));
            }
        }
        String nameY = null;
        LinkedHashSet levelsY = new LinkedHashSet();
        if (this.has("y")) {
            nameY = this.getStringSafe("y");
            for (DataFrame data : dataByLayer) {
                if (!DataFrameUtil.INSTANCE.hasVariable(data, nameY)) continue;
                DataFrame.Variable variable = DataFrameUtil.INSTANCE.findVariableOrFail(data, nameY);
                levelsY.addAll(data.distinctValues(variable));
            }
        }
        FacetScales scales = this.getScalesOption();
        int xOrder = this.getOrderOption("x_order");
        int yOrder = this.getOrderOption("y_order");
        List<Object> xLevels = Companion.reorderVarLevels(nameX, CollectionsKt.toList((Iterable)levelsX), xOrder);
        List<Object> yLevels = Companion.reorderVarLevels(nameY, CollectionsKt.toList((Iterable)levelsY), yOrder);
        return new FacetGrid(nameX, nameY, xLevels, yLevels, this.getFormatterOption("x_format"), this.getFormatterOption("y_format"), scales, this.getLabWidthOption("x_labwidth"), this.getLabWidthOption("y_labwidth"));
    }

    /*
     * WARNING - void declaration
     */
    private final PlotFacets createWrap(List<DataFrame> dataByLayer) {
        ArrayList $this$mapTo$iv$iv;
        Iterator it4;
        ArrayList $this$mapTo$iv$iv2;
        ArrayList<Integer> arrayList;
        Iterator it22;
        Collection collection;
        ArrayList<Integer> $this$mapTo$iv$iv3;
        List<String> facets = this.getAsStringList("facets");
        Integer ncol = this.getInteger("ncol");
        Integer nrow = this.getInteger("nrow");
        ArrayList<List> facetLevels = new ArrayList<List>();
        for (String name : facets) {
            LinkedHashSet levels = new LinkedHashSet();
            for (DataFrame data : dataByLayer) {
                if (!DataFrameUtil.INSTANCE.hasVariable(data, name)) continue;
                DataFrame.Variable variable = DataFrameUtil.INSTANCE.findVariableOrFail(data, name);
                levels.addAll(data.distinctValues(variable));
            }
            facetLevels.add(CollectionsKt.toList((Iterable)levels));
        }
        Iterable $this$map$iv = this.getAsList("order");
        int $i$f$map = 0;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        int $i$f$mapTo22 = 0;
        Iterator iterator2 = $this$mapTo$iv$iv3.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            collection = destination$iv$iv22;
            boolean bl = false;
            collection.add(this.toOrderVal(it22));
        }
        List orderOption = (List)destination$iv$iv22;
        $i$f$map = facets.size();
        collection = orderOption;
        $this$mapTo$iv$iv3 = new ArrayList<Integer>($i$f$map);
        int destination$iv$iv22 = 0;
        while (destination$iv$iv22 < $i$f$map) {
            int n = $i$f$mapTo22 = destination$iv$iv22++;
            arrayList = $this$mapTo$iv$iv3;
            boolean bl = false;
            arrayList.add(0);
        }
        List facetOrdering = CollectionsKt.take((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)$this$mapTo$iv$iv3), (int)facets.size());
        Iterable $this$map$iv2 = this.getAsList("format");
        int $i$f$map2 = 0;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        int $i$f$mapTo32 = 0;
        it22 = $this$mapTo$iv$iv2.iterator();
        while (it22.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = it22.next();
            collection = destination$iv$iv32;
            boolean bl = false;
            collection.add(this.toFormatterVal(it4));
        }
        List formatterOption = (List)destination$iv$iv32;
        $i$f$map2 = facets.size();
        collection = formatterOption;
        $this$mapTo$iv$iv2 = new ArrayList($i$f$map2);
        int destination$iv$iv32 = 0;
        while (destination$iv$iv32 < $i$f$map2) {
            int it22 = $i$f$mapTo32 = destination$iv$iv32++;
            arrayList = $this$mapTo$iv$iv2;
            boolean bl = false;
            arrayList.add((Integer)PlotFacets.Companion.getDEF_FORMATTER());
        }
        List formatters = CollectionsKt.take((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)$this$mapTo$iv$iv2), (int)facets.size());
        Iterable $this$map$iv3 = this.getAsList("labwidth");
        int $i$f$map3 = 0;
        Iterable $i$f$mapTo32 = $this$map$iv3;
        Collection destination$iv$iv42 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        int $i$f$mapTo = 0;
        it4 = $this$mapTo$iv$iv.iterator();
        while (it4.hasNext()) {
            void it3;
            Object item$iv$iv;
            Object t = item$iv$iv = it4.next();
            collection = destination$iv$iv42;
            boolean bl = false;
            Number number = it3 instanceof Number ? (Number)((Number)it3) : (Number)null;
            collection.add(number != null ? number.intValue() : -1);
        }
        List labWidthOption = (List)destination$iv$iv42;
        $i$f$map3 = facets.size();
        collection = labWidthOption;
        $this$mapTo$iv$iv = new ArrayList($i$f$map3);
        int destination$iv$iv42 = 0;
        while (destination$iv$iv42 < $i$f$map3) {
            int it4 = $i$f$mapTo = destination$iv$iv42++;
            arrayList = $this$mapTo$iv$iv;
            boolean bl = false;
            arrayList.add(-1);
        }
        List labWidths = CollectionsKt.take((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)$this$mapTo$iv$iv), (int)facets.size());
        FacetScales scales = this.getScalesOption();
        List<List<Object>> orderedFacetLevels = Companion.reorderLevels(facets, (List<? extends List<? extends Object>>)facetLevels, facetOrdering);
        List<List<Pair<String, Object>>> varNameAndLevelPairsByTileRaw = PlotFacets.Companion.varNameAndLevelPairsByTile(facets, orderedFacetLevels);
        boolean dropUnusedLevels = this.getBoolean("drop", true);
        List<List<Pair<String, Object>>> varNameAndLevelPairsByTile = dropUnusedLevels ? Companion.filterUnusedLevels(dataByLayer, varNameAndLevelPairsByTileRaw) : varNameAndLevelPairsByTileRaw;
        return new FacetWrap(facets, varNameAndLevelPairsByTile, nrow, ncol, this.getDirOption(), formatters, scales, labWidths);
    }

    private final int getOrderOption(String optionName) {
        return this.toOrderVal(this.get(optionName));
    }

    private final int toOrderVal(Object optionVal) {
        int n;
        Object object = optionVal;
        if (object == null) {
            n = 0;
        } else if (object instanceof Number) {
            n = ((Number)optionVal).intValue();
        } else {
            throw new IllegalArgumentException("Unsupported `order` value: " + optionVal + ".\nUse: 1 (natural), -1 (descending) or 0 (no ordering).");
        }
        return n;
    }

    private final FacetWrap.Direction getDirOption() {
        FacetWrap.Direction direction;
        Object opt = this.get("dir");
        if (opt == null) {
            direction = FacetWrap.Direction.H;
        } else {
            String string = opt.toString().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String string2 = string;
            if (Intrinsics.areEqual((Object)string2, (Object)"V")) {
                direction = FacetWrap.Direction.V;
            } else if (Intrinsics.areEqual((Object)string2, (Object)"H")) {
                direction = FacetWrap.Direction.H;
            } else {
                throw new IllegalArgumentException("Unsupported `dir` value: " + opt + ".\nUse: 'H' (horizontal) or 'V' (vertical).");
            }
        }
        return direction;
    }

    private final Function1<Object, String> toFormatterVal(Object optionVal) {
        if (optionVal != null) {
            StringFormat fmt2 = StringFormat.Companion.forOneArg$default(StringFormat.Companion, optionVal.toString(), null, null, PlotAssembler.Companion.extractExponentFormat(this.expFormat), this.tz, 6, null);
            return (Function1)new Function1<Object, String>(fmt2){
                final /* synthetic */ StringFormat $fmt;
                {
                    this.$fmt = $fmt;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull Object value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    return this.$fmt.format(value);
                }
            };
        }
        return PlotFacets.Companion.getDEF_FORMATTER();
    }

    private final Function1<Object, String> getFormatterOption(String optionName) {
        return this.toFormatterVal(this.get(optionName));
    }

    private final int getLabWidthOption(String optionName) {
        return this.getIntegerDef(optionName, -1);
    }

    private final FacetScales getScalesOption() {
        Object object;
        block22: {
            block20: {
                FacetScales facetScales;
                object = this.getString("scales");
                if (object == null) break block20;
                String it = object;
                boolean bl = false;
                String string = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                switch (string) {
                    case "fixed": {
                        facetScales = FacetScales.FIXED;
                        break;
                    }
                    case "free": {
                        facetScales = FacetScales.FREE;
                        break;
                    }
                    case "free_x": {
                        facetScales = FacetScales.FREE_X;
                        break;
                    }
                    case "free_y": {
                        facetScales = FacetScales.FREE_Y;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported `scales` value: " + it + ".\nUse: fixed, free, free_x or free_y");
                    }
                }
                object = facetScales;
                if (facetScales != null) break block22;
            }
            object = FacetScales.FIXED;
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00050\u00040\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u001e\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00050\u00040\u0004JB\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00040\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00040\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/FacetConfig$Companion;", "", "()V", "filterUnusedLevels", "", "Lkotlin/Pair;", "", "dataByLayer", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "varNameAndLevelPairsByTileRaw", "reorderLevels", "varNames", "varLevels", "ordering", "", "reorderVarLevels", "name", "levels", "order", "plot-stem"})
    @SourceDebugExtension(value={"SMAP\nFacetConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetConfig.kt\norg/jetbrains/letsPlot/core/spec/config/FacetConfig$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,281:1\n1#2:282\n1855#3:283\n1864#3,3:284\n1856#3:287\n777#3:288\n788#3:289\n1864#3,2:290\n789#3,2:292\n1866#3:294\n791#3:295\n*S KotlinDebug\n*F\n+ 1 FacetConfig.kt\norg/jetbrains/letsPlot/core/spec/config/FacetConfig$Companion\n*L\n264#1:283\n268#1:284,3\n264#1:287\n275#1:288\n275#1:289\n275#1:290,2\n275#1:292,2\n275#1:294\n275#1:295\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<List<Object>> reorderLevels(@NotNull List<String> varNames, @NotNull List<? extends List<? extends Object>> varLevels, @NotNull List<Integer> ordering) {
            Intrinsics.checkNotNullParameter(varNames, (String)"varNames");
            Intrinsics.checkNotNullParameter(varLevels, (String)"varLevels");
            Intrinsics.checkNotNullParameter(ordering, (String)"ordering");
            Map orderingByFacet = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)varNames, (Iterable)ordering));
            ArrayList<List<Object>> result2 = new ArrayList<List<Object>>();
            Iterator<String> iterator2 = varNames.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                String name = iterator2.next();
                if (i >= varLevels.size()) break;
                result2.add(this.reorderVarLevels(name, varLevels.get(i), ((Number)MapsKt.getValue((Map)orderingByFacet, (Object)name)).intValue()));
            }
            return result2;
        }

        @NotNull
        public final List<Object> reorderVarLevels(@Nullable String name, @NotNull List<? extends Object> levels, int order) {
            Intrinsics.checkNotNullParameter(levels, (String)"levels");
            if (name == null) {
                return levels;
            }
            return order <= -1 ? CollectionsKt.sortedDescending((Iterable)levels) : (order >= 1 ? CollectionsKt.sorted((Iterable)levels) : levels);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<List<Pair<String, Object>>> filterUnusedLevels(@NotNull List<DataFrame> dataByLayer, @NotNull List<? extends List<? extends Pair<String, ? extends Object>>> varNameAndLevelPairsByTileRaw) {
            void $this$filterIndexedTo$iv$iv;
            List list2;
            Intrinsics.checkNotNullParameter(dataByLayer, (String)"dataByLayer");
            Intrinsics.checkNotNullParameter(varNameAndLevelPairsByTileRaw, (String)"varNameAndLevelPairsByTileRaw");
            int n = varNameAndLevelPairsByTileRaw.size();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Integer> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(0);
            }
            List $this$filterUnusedLevels_u24lambda_u243 = list2 = (List)arrayList;
            boolean $i$a$-apply-FacetConfig$Companion$filterUnusedLevels$dataSizeByTile$32 = false;
            Iterable $this$forEach$iv = dataByLayer;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataFrame data = (DataFrame)element$iv;
                boolean bl = false;
                List<List<Integer>> indicesByTile = PlotFacets.Companion.dataIndicesByTile(data, varNameAndLevelPairsByTileRaw);
                Iterable $this$forEachIndexed$iv = indicesByTile;
                boolean $i$f$forEachIndexed2 = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void indices2;
                    int n5;
                    if ((n5 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    List list3 = (List)item$iv;
                    int tileIndex = n5;
                    boolean bl2 = false;
                    $this$filterUnusedLevels_u24lambda_u243.set(tileIndex, ((Number)$this$filterUnusedLevels_u24lambda_u243.get(tileIndex)).intValue() + indices2.size());
                }
            }
            List dataSizeByTile = list2;
            Iterable $this$filterIndexed$iv = varNameAndLevelPairsByTileRaw;
            boolean $i$f$filterIndexed = false;
            Iterable $i$a$-apply-FacetConfig$Companion$filterUnusedLevels$dataSizeByTile$32 = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n6;
                if ((n6 = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object $i$f$forEachIndexed2 = item$iv$iv$iv;
                int index$iv$iv = n6;
                boolean bl = false;
                List cfr_ignored_0 = (List)element$iv$iv;
                int index = index$iv$iv;
                boolean bl3 = false;
                if (!(((Number)dataSizeByTile.get(index)).intValue() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

