/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ArrayUtilsKt;
import org.jetbrains.letsPlot.util.pngj.FilterType;
import org.jetbrains.letsPlot.util.pngj.IImageLine;
import org.jetbrains.letsPlot.util.pngj.IImageLineArray;
import org.jetbrains.letsPlot.util.pngj.IImageLineFactory;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.ImageLineHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dH\u0016J(\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001dH\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0007H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/ImageLineByte;", "Lorg/jetbrains/letsPlot/util/pngj/IImageLine;", "Lorg/jetbrains/letsPlot/util/pngj/IImageLineArray;", "imgInfo", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "sci", "", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;[B)V", "filterType", "Lorg/jetbrains/letsPlot/util/pngj/FilterType;", "getFilterType", "()Lorg/jetbrains/letsPlot/util/pngj/FilterType;", "setFilterType", "(Lorg/jetbrains/letsPlot/util/pngj/FilterType;)V", "filterUsed", "getFilterUsed$annotations", "()V", "getFilterUsed", "imageInfo", "getImageInfo", "()Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "getImgInfo", "scanline", "getScanline", "()[B", "scanline2", "getScanline2", "size", "", "getSize", "()I", "endReadFromPngRaw", "", "getElem", "i", "readFromPngRaw", "raw", "len", "offset", "step", "toString", "", "writeToPngRaw", "Companion", "plot-api"})
public final class ImageLineByte
implements IImageLine,
IImageLineArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageInfo imgInfo;
    @NotNull
    private final byte[] scanline;
    @Nullable
    private final byte[] scanline2;
    @NotNull
    private FilterType filterType;
    private final int size;

    public ImageLineByte(@NotNull ImageInfo imgInfo, @Nullable byte[] sci) {
        Intrinsics.checkNotNullParameter((Object)imgInfo, (String)"imgInfo");
        this.imgInfo = imgInfo;
        this.setFilterType(FilterType.FILTER_UNKNOWN);
        this.size = imgInfo.getSamplesPerRow();
        this.scanline = sci != null && sci.length >= this.getSize() ? sci : new byte[this.getSize()];
        this.scanline2 = imgInfo.getBitDepth() == 16 ? new byte[this.getSize()] : null;
    }

    @NotNull
    public final ImageInfo getImgInfo() {
        return this.imgInfo;
    }

    @NotNull
    public final byte[] getScanline() {
        return this.scanline;
    }

    @Nullable
    public final byte[] getScanline2() {
        return this.scanline2;
    }

    @Override
    @NotNull
    public FilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(@NotNull FilterType filterType) {
        Intrinsics.checkNotNullParameter((Object)((Object)filterType), (String)"<set-?>");
        this.filterType = filterType;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public ImageLineByte(@NotNull ImageInfo imgInfo) {
        Intrinsics.checkNotNullParameter((Object)imgInfo, (String)"imgInfo");
        this(imgInfo, null);
    }

    @NotNull
    public final FilterType getFilterUsed() {
        return this.getFilterType();
    }

    public static /* synthetic */ void getFilterUsed$annotations() {
    }

    @NotNull
    public String toString() {
        return " cols=" + this.imgInfo.getCols() + " bpc=" + this.imgInfo.getBitDepth() + " size=" + this.scanline.length;
    }

    @Override
    public void readFromPngRaw(@NotNull byte[] raw, int len, int offset, int step2) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        this.setFilterType(FilterType.Companion.getByVal(raw[0]));
        int len1 = len - 1;
        int step1 = (step2 - 1) * this.imgInfo.getChannels();
        if (this.imgInfo.getBitDepth() == 8) {
            if (step2 == 1) {
                ArrayUtilsKt.arraycopy(raw, 1, this.scanline, 0, len1);
            } else {
                int s = 1;
                int c = 0;
                int i = offset * this.imgInfo.getChannels();
                while (s <= len1) {
                    this.scanline[i] = raw[s];
                    if (++c == this.imgInfo.getChannels()) {
                        c = 0;
                        i += step1;
                    }
                    ++s;
                    ++i;
                }
            }
        } else if (this.imgInfo.getBitDepth() == 16) {
            if (step2 == 1) {
                int s = 1;
                for (int i = 0; i < this.imgInfo.getSamplesPerRow(); ++i) {
                    this.scanline[i] = raw[s++];
                    Intrinsics.checkNotNull((Object)this.scanline2);
                    this.scanline2[i] = raw[s++];
                }
            } else {
                int i;
                int s = 1;
                int c = 0;
                int n = i = offset != 0 ? offset * this.imgInfo.getChannels() : 0;
                while (s <= len1) {
                    this.scanline[i] = raw[s++];
                    Intrinsics.checkNotNull((Object)this.scanline2);
                    this.scanline2[i] = raw[s++];
                    if (++c == this.imgInfo.getChannels()) {
                        c = 0;
                        i += step1;
                    }
                    ++i;
                }
            }
        } else {
            int mask0 = 0;
            int mask = 0;
            int shi = 0;
            int bd = 0;
            bd = this.imgInfo.getBitDepth();
            mask0 = ImageLineHelper.INSTANCE.getMaskForPackedFormats(bd);
            int i = offset * this.imgInfo.getChannels();
            int c = 0;
            for (int r = 1; r < len; ++r) {
                mask = mask0;
                shi = 8 - bd;
                do {
                    this.scanline[i] = (byte)((raw[r] & mask) >> shi);
                    mask >>= bd;
                    shi -= bd;
                    ++i;
                    if (++c != this.imgInfo.getChannels()) continue;
                    c = 0;
                    i += step1;
                } while (mask != 0 && i < this.getSize());
            }
        }
    }

    @Override
    public void writeToPngRaw(@NotNull byte[] raw) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        raw[0] = (byte)this.getFilterType().getValue();
        if (this.imgInfo.getBitDepth() == 8) {
            ArrayUtilsKt.arraycopy(this.scanline, 0, raw, 1, this.getSize());
        } else if (this.imgInfo.getBitDepth() == 16) {
            int s = 1;
            for (int i = 0; i < this.getSize(); ++i) {
                raw[s++] = this.scanline[i];
                int n = s++;
                Intrinsics.checkNotNull((Object)this.scanline2);
                raw[n] = this.scanline2[i];
            }
        } else {
            int shi = 0;
            int bd = 0;
            int v = 0;
            bd = this.imgInfo.getBitDepth();
            shi = 8 - bd;
            v = 0;
            int r = 1;
            for (int i = 0; i < this.getSize(); ++i) {
                v |= this.scanline[i] << shi;
                if ((shi -= bd) >= 0 && i != this.getSize() - 1) continue;
                raw[r++] = (byte)v;
                shi = 8 - bd;
                v = 0;
            }
        }
    }

    @Override
    public void endReadFromPngRaw() {
    }

    @Override
    public int getElem(int i) {
        return this.scanline2 == null ? this.scanline[i] & 0xFF : (this.scanline[i] & 0xFF) << 8 | this.scanline2[i] & 0xFF;
    }

    @Override
    @NotNull
    public ImageInfo getImageInfo() {
        return this.imgInfo;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/ImageLineByte$Companion;", "", "()V", "factory", "Lorg/jetbrains/letsPlot/util/pngj/IImageLineFactory;", "Lorg/jetbrains/letsPlot/util/pngj/ImageLineByte;", "getFactory", "()Lorg/jetbrains/letsPlot/util/pngj/IImageLineFactory;", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IImageLineFactory<ImageLineByte> getFactory() {
            return new IImageLineFactory<ImageLineByte>(){

                @NotNull
                public ImageLineByte createImageLine(@NotNull ImageInfo iminfo) {
                    Intrinsics.checkNotNullParameter((Object)iminfo, (String)"iminfo");
                    return new ImageLineByte(iminfo);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

