/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.database.dialects.redis.model.RedisModelHelper;
import com.intellij.database.dialects.redis.model.properties.RedisKeyType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.project.Project;
import com.intellij.sql.psi.SqlElement;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedisExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    @NotNull
    protected String generateSelectStatement(@NotNull String text, @NotNull SqlElement sqlElement) {
        if (text == null) {
            RedisExecutionEnvironmentHelper.$$$reportNull$$$0(0);
        }
        if (sqlElement == null) {
            RedisExecutionEnvironmentHelper.$$$reportNull$$$0(1);
        }
        String string = String.format("ECHO %s", text);
        if (string == null) {
            RedisExecutionEnvironmentHelper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getKeepAliveQuery(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            RedisExecutionEnvironmentHelper.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            RedisExecutionEnvironmentHelper.$$$reportNull$$$0(4);
        }
        return "PING";
    }

    @Nullable
    public ModelHelper.ObjectKindVariant getTableKindVariant(@NotNull RemoteResultSet resultSet) throws RemoteException, SQLException {
        if (resultSet == null) {
            RedisExecutionEnvironmentHelper.$$$reportNull$$$0(5);
        }
        if (!resultSet.next()) {
            throw new AssertionError((Object)"Incorrect key type query!");
        }
        String typeName = resultSet.getString(1);
        if (typeName == null) {
            throw new AssertionError((Object)"Empty key type!");
        }
        RedisKeyType type = switch (typeName.toLowerCase(Locale.ENGLISH)) {
            case "string" -> RedisKeyType.STRING;
            case "list" -> RedisKeyType.LIST;
            case "set" -> RedisKeyType.SET;
            case "zset" -> RedisKeyType.SORTED_SET;
            case "hash" -> RedisKeyType.HASH_TABLE;
            case "stream" -> RedisKeyType.STREAM;
            case "rejson-rl" -> RedisKeyType.JSON_DOCUMENT;
            case "none" -> throw new SQLException(DatabaseBundle.message((String)"error.message.redis.the.key.does.not.exist", (Object[])new Object[0]));
            default -> RedisKeyType.OTHER;
        };
        return RedisModelHelper.INSTANCE.getKeyVariant(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/redis/RedisExecutionEnvironmentHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/redis/RedisExecutionEnvironmentHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSelectStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateSelectStatement";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKeepAliveQuery";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTableKindVariant";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

