/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.UseEelOptionProvider;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class DbOptionsEditor<Target> {
    private final DbOptionsEditors<Target> myAllEditors;
    private final JComponent myPanel;
    public static Key<Boolean> CUSTOM_LAYOUT = Key.create((String)"CUSTOM_LAYOUT");
    private final Project myProject;
    private final Disposable myDisposable;
    @NotNull
    private final DataContext myDataContext;
    private final int myRowLength;

    public DbOptionsEditor(Project project, @NotNull Disposable uiDisposable, Target target, Condition<DbOptionProvider<Target, ?>> initialCondition, Consumer<? super DbOptionProvider<Target, ?>> consumer, @NotNull DataContext dataContext, int rowLength) {
        if (uiDisposable == null) {
            DbOptionsEditor.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            DbOptionsEditor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDisposable = uiDisposable;
        this.myDataContext = dataContext;
        this.myRowLength = rowLength;
        this.myAllEditors = new DbOptionsEditors<Target>(DbImplUtilCore.classOf(target), initialCondition, consumer);
        this.myPanel = new JPanel();
        this.updateList(target);
        this.myAllEditors.reset(target);
    }

    private void addAdTooltips(Disposable disposable, DbOptionsEditors.OptionEditor<Target, ?> editor2, JComponent editorComponent) {
        this.addEelTooltip(disposable, editor2, editorComponent);
    }

    private void addEelTooltip(Disposable disposable, DbOptionsEditors.OptionEditor<Target, ?> editor2, JComponent editorComponent) {
        if (editor2.provider instanceof UseEelOptionProvider) {
            String promoId = "database.use.eel";
            GotItTooltip tooltip = new GotItTooltip(promoId, DatabaseBundle.message((String)"datasource.use.eel.description", (Object[])new Object[0]), disposable).withHeader(DatabaseBundle.message((String)"datasource.eel.usage.tooltip.header", (Object[])new Object[0])).withShowCount(1);
            tooltip.show(editorComponent, GotItTooltip.RIGHT_MIDDLE);
        }
    }

    public void updateList(Target target) {
        this.myPanel.removeAll();
        List<DbOptionsEditors.OptionEditor<Target, ?>> filtered = this.myAllEditors.getFiltered(this.myProject, target);
        this.myPanel.setVisible(!filtered.isEmpty());
        if (!filtered.isEmpty()) {
            this.myPanel.setLayout((LayoutManager)new GridLayoutManager(filtered.size(), this.myRowLength));
            boolean hasBiComponent = false;
            for (int i = 0; i < filtered.size(); ++i) {
                DbOptionsEditors.OptionEditor<Target, ?> value = filtered.get(i);
                JComponent component = value.createComponent(target, this.myDataContext);
                component.setToolTipText(value.provider.getDescription());
                if (Boolean.TRUE.equals(ClientProperty.get((Component)component, CUSTOM_LAYOUT))) {
                    this.myPanel.add((Component)component, DatabaseUIUtils.createRowConstraints(i, true, this.myRowLength));
                } else if (component instanceof JCheckBox) {
                    ((JCheckBox)component).setText(value.provider.getDisplayName());
                    this.myPanel.add((Component)component, DatabaseUIUtils.createRowConstraints(i, false, this.myRowLength));
                } else {
                    JBLabel label = new JBLabel(value.provider.getDisplayName());
                    this.myPanel.add((Component)label, DatabaseUIUtils.createLabelConstraints(i, 0, label.getPreferredSize().width));
                    this.myPanel.add((Component)component, DatabaseUIUtils.createSimpleConstraints(i, 1, this.myRowLength - 1));
                    hasBiComponent = true;
                }
                this.addAdTooltips(this.myDisposable, value, component);
            }
            if (!hasBiComponent) {
                this.myPanel.add((Component)new Spacer(), DatabaseUIUtils.createSimpleConstraints(0, 1, this.myRowLength - 1));
            }
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel;
    }

    public void apply(Target target) {
        this.myAllEditors.apply(target);
    }

    public void reset(Target target) {
        this.updateList(target);
        this.myAllEditors.reset(target);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "uiDisposable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dataSource/ui/DbOptionsEditor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DbOptionsEditors<Target> {
        private final List<OptionEditor<Target, ?>> myAllValues;

        public DbOptionsEditors(Class<Target> targetClass, Condition<DbOptionProvider<Target, ?>> initialCondition, Consumer<? super DbOptionProvider<Target, ?>> consumer) {
            this.myAllValues = ContainerUtil.newArrayList((Iterable)DbOptionProvider.getProviders(targetClass).filter(initialCondition).map(p -> new OptionEditor(p, consumer)));
            this.myAllValues.sort(Comparator.comparing(o -> o.provider.getDisplayName()));
        }

        public void apply(Target target) {
            for (OptionEditor<Target, ?> value : this.myAllValues) {
                value.apply(target);
            }
        }

        public void reset(Target target) {
            for (OptionEditor<Target, ?> value : this.myAllValues) {
                value.reset(target);
            }
        }

        @NotNull
        public @Unmodifiable List<OptionEditor<Target, ?>> getFiltered(@NotNull Project project, Target target) {
            if (project == null) {
                DbOptionsEditors.$$$reportNull$$$0(0);
            }
            List list = ContainerUtil.filter(this.myAllValues, v -> v.provider.isApplicable(project, target));
            if (list == null) {
                DbOptionsEditors.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/ui/DbOptionsEditor$DbOptionsEditors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/ui/DbOptionsEditor$DbOptionsEditors";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiltered";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFiltered";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }

        public static final class OptionEditor<Target, T> {
            public final DbOptionProvider<Target, T> provider;
            private final Runnable changed;
            public DbOptionProvider.EditorDesc<T> editor;

            public void apply(Target target) {
                Object value = this.editor == null ? this.provider.load(null) : this.editor.getter.get();
                this.provider.store(target, value);
            }

            public void reset(Target target) {
                if (this.editor != null) {
                    Object value = this.provider.load(target);
                    this.editor.setter.set(value);
                }
            }

            public OptionEditor(DbOptionProvider<Target, T> provider, Consumer<? super DbOptionProvider<Target, ?>> consumer) {
                this.provider = provider;
                this.changed = consumer == null ? null : () -> consumer.accept((Object)provider);
            }

            public JComponent createComponent(Target target, @NotNull DataContext dataContext) {
                if (dataContext == null) {
                    OptionEditor.$$$reportNull$$$0(0);
                }
                this.editor = this.provider.getEditor(target, dataContext);
                this.editor.changed.set((Object)this.changed);
                return this.editor.component;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dataSource/ui/DbOptionsEditor$DbOptionsEditors$OptionEditor", "createComponent"));
            }
        }
    }
}

