/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ActionStatus;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.structure.DvForestCreateNewFolderDialog;
import com.intellij.database.view.structure.forest.DvFolder;
import com.intellij.database.view.structure.forest.DvNiceFolder;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0004J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0011H&J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0011H&\u0082\u0001\u0001\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/view/structure/DvForestAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "checkAvailability", "Lcom/intellij/database/actions/ActionStatus;", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "adjustPresentation", "actionPerformed", "determineSelection", "Lcom/intellij/database/view/structure/DvForestAction$Selection;", "checkApplicability", "selection", "performAction", "project", "Lcom/intellij/openapi/project/Project;", "Selection", "CreateNewFolder", "Lcom/intellij/database/view/structure/DvForestAction$CreateNewFolder;", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDvForestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/view/structure/DvForestAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public abstract sealed class DvForestAction
extends DumbAwareAction {
    private DvForestAction() {
    }

    @NotNull
    public final ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final void update(@NotNull AnActionEvent e) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dc = dataContext;
        ActionStatus actionStatus = DatabaseContextFun.fromDatabaseTree(dc) ? this.checkAvailability(dc) : ActionStatus.HIDDEN;
        Presentation $this$update_u24lambda_u240 = presentation = e.getPresentation();
        boolean bl = false;
        $this$update_u24lambda_u240.setVisible(actionStatus.visible);
        $this$update_u24lambda_u240.setEnabled(actionStatus.enabled);
        if (actionStatus.visible) {
            this.adjustPresentation(e);
        }
    }

    @NotNull
    protected final ActionStatus checkAvailability(@NotNull DataContext dc) {
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        Selection selection = this.determineSelection(dc);
        if (!selection.getHasFolders() && !selection.isEmpty()) {
            return ActionStatus.HIDDEN;
        }
        return this.checkApplicability(selection);
    }

    protected void adjustPresentation(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dc = dataContext;
        if (!DatabaseContextFun.fromDatabaseTree(dc)) {
            return;
        }
        Selection selection = this.determineSelection(dc);
        ActionStatus status = this.checkApplicability(selection);
        if (!status.enabled) {
            return;
        }
        this.performAction(project2, selection);
    }

    @NotNull
    protected final Selection determineSelection(@NotNull DataContext dc) {
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        ArrayList<BasicNode> folders = new ArrayList<BasicNode>();
        ArrayList<BasicNode> dataSources = new ArrayList<BasicNode>();
        boolean other = false;
        for (BasicNode node : DatabaseContextFun.getSelectedNodes(dc)) {
            BasicNode basicNode = node;
            if (basicNode instanceof DvNiceFolder) {
                folders.add(node);
                continue;
            }
            if (basicNode instanceof DataSourceNode) {
                dataSources.add(node);
                continue;
            }
            other = true;
        }
        return new Selection((Collection<DvNiceFolder>)folders, (Collection<DataSourceNode>)dataSources, other);
    }

    @NotNull
    public abstract ActionStatus checkApplicability(@NotNull Selection var1);

    public abstract void performAction(@NotNull Project var1, @NotNull Selection var2);

    public /* synthetic */ DvForestAction(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/view/structure/DvForestAction$CreateNewFolder;", "Lcom/intellij/database/view/structure/DvForestAction;", "<init>", "()V", "checkApplicability", "Lcom/intellij/database/actions/ActionStatus;", "selection", "Lcom/intellij/database/view/structure/DvForestAction$Selection;", "adjustPresentation", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "performAction", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDvForestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/view/structure/DvForestAction$CreateNewFolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
    public static final class CreateNewFolder
    extends DvForestAction {
        public CreateNewFolder() {
            super(null);
        }

        @Override
        @NotNull
        public ActionStatus checkApplicability(@NotNull Selection selection) {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Selection $this$checkApplicability_u24lambda_u240 = selection;
            boolean bl = false;
            boolean ok2 = $this$checkApplicability_u24lambda_u240.getFolders().size() <= 1 && !$this$checkApplicability_u24lambda_u240.getHasDataSource() && !$this$checkApplicability_u24lambda_u240.getOther();
            return ok2 ? ActionStatus.ENABLED : ActionStatus.DISABLED;
        }

        @Override
        protected void adjustPresentation(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setText(DatabaseBundle.message((String)"action.DatabaseView.CreateNewFolder.textInsideGroupNew", (Object[])new Object[0]));
        }

        @Override
        public void performAction(@NotNull Project project, @NotNull Selection selection) {
            DvNiceFolder dvNiceFolder;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            switch (selection.getFolders().size()) {
                case 0: {
                    dvNiceFolder = null;
                    break;
                }
                case 1: {
                    dvNiceFolder = (DvNiceFolder)CollectionsKt.singleOrNull((Iterable)selection.getFolders());
                    break;
                }
                default: {
                    return;
                }
            }
            DvNiceFolder parentFolder = dvNiceFolder;
            DvForestCreateNewFolderDialog.Companion.doIt(project, (DvFolder)parentFolder);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J3\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/view/structure/DvForestAction$Selection;", "", "folders", "", "Lcom/intellij/database/view/structure/forest/DvNiceFolder;", "dataSources", "Lcom/intellij/database/view/DataSourceNode;", "other", "", "<init>", "(Ljava/util/Collection;Ljava/util/Collection;Z)V", "getFolders", "()Ljava/util/Collection;", "getDataSources", "getOther", "()Z", "hasFolders", "getHasFolders", "hasDataSource", "getHasDataSource", "isEmpty", "component1", "component2", "component3", "copy", "equals", "hashCode", "", "toString", "", "intellij.database.impl"})
    public static final class Selection {
        @NotNull
        private final Collection<DvNiceFolder> folders;
        @NotNull
        private final Collection<DataSourceNode> dataSources;
        private final boolean other;

        public Selection(@NotNull Collection<DvNiceFolder> folders, @NotNull Collection<DataSourceNode> dataSources, boolean other) {
            Intrinsics.checkNotNullParameter(folders, (String)"folders");
            Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
            this.folders = folders;
            this.dataSources = dataSources;
            this.other = other;
        }

        @NotNull
        public final Collection<DvNiceFolder> getFolders() {
            return this.folders;
        }

        @NotNull
        public final Collection<DataSourceNode> getDataSources() {
            return this.dataSources;
        }

        public final boolean getOther() {
            return this.other;
        }

        public final boolean getHasFolders() {
            return !this.folders.isEmpty();
        }

        public final boolean getHasDataSource() {
            return !this.dataSources.isEmpty();
        }

        public final boolean isEmpty() {
            return !this.getHasFolders() && !this.getHasDataSource() && !this.other;
        }

        @NotNull
        public final Collection<DvNiceFolder> component1() {
            return this.folders;
        }

        @NotNull
        public final Collection<DataSourceNode> component2() {
            return this.dataSources;
        }

        public final boolean component3() {
            return this.other;
        }

        @NotNull
        public final Selection copy(@NotNull Collection<DvNiceFolder> folders, @NotNull Collection<DataSourceNode> dataSources, boolean other) {
            Intrinsics.checkNotNullParameter(folders, (String)"folders");
            Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
            return new Selection(folders, dataSources, other);
        }

        public static /* synthetic */ Selection copy$default(Selection selection, Collection collection, Collection collection2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                collection = selection.folders;
            }
            if ((n & 2) != 0) {
                collection2 = selection.dataSources;
            }
            if ((n & 4) != 0) {
                bl = selection.other;
            }
            return selection.copy(collection, collection2, bl);
        }

        @NotNull
        public String toString() {
            return "Selection(folders=" + this.folders + ", dataSources=" + this.dataSources + ", other=" + this.other + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.folders).hashCode();
            result2 = result2 * 31 + ((Object)this.dataSources).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.other);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Selection)) {
                return false;
            }
            Selection selection = (Selection)other;
            if (!Intrinsics.areEqual(this.folders, selection.folders)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.dataSources, selection.dataSources)) {
                return false;
            }
            return this.other == selection.other;
        }
    }
}

