/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.ui.PortField;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.RadioButtonEnumModel;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.reactnative.ReactNativeConfigurationEditorKt;
import com.jetbrains.plugins.reactnative.ReactNativeDebuggerBundle;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0002H\u0014J\u0010\u0010,\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0002H\u0014J\b\u0010-\u001a\u00020*H\u0002J\b\u0010.\u001a\u00020/H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "buildAndLaunch", "Lcom/intellij/ui/components/JBCheckBox;", "isHermesEngineEnabled", "platformLabel", "Ljavax/swing/JLabel;", "platformPanel", "Ljavax/swing/JPanel;", "platformModel", "Lcom/intellij/util/ui/RadioButtonEnumModel;", "Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "runArgumentsLabel", "runArgumentsField", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "browserSelectorLabel", "browserSelector", "Lcom/intellij/ide/browsers/BrowserSelector;", "debugHostLabel", "debugHost", "Ljavax/swing/JTextField;", "debugPortLabel", "debugPort", "Lcom/intellij/ui/PortField;", "reactNativeFieldLabel", "reactNativeField", "Lcom/intellij/javascript/nodejs/util/NodePackageField;", "nodeInterpreterFieldLabel", "nodeInterpreterField", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField;", "workingDirFieldLabel", "workingDirField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "envVarsComponentLabel", "envVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton;", "resetEditorFrom", "", "s", "applyEditorTo", "updateBuildConfigurationVisibility", "createEditor", "Ljavax/swing/JComponent;", "intellij.javascript.reactNativeDebugger"})
@SourceDebugExtension(value={"SMAP\nReactNativeConfigurationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactNativeConfigurationEditor.kt\ncom/jetbrains/plugins/reactnative/ReactNativeConfigurationEditor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,195:1\n13805#2,2:196\n*S KotlinDebug\n*F\n+ 1 ReactNativeConfigurationEditor.kt\ncom/jetbrains/plugins/reactnative/ReactNativeConfigurationEditor\n*L\n131#1:196,2\n*E\n"})
public final class ReactNativeConfigurationEditor
extends SettingsEditor<ReactNativeRunConfiguration> {
    @NotNull
    private final JBCheckBox buildAndLaunch;
    @NotNull
    private final JBCheckBox isHermesEngineEnabled;
    @NotNull
    private final JLabel platformLabel;
    @NotNull
    private final JPanel platformPanel;
    @NotNull
    private final RadioButtonEnumModel<ReactNativePlatform> platformModel;
    @NotNull
    private final JLabel runArgumentsLabel;
    @NotNull
    private final TextFieldWithCompletion runArgumentsField;
    @NotNull
    private final JLabel browserSelectorLabel;
    @NotNull
    private final BrowserSelector browserSelector;
    @NotNull
    private final JLabel debugHostLabel;
    @NotNull
    private final JTextField debugHost;
    @NotNull
    private final JLabel debugPortLabel;
    @NotNull
    private final PortField debugPort;
    @NotNull
    private final JLabel reactNativeFieldLabel;
    @NotNull
    private final NodePackageField reactNativeField;
    @NotNull
    private final JLabel nodeInterpreterFieldLabel;
    @NotNull
    private final NodeJsInterpreterField nodeInterpreterField;
    @NotNull
    private final JLabel workingDirFieldLabel;
    @NotNull
    private final TextFieldWithBrowseButton workingDirField;
    @NotNull
    private final JLabel envVarsComponentLabel;
    @NotNull
    private final EnvironmentVariablesTextFieldWithBrowseButton envVarsComponent;

    public ReactNativeConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.platformLabel = new JLabel(ReactNativeDebuggerBundle.message("react.native.config.platform", new Object[0]));
        this.platformPanel = new JPanel(new GridBagLayout());
        this.runArgumentsLabel = new JLabel(ReactNativeDebuggerBundle.message("react.native.config.arguments", new Object[0]));
        this.reactNativeFieldLabel = new JLabel(ReactNativeDebuggerBundle.message("react.native.config.package", new Object[0]));
        this.nodeInterpreterFieldLabel = new JLabel(ReactNativeDebuggerBundle.message("react.native.config.interpreter", new Object[0]));
        this.nodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.workingDirFieldLabel = new JLabel(ReactNativeDebuggerBundle.message("react.native.config.directory", new Object[0]));
        this.workingDirField = new TextFieldWithBrowseButton();
        this.envVarsComponentLabel = new JLabel(ReactNativeDebuggerBundle.message("react.native.config.env", new Object[0]));
        this.envVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.reactNativeField = ReactNativeConfigurationEditorKt.createReactNativePackageField(this.nodeInterpreterField);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.workingDirField.addBrowseFolderListener(project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserFactory.getInstance().installFileCompletion(this.workingDirField.getTextField(), descriptor, false, (Disposable)this.workingDirField);
        this.buildAndLaunch = new JBCheckBox(ReactNativeDebuggerBundle.message("react.native.config.launch", new Object[0]));
        this.buildAndLaunch.addChangeListener(arg_0 -> ReactNativeConfigurationEditor._init_$lambda$0(this, arg_0));
        this.isHermesEngineEnabled = new JBCheckBox(ReactNativeDebuggerBundle.message("react.native.config.hermes", new Object[0]));
        this.platformModel = ReactNativeConfigurationEditorKt.createRadioButtonGroup(ReactNativePlatform.class, this.platformPanel);
        TextFieldWithAutoCompletion.StringsCompletionProvider provider = new TextFieldWithAutoCompletion.StringsCompletionProvider((Collection)ReactNativePlatform.values()[0].getPossibleArguments(), null);
        this.runArgumentsField = new TextFieldWithCompletion(project, (TextCompletionProvider)provider, "", true, false, false);
        this.platformModel.addActionListener(arg_0 -> ReactNativeConfigurationEditor._init_$lambda$1(provider, this, arg_0));
        this.browserSelector = new BrowserSelector(arg_0 -> ReactNativeConfigurationEditor._init_$lambda$3(ReactNativeConfigurationEditor::_init_$lambda$2, arg_0));
        this.browserSelectorLabel = new JLabel(ReactNativeDebuggerBundle.message("react.native.config.browser", new Object[0]));
        this.browserSelectorLabel.setLabelFor(this.browserSelector.getMainComponent());
        this.debugHost = new JTextField();
        this.debugHostLabel = new JLabel(ReactNativeDebuggerBundle.message("react.native.config.debug.host", new Object[0]));
        this.debugHostLabel.setLabelFor(this.debugHost);
        this.debugPort = new PortField();
        this.debugPortLabel = new JLabel(ReactNativeDebuggerBundle.message("react.native.config.debug.port", new Object[0]));
        this.debugPortLabel.setLabelFor((Component)this.debugPort);
        this.updateBuildConfigurationVisibility();
    }

    protected void resetEditorFrom(@NotNull ReactNativeRunConfiguration s) {
        Intrinsics.checkNotNullParameter((Object)((Object)s), (String)"s");
        this.nodeInterpreterField.setInterpreterRef(s.getNodePath());
        NodePackage sPackage = s.getReactNativePackage();
        if (sPackage != null) {
            this.reactNativeField.setSelected(sPackage);
        } else {
            Project project = s.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            NodePackage defaultPackage = ReactNativeConfigurationEditorKt.findReactNativePackage(project, this.nodeInterpreterField.getInterpreter());
            if (defaultPackage != null) {
                this.reactNativeField.setSelected(defaultPackage);
            }
        }
        this.workingDirField.setText(s.getEffectiveWorkingDirectory());
        this.buildAndLaunch.setSelected(s.getBuildAndLaunch());
        this.isHermesEngineEnabled.setSelected(s.isHermesEngine());
        this.platformModel.setSelected((Enum)s.getPlatform());
        this.runArgumentsField.setText(s.getRunArguments());
        this.envVarsComponent.setData(s.getEnvData());
        this.browserSelector.setSelected(s.getBrowser());
        this.debugHost.setText(s.getPackagerHost());
        this.debugPort.setNumber(s.getPackagerPort());
        this.updateBuildConfigurationVisibility();
    }

    protected void applyEditorTo(@NotNull ReactNativeRunConfiguration s) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)s), (String)"s");
        s.setReactNativePackage(this.reactNativeField.getSelected());
        NodeJsInterpreterRef nodeJsInterpreterRef = this.nodeInterpreterField.getInterpreterRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"getInterpreterRef(...)");
        s.setNodePath(nodeJsInterpreterRef);
        if (Intrinsics.areEqual((Object)this.workingDirField.getText(), (Object)s.findWorkingDirectory())) {
            string = "";
        } else {
            String string2 = this.workingDirField.getText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        }
        s.setWorkingDirectory(string);
        s.setBuildAndLaunch(this.buildAndLaunch.isSelected());
        s.setHermesEngine(this.isHermesEngineEnabled.isSelected());
        Enum enum_ = this.platformModel.getSelected();
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"getSelected(...)");
        s.setPlatform((ReactNativePlatform)enum_);
        String string3 = this.runArgumentsField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        s.setRunArguments(string3);
        EnvironmentVariablesData environmentVariablesData = this.envVarsComponent.getData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getData(...)");
        s.setEnvData(environmentVariablesData);
        s.setBrowserId(this.browserSelector.getSelectedBrowserId());
        String string4 = this.debugHost.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        s.setPackagerHost(string4);
        s.setPackagerPort(this.debugPort.getNumber());
    }

    private final void updateBuildConfigurationVisibility() {
        boolean selected = this.buildAndLaunch.isSelected();
        Component[] componentArray = this.platformPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            it.setEnabled(selected);
        }
        this.platformLabel.setEnabled(selected);
        this.runArgumentsField.setEnabled(selected);
        this.runArgumentsLabel.setEnabled(selected);
        this.reactNativeFieldLabel.setVisible(selected);
        this.reactNativeField.setVisible(selected);
        this.nodeInterpreterFieldLabel.setVisible(selected);
        this.nodeInterpreterField.setVisible(selected);
        this.workingDirFieldLabel.setVisible(selected);
        this.workingDirField.setVisible(selected);
        this.envVarsComponentLabel.setVisible(selected);
        this.envVarsComponent.setVisible(selected);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = FormBuilder.createFormBuilder().addComponent((JComponent)new ComponentPanelBuilder((JComponent)this.buildAndLaunch).withComment(ReactNativeDebuggerBundle.message("react.native.config.launch.description", new Object[0])).createPanel()).setFormLeftIndent(UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)((JCheckBox)this.buildAndLaunch))).addLabeledComponent((JComponent)this.platformLabel, (JComponent)this.platformPanel).addLabeledComponent((JComponent)this.runArgumentsLabel, (JComponent)this.runArgumentsField).setFormLeftIndent(0).addComponent((JComponent)this.isHermesEngineEnabled, 24).addLabeledComponent((JComponent)this.browserSelectorLabel, this.browserSelector.getMainComponent()).addLabeledComponent((JComponent)this.debugHostLabel, (JComponent)this.debugHost).addLabeledComponent((JComponent)this.debugPortLabel, (JComponent)this.debugPort).addLabeledComponent((JComponent)this.nodeInterpreterFieldLabel, (JComponent)this.nodeInterpreterField, 24).addLabeledComponent((JComponent)this.reactNativeFieldLabel, (JComponent)this.reactNativeField).addLabeledComponent((JComponent)this.workingDirFieldLabel, (JComponent)this.workingDirField).addLabeledComponent((JComponent)this.envVarsComponentLabel, (JComponent)this.envVarsComponent).getPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getPanel(...)");
        return jPanel;
    }

    private static final void _init_$lambda$0(ReactNativeConfigurationEditor this$0, ChangeEvent it) {
        this$0.updateBuildConfigurationVisibility();
    }

    private static final void _init_$lambda$1(TextFieldWithAutoCompletion.StringsCompletionProvider $provider, ReactNativeConfigurationEditor this$0, ActionEvent it) {
        $provider.setItems((Collection)((ReactNativePlatform)this$0.platformModel.getSelected()).getPossibleArguments());
    }

    private static final boolean _init_$lambda$2(WebBrowser it) {
        WebBrowser webBrowser = it;
        return (webBrowser != null ? webBrowser.getFamily() : null) == BrowserFamily.CHROME;
    }

    private static final boolean _init_$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

