/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.InternalResourceCache;
import com.oracle.truffle.polyglot.InternalResourceRoots;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class FileSystems {
    static final org.graalvm.polyglot.io.FileSystem INVALID_FILESYSTEM = new InvalidFileSystem();

    private FileSystems() {
        throw new IllegalStateException("No instance allowed");
    }

    static org.graalvm.polyglot.io.FileSystem newDefaultFileSystem(String hostTmpDirPath) {
        return new NIOFileSystem(FileSystems.findDefaultFileSystem(), hostTmpDirPath, true);
    }

    static org.graalvm.polyglot.io.FileSystem newNIOFileSystem(FileSystem fileSystem) {
        return new NIOFileSystem(fileSystem, null, false);
    }

    static org.graalvm.polyglot.io.FileSystem allowInternalResourceAccess(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return ResourcesFileSystem.createForEmbedder(FileSystems.newDefaultFileSystem(null), fileSystem);
    }

    static org.graalvm.polyglot.io.FileSystem newReadOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return new ReadOnlyFileSystem(fileSystem);
    }

    static org.graalvm.polyglot.io.FileSystem newNoIOFileSystem() {
        return new DeniedIOFileSystem();
    }

    static org.graalvm.polyglot.io.FileSystem newResourcesFileSystem(PolyglotEngineImpl engine) {
        org.graalvm.polyglot.io.FileSystem defaultFS = FileSystems.newDefaultFileSystem(null);
        return ResourcesFileSystem.createForEngine(engine, new ReadOnlyFileSystem(defaultFS), new PathOperationsOnlyFileSystem(defaultFS));
    }

    static boolean hasNoAccess(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return fileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)fileSystem).hasNoAccess();
    }

    static boolean isInternal(AbstractPolyglotImpl polyglot, org.graalvm.polyglot.io.FileSystem fileSystem) {
        return fileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)fileSystem).isInternal(polyglot);
    }

    static boolean isHostFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return fileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)fileSystem).isHost();
    }

    static Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> newFileTypeDetectorsSupplier(Iterable<LanguageCache> languageCaches) {
        return new FileTypeDetectorsSupplier(languageCaches);
    }

    static String getRelativePathInResourceRoot(TruffleFile file) {
        Object engineObject = EngineAccessor.LANGUAGE.getFileSystemEngineObject(EngineAccessor.LANGUAGE.getFileSystemContext(file));
        if (engineObject instanceof PolyglotLanguageContext) {
            Path hostPath;
            InternalResourceCache cache;
            PolyglotLanguageContext languageContext = (PolyglotLanguageContext)engineObject;
            Path path = EngineAccessor.LANGUAGE.getPath(file);
            if (InternalResourceCache.usesInternalResources() && (cache = languageContext.context.engine.internalResourceRoots.findInternalResource(hostPath = FileSystems.toHostPath(path))) != null) {
                return cache.getPathOrNull().relativize(hostPath).toString();
            }
            org.graalvm.polyglot.io.FileSystem fs = EngineAccessor.LANGUAGE.getFileSystem(file);
            String result = FileSystems.relativizeToLanguageHome(fs, path, languageContext.language);
            if (result != null) {
                return result;
            }
            Map<String, LanguageInfo> accessibleLanguages = languageContext.getAccessibleLanguages(true);
            if (accessibleLanguages != null) {
                for (LanguageInfo language : accessibleLanguages.values()) {
                    PolyglotLanguage lang = languageContext.context.engine.idToLanguage.get(language.getId());
                    result = FileSystems.relativizeToLanguageHome(fs, path, lang);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }
        if (engineObject instanceof PolyglotImpl.EmbedderFileSystemContext) {
            return null;
        }
        throw new AssertionError();
    }

    private static Path toHostPath(Path path) {
        if (path.getClass() != Path.of("", new String[0]).getClass()) {
            return Paths.get(path.toString(), new String[0]);
        }
        return path;
    }

    private static String relativizeToLanguageHome(org.graalvm.polyglot.io.FileSystem fs, Path path, PolyglotLanguage language) {
        String languageHome = language.cache.getLanguageHome();
        if (languageHome == null) {
            return null;
        }
        Path languageHomePath = fs.parsePath(language.cache.getLanguageHome());
        if (path.startsWith(languageHomePath)) {
            return languageHomePath.relativize(path).toString();
        }
        return null;
    }

    private static FileSystem findDefaultFileSystem() {
        FileSystem fs = java.nio.file.FileSystems.getDefault();
        assert ("file".equals(fs.provider().getScheme()));
        return fs;
    }

    private static FileSystemProvider findDefaultFileSystemProvider() {
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (!"file".equals(provider.getScheme())) continue;
            return provider;
        }
        return null;
    }

    private static boolean isFollowLinks(LinkOption ... linkOptions) {
        for (LinkOption lo : linkOptions) {
            if (Objects.requireNonNull(lo) != LinkOption.NOFOLLOW_LINKS) continue;
            return false;
        }
        return true;
    }

    private static void validateLinkOptions(LinkOption ... linkOptions) {
        for (LinkOption linkOption : linkOptions) {
            Objects.requireNonNull(linkOption);
        }
    }

    private static SecurityException forbidden(Path path) {
        throw new SecurityException((String)(path == null ? "Operation is not allowed." : "Operation is not allowed for: " + String.valueOf(path)));
    }

    private static final class NIOFileSystem
    implements PolyglotFileSystem {
        private final FileSystem fileSystem;
        private final FileSystemProvider fileSystemProvider;
        private final boolean isDefault;
        private final String hostTmpDirPath;
        private volatile Path userDir;
        private volatile Path tmpDir;

        NIOFileSystem(FileSystem fileSystem, String hostTmpDirPath, boolean isDefault) {
            Objects.requireNonNull(fileSystem, "FileSystem must be non null.");
            this.fileSystem = fileSystem;
            this.fileSystemProvider = fileSystem.provider();
            this.hostTmpDirPath = hostTmpDirPath;
            this.isDefault = isDefault;
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return this.isDefault;
        }

        @Override
        public boolean hasNoAccess() {
            return false;
        }

        @Override
        public boolean isHost() {
            return this.isDefault;
        }

        @Override
        public Path parsePath(URI uri) {
            if (!this.fileSystemProvider.getScheme().equals(uri.getScheme())) {
                throw new UnsupportedOperationException("Unsupported URI scheme " + uri.getScheme());
            }
            try {
                return this.fileSystemProvider.getPath(uri);
            }
            catch (FileSystemNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        public Path parsePath(String path) {
            Objects.requireNonNull(path);
            return this.fileSystem.getPath(path, new String[0]);
        }

        @Override
        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            Objects.requireNonNull(path);
            Objects.requireNonNull(modes);
            if (FileSystems.isFollowLinks(linkOptions)) {
                this.fileSystemProvider.checkAccess(this.resolveRelative(path), modes.toArray(new AccessMode[0]));
            } else if (modes.isEmpty()) {
                this.fileSystemProvider.readAttributes(path, "isRegularFile", LinkOption.NOFOLLOW_LINKS);
            } else {
                throw new UnsupportedOperationException("CheckAccess for NIO Provider is unsupported with non empty AccessMode and NOFOLLOW_LINKS.");
            }
        }

        @Override
        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            Objects.requireNonNull(dir);
            Objects.requireNonNull(attrs);
            this.fileSystemProvider.createDirectory(this.resolveRelative(dir), attrs);
        }

        @Override
        public void delete(Path path) throws IOException {
            Objects.requireNonNull(path);
            this.fileSystemProvider.delete(this.resolveRelative(path));
        }

        @Override
        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            Objects.requireNonNull(source);
            Objects.requireNonNull(target);
            Objects.requireNonNull(options);
            this.fileSystemProvider.copy(this.resolveRelative(source), this.resolveRelative(target), options);
        }

        @Override
        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            Objects.requireNonNull(source);
            Objects.requireNonNull(target);
            Objects.requireNonNull(options);
            this.fileSystemProvider.move(this.resolveRelative(source), this.resolveRelative(target), options);
        }

        @Override
        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            Objects.requireNonNull(path);
            Objects.requireNonNull(options);
            Objects.requireNonNull(attrs);
            Path resolved = this.resolveRelative(path);
            try {
                return this.fileSystemProvider.newFileChannel(resolved, options, attrs);
            }
            catch (UnsupportedOperationException uoe) {
                return this.fileSystemProvider.newByteChannel(resolved, options, attrs);
            }
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            boolean relativize;
            Path resolvedPath;
            Objects.requireNonNull(dir);
            Path cwd = this.userDir;
            if (!dir.isAbsolute() && cwd != null) {
                resolvedPath = cwd.resolve(dir);
                relativize = true;
            } else {
                resolvedPath = dir;
                relativize = false;
            }
            RelativizeDirectoryStream result = this.fileSystemProvider.newDirectoryStream(resolvedPath, filter);
            if (relativize) {
                result = new RelativizeDirectoryStream(cwd, result);
            }
            return result;
        }

        @Override
        public void createLink(Path link, Path existing) throws IOException {
            Objects.requireNonNull(link);
            Objects.requireNonNull(existing);
            this.fileSystemProvider.createLink(this.resolveRelative(link), this.resolveRelative(existing));
        }

        @Override
        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            Objects.requireNonNull(link);
            Objects.requireNonNull(target);
            Objects.requireNonNull(attrs);
            this.fileSystemProvider.createSymbolicLink(this.resolveRelative(link), target, attrs);
        }

        @Override
        public Path readSymbolicLink(Path link) throws IOException {
            Objects.requireNonNull(link);
            return this.fileSystemProvider.readSymbolicLink(this.resolveRelative(link));
        }

        @Override
        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            Objects.requireNonNull(path);
            FileSystems.validateLinkOptions(options);
            return this.fileSystemProvider.readAttributes(this.resolveRelative(path), attributes, options);
        }

        @Override
        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            Objects.requireNonNull(path);
            FileSystems.validateLinkOptions(options);
            this.fileSystemProvider.setAttribute(this.resolveRelative(path), attribute, value, options);
        }

        @Override
        public Path toAbsolutePath(Path path) {
            Objects.requireNonNull(path);
            if (path.isAbsolute()) {
                return path;
            }
            Path cwd = this.userDir;
            if (cwd == null) {
                return path.toAbsolutePath();
            }
            return cwd.resolve(path);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            boolean nonDirectory;
            Objects.requireNonNull(currentWorkingDirectory, "Current working directory must be non null.");
            if (!currentWorkingDirectory.isAbsolute()) {
                throw new IllegalArgumentException("Current working directory must be absolute.");
            }
            try {
                nonDirectory = Boolean.FALSE.equals(this.fileSystemProvider.readAttributes(currentWorkingDirectory, "isDirectory", new LinkOption[0]).get("isDirectory"));
            }
            catch (IOException ioe) {
                nonDirectory = false;
            }
            if (nonDirectory) {
                throw new IllegalArgumentException("Current working directory must be directory.");
            }
            this.userDir = currentWorkingDirectory;
        }

        @Override
        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            Objects.requireNonNull(path);
            FileSystems.validateLinkOptions(linkOptions);
            Path resolvedPath = this.resolveRelative(path);
            return resolvedPath.toRealPath(linkOptions);
        }

        @Override
        public Path getTempDirectory() {
            Path result = this.tmpDir;
            if (result == null) {
                if (this.hostTmpDirPath != null) {
                    this.tmpDir = result = this.parsePath(this.hostTmpDirPath);
                } else {
                    throw new UnsupportedOperationException("Temporary directories not supported");
                }
            }
            return result;
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            Objects.requireNonNull(path1);
            Objects.requireNonNull(path2);
            if (FileSystems.isFollowLinks(options)) {
                Path absolutePath1 = this.resolveRelative(path1);
                Path absolutePath2 = this.resolveRelative(path2);
                return this.fileSystemProvider.isSameFile(absolutePath1, absolutePath2);
            }
            return PolyglotFileSystem.super.isSameFile(path1, path2, options);
        }

        private Path resolveRelative(Path path) {
            return !path.isAbsolute() && this.userDir != null ? this.toAbsolutePath(path) : path;
        }

        private static final class RelativizeDirectoryStream
        implements DirectoryStream<Path> {
            private final Path folder;
            private final DirectoryStream<? extends Path> delegateDirectoryStream;

            RelativizeDirectoryStream(Path folder, DirectoryStream<? extends Path> delegateDirectoryStream) {
                this.folder = folder;
                this.delegateDirectoryStream = delegateDirectoryStream;
            }

            @Override
            public Iterator<Path> iterator() {
                return new RelativizeIterator(this.folder, this.delegateDirectoryStream.iterator());
            }

            @Override
            public void close() throws IOException {
                this.delegateDirectoryStream.close();
            }

            private static final class RelativizeIterator
            implements Iterator<Path> {
                private final Path folder;
                private final Iterator<? extends Path> delegateIterator;

                RelativizeIterator(Path folder, Iterator<? extends Path> delegateIterator) {
                    this.folder = folder;
                    this.delegateIterator = delegateIterator;
                }

                @Override
                public boolean hasNext() {
                    return this.delegateIterator.hasNext();
                }

                @Override
                public Path next() {
                    return this.folder.relativize(this.delegateIterator.next());
                }
            }
        }
    }

    private static final class ResourcesFileSystem
    implements PolyglotFileSystem {
        private final org.graalvm.polyglot.io.FileSystem resourcesFileSystem;
        private final org.graalvm.polyglot.io.FileSystem delegateFileSystem;
        private final InternalResourceRoots resourceRoots;
        private final Collection<Path> languageHomes;

        static ResourcesFileSystem createForEngine(PolyglotEngineImpl engine, org.graalvm.polyglot.io.FileSystem resourcesFileSystem, org.graalvm.polyglot.io.FileSystem delegateFileSystem) {
            return new ResourcesFileSystem(resourcesFileSystem, delegateFileSystem, engine.internalResourceRoots, List.copyOf(engine.languageHomes().values()));
        }

        static ResourcesFileSystem createForEmbedder(org.graalvm.polyglot.io.FileSystem resourcesFileSystem, org.graalvm.polyglot.io.FileSystem delegateFileSystem) {
            HashSet<Path> languageHomes = new HashSet<Path>();
            for (LanguageCache cache : LanguageCache.languages().values()) {
                String languageHome = cache.getLanguageHome();
                if (languageHome == null) continue;
                languageHomes.add(Paths.get(languageHome, new String[0]));
            }
            return new ResourcesFileSystem(resourcesFileSystem, delegateFileSystem, InternalResourceRoots.getInstance(), languageHomes);
        }

        private ResourcesFileSystem(org.graalvm.polyglot.io.FileSystem resourcesFileSystem, org.graalvm.polyglot.io.FileSystem delegateFileSystem, InternalResourceRoots resourceRoots, Collection<Path> languageHomes) {
            this.resourcesFileSystem = Objects.requireNonNull(resourcesFileSystem, "ResourcesFileSystem must be non-null");
            this.delegateFileSystem = Objects.requireNonNull(delegateFileSystem, "DelegateFileSystem must be non-null");
            this.resourceRoots = Objects.requireNonNull(resourceRoots, "ResourceRoots must be non-null");
            this.languageHomes = Objects.requireNonNull(languageHomes, "LanguageHomes must be non-null");
            Class<?> resourcesFileSystemPathType = this.resourcesFileSystem.parsePath("").getClass();
            Class<?> customFileSystemPathType = delegateFileSystem.parsePath("").getClass();
            if (resourcesFileSystemPathType != customFileSystemPathType) {
                throw new IllegalArgumentException("Given FileSystem must have the same Path type as the default FileSystem.");
            }
            if (!resourcesFileSystem.getSeparator().equals(delegateFileSystem.getSeparator())) {
                throw new IllegalArgumentException("Given FileSystem must use the same separator character as the default FileSystem.");
            }
            if (!resourcesFileSystem.getPathSeparator().equals(delegateFileSystem.getPathSeparator())) {
                throw new IllegalArgumentException("Given FileSystem must use the same path separator character as the default FileSystem.");
            }
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegateFileSystem);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).hasNoAccess();
        }

        @Override
        public boolean isHost() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).isHost();
        }

        @Override
        public Path parsePath(URI uri) {
            return this.delegateFileSystem.parsePath(uri);
        }

        @Override
        public Path parsePath(String path) {
            return this.delegateFileSystem.parsePath(path);
        }

        @Override
        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inResourceRoot(absolutePath)) {
                this.resourcesFileSystem.checkAccess(absolutePath, modes, linkOptions);
            } else {
                this.delegateFileSystem.checkAccess(path, modes, linkOptions);
            }
        }

        @Override
        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(dir);
            if (this.inResourceRoot(absolutePath)) {
                this.resourcesFileSystem.createDirectory(absolutePath, attrs);
            } else {
                this.delegateFileSystem.createDirectory(dir, attrs);
            }
        }

        @Override
        public void delete(Path path) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inResourceRoot(absolutePath)) {
                this.resourcesFileSystem.delete(absolutePath);
            } else {
                this.delegateFileSystem.delete(path);
            }
        }

        @Override
        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inResourceRoot(absolutePath)) {
                return this.resourcesFileSystem.newByteChannel(absolutePath, options, attrs);
            }
            return this.delegateFileSystem.newByteChannel(path, options, attrs);
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(dir);
            if (this.inResourceRoot(absolutePath)) {
                return this.resourcesFileSystem.newDirectoryStream(absolutePath, filter);
            }
            return this.delegateFileSystem.newDirectoryStream(dir, filter);
        }

        @Override
        public Path toAbsolutePath(Path path) {
            return this.delegateFileSystem.toAbsolutePath(path);
        }

        @Override
        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inResourceRoot(absolutePath)) {
                return this.resourcesFileSystem.toRealPath(path, new LinkOption[0]);
            }
            return this.delegateFileSystem.toRealPath(path, new LinkOption[0]);
        }

        @Override
        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inResourceRoot(absolutePath)) {
                return this.resourcesFileSystem.readAttributes(absolutePath, attributes, options);
            }
            return this.delegateFileSystem.readAttributes(path, attributes, options);
        }

        @Override
        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inResourceRoot(absolutePath)) {
                this.resourcesFileSystem.setAttribute(absolutePath, attribute, value, options);
            } else {
                this.delegateFileSystem.setAttribute(path, attribute, value, options);
            }
        }

        @Override
        public void createLink(Path link, Path existing) throws IOException {
            Path absoluteLink = this.toNormalizedAbsolutePath(link);
            Path absoluteExisting = this.toNormalizedAbsolutePath(existing);
            boolean linkInHome = this.inResourceRoot(absoluteLink);
            boolean existingInHome = this.inResourceRoot(absoluteExisting);
            if (linkInHome && existingInHome) {
                this.resourcesFileSystem.createLink(absoluteLink, absoluteExisting);
            } else if (!linkInHome && !existingInHome) {
                this.delegateFileSystem.createLink(link, existing);
            } else {
                throw new IOException("Cross file system linking is not supported.");
            }
        }

        @Override
        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            Path absoluteLink = this.toNormalizedAbsolutePath(link);
            Path absoluteTarget = this.toNormalizedAbsolutePath(target);
            boolean linkInHome = this.inResourceRoot(absoluteLink);
            boolean targetInHome = this.inResourceRoot(absoluteTarget);
            if (linkInHome && targetInHome) {
                this.resourcesFileSystem.createSymbolicLink(absoluteLink, target, new FileAttribute[0]);
            } else if (!linkInHome && !targetInHome) {
                this.delegateFileSystem.createSymbolicLink(link, target, new FileAttribute[0]);
            } else {
                throw new IOException("Cross file system linking is not supported.");
            }
        }

        @Override
        public Path readSymbolicLink(Path link) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(link);
            if (this.inResourceRoot(absolutePath)) {
                return this.resourcesFileSystem.readSymbolicLink(absolutePath);
            }
            return this.delegateFileSystem.readSymbolicLink(link);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.resourcesFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
            this.delegateFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
        }

        @Override
        public String getSeparator() {
            return this.delegateFileSystem.getSeparator();
        }

        @Override
        public String getPathSeparator() {
            return this.delegateFileSystem.getPathSeparator();
        }

        @Override
        public String getMimeType(Path path) {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inResourceRoot(absolutePath)) {
                return this.resourcesFileSystem.getMimeType(absolutePath);
            }
            return this.delegateFileSystem.getMimeType(path);
        }

        @Override
        public Charset getEncoding(Path path) {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inResourceRoot(absolutePath)) {
                return this.resourcesFileSystem.getEncoding(absolutePath);
            }
            return this.delegateFileSystem.getEncoding(path);
        }

        @Override
        public Path getTempDirectory() {
            return this.delegateFileSystem.getTempDirectory();
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            Path absolutePath1 = this.toNormalizedAbsolutePath(path1);
            Path absolutePath2 = this.toNormalizedAbsolutePath(path2);
            boolean path1InHome = this.inResourceRoot(absolutePath1);
            boolean path2InHome = this.inResourceRoot(absolutePath2);
            if (path1InHome && path2InHome) {
                return this.resourcesFileSystem.isSameFile(absolutePath1, absolutePath2, options);
            }
            if (!path1InHome && !path2InHome) {
                return this.delegateFileSystem.isSameFile(path1, path2, new LinkOption[0]);
            }
            return false;
        }

        private Path toNormalizedAbsolutePath(Path path) {
            if (path.isAbsolute()) {
                return path;
            }
            Path absolutePath = this.resourcesFileSystem.toAbsolutePath(path);
            if (ResourcesFileSystem.isNormalized(path)) {
                return absolutePath;
            }
            return absolutePath.normalize();
        }

        private static boolean isNormalized(Path path) {
            for (Path name : path) {
                String strName = name.toString();
                if (!".".equals(strName) && !"..".equals(strName)) continue;
                return false;
            }
            return true;
        }

        private boolean inResourceRoot(Path path) {
            if (!path.isAbsolute() || !ResourcesFileSystem.isNormalized(path)) {
                throw new IllegalArgumentException("The path must be normalized absolute path.");
            }
            if (this.resourceRoots.findRoot(path) != null) {
                return true;
            }
            for (Path home : this.languageHomes) {
                if (!path.startsWith(home)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ReadOnlyFileSystem
    extends DeniedIOFileSystem {
        private static final List<AccessMode> READ_MODES = Arrays.asList(AccessMode.READ, AccessMode.EXECUTE);
        private static final List<StandardOpenOption> READ_OPTIONS = Arrays.asList(StandardOpenOption.READ, StandardOpenOption.DSYNC, StandardOpenOption.SPARSE, StandardOpenOption.SYNC, StandardOpenOption.TRUNCATE_EXISTING);
        private final org.graalvm.polyglot.io.FileSystem delegateFileSystem;

        ReadOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
            this.delegateFileSystem = fileSystem;
        }

        @Override
        public Path parsePath(URI uri) {
            return this.delegateFileSystem.parsePath(uri);
        }

        @Override
        public Path parsePath(String path) {
            return this.delegateFileSystem.parsePath(path);
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegateFileSystem);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).hasNoAccess();
        }

        @Override
        public boolean isHost() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).isHost();
        }

        @Override
        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            HashSet<? extends AccessMode> writeModes = new HashSet<AccessMode>(modes);
            writeModes.removeAll(READ_MODES);
            if (!writeModes.isEmpty()) {
                throw new IOException("Read-only file");
            }
            this.delegateFileSystem.checkAccess(path, modes, linkOptions);
        }

        @Override
        public SeekableByteChannel newByteChannel(Path inPath, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            boolean write;
            HashSet<? extends OpenOption> copy = new HashSet<OpenOption>(options);
            HashSet<? extends OpenOption> writeOptions = new HashSet<OpenOption>(copy);
            boolean read = writeOptions.contains(StandardOpenOption.READ);
            writeOptions.removeAll(READ_OPTIONS);
            if (read) {
                writeOptions.remove(StandardOpenOption.APPEND);
            }
            boolean bl = write = !writeOptions.isEmpty();
            if (write) {
                throw FileSystems.forbidden(inPath);
            }
            return this.delegateFileSystem.newByteChannel(inPath, copy, attrs);
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            return this.delegateFileSystem.newDirectoryStream(dir, filter);
        }

        @Override
        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            return this.delegateFileSystem.readAttributes(path, attributes, options);
        }

        @Override
        public Path toAbsolutePath(Path path) {
            return this.delegateFileSystem.toAbsolutePath(path);
        }

        @Override
        public Path readSymbolicLink(Path link) throws IOException {
            return this.delegateFileSystem.readSymbolicLink(link);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.delegateFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
            super.setCurrentWorkingDirectory(currentWorkingDirectory);
        }

        @Override
        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            return this.delegateFileSystem.toRealPath(path, linkOptions);
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            return this.delegateFileSystem.isSameFile(path1, path2, options);
        }

        @Override
        public String getMimeType(Path path) {
            return this.delegateFileSystem.getMimeType(path);
        }

        @Override
        public Charset getEncoding(Path path) {
            return this.delegateFileSystem.getEncoding(path);
        }
    }

    private static class DeniedIOFileSystem
    implements PolyglotFileSystem {
        private final FileSystemProvider defaultFileSystemProvider = FileSystems.findDefaultFileSystemProvider();

        DeniedIOFileSystem() {
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return true;
        }

        @Override
        public boolean hasNoAccess() {
            return true;
        }

        @Override
        public boolean isHost() {
            return false;
        }

        @Override
        public Path parsePath(URI uri) {
            if (!this.defaultFileSystemProvider.getScheme().equals(uri.getScheme())) {
                throw new UnsupportedOperationException("Unsupported URI scheme " + uri.getScheme());
            }
            try {
                return this.defaultFileSystemProvider.getPath(uri);
            }
            catch (FileSystemNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        public Path parsePath(String path) {
            return Paths.get(path, new String[0]);
        }

        @Override
        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            throw FileSystems.forbidden(path);
        }

        @Override
        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            throw FileSystems.forbidden(dir);
        }

        @Override
        public void delete(Path path) throws IOException {
            throw FileSystems.forbidden(path);
        }

        @Override
        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            throw FileSystems.forbidden(source);
        }

        @Override
        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            throw FileSystems.forbidden(source);
        }

        @Override
        public SeekableByteChannel newByteChannel(Path inPath, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            throw FileSystems.forbidden(inPath);
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            throw FileSystems.forbidden(dir);
        }

        @Override
        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            throw FileSystems.forbidden(path);
        }

        @Override
        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            throw FileSystems.forbidden(path);
        }

        @Override
        public Path toAbsolutePath(Path path) {
            throw FileSystems.forbidden(path);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
        }

        @Override
        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            throw FileSystems.forbidden(path);
        }

        @Override
        public Path getTempDirectory() {
            throw FileSystems.forbidden(null);
        }

        @Override
        public void createLink(Path link, Path existing) {
            throw FileSystems.forbidden(link);
        }

        @Override
        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(link);
        }

        @Override
        public Path readSymbolicLink(Path link) throws IOException {
            throw FileSystems.forbidden(link);
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            throw FileSystems.forbidden(path1);
        }
    }

    private static final class PathOperationsOnlyFileSystem
    extends DeniedIOFileSystem {
        private final org.graalvm.polyglot.io.FileSystem delegateFileSystem;

        PathOperationsOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
            this.delegateFileSystem = fileSystem;
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegateFileSystem);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).hasNoAccess();
        }

        @Override
        public Path toAbsolutePath(Path path) {
            return this.delegateFileSystem.toAbsolutePath(path);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.delegateFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
            super.setCurrentWorkingDirectory(currentWorkingDirectory);
        }

        @Override
        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            return this.delegateFileSystem.toRealPath(path, linkOptions);
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            return this.delegateFileSystem.isSameFile(path1, path2, options);
        }
    }

    private static interface PolyglotFileSystem
    extends org.graalvm.polyglot.io.FileSystem {
        public boolean isInternal(AbstractPolyglotImpl var1);

        public boolean hasNoAccess();

        public boolean isHost();
    }

    private static final class FileTypeDetectorsSupplier
    implements Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> {
        private final Iterable<LanguageCache> languageCaches;

        FileTypeDetectorsSupplier(Iterable<LanguageCache> languageCaches) {
            this.languageCaches = languageCaches;
        }

        @Override
        public Map<String, Collection<? extends TruffleFile.FileTypeDetector>> get() {
            HashMap<String, Collection<? extends TruffleFile.FileTypeDetector>> detectors = new HashMap<String, Collection<? extends TruffleFile.FileTypeDetector>>();
            for (LanguageCache cache : this.languageCaches) {
                for (String mimeType : cache.getMimeTypes()) {
                    List<? extends TruffleFile.FileTypeDetector> languageDetectors = cache.getFileTypeDetectors();
                    Collection mimeTypeDetectors = (Collection)detectors.get(mimeType);
                    if (mimeTypeDetectors != null) {
                        if (languageDetectors.isEmpty()) continue;
                        ArrayList<? extends TruffleFile.FileTypeDetector> mergedDetectors = new ArrayList<TruffleFile.FileTypeDetector>(mimeTypeDetectors);
                        mergedDetectors.addAll(languageDetectors);
                        detectors.put(mimeType, mergedDetectors);
                        continue;
                    }
                    detectors.put(mimeType, languageDetectors);
                }
            }
            return detectors;
        }
    }

    private static final class InvalidFileSystem
    implements PolyglotFileSystem {
        private InvalidFileSystem() {
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return true;
        }

        @Override
        public boolean hasNoAccess() {
            return true;
        }

        @Override
        public boolean isHost() {
            return false;
        }

        @Override
        public Path parsePath(URI uri) {
            throw new UnsupportedOperationException("ParsePath not supported on InvalidFileSystem");
        }

        @Override
        public Path parsePath(String path) {
            throw new UnsupportedOperationException("ParsePath not supported on InvalidFileSystem");
        }

        @Override
        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) {
            throw FileSystems.forbidden(path);
        }

        @Override
        public void createDirectory(Path dir, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(dir);
        }

        @Override
        public void delete(Path path) {
            throw FileSystems.forbidden(path);
        }

        @Override
        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(path);
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) {
            throw FileSystems.forbidden(dir);
        }

        @Override
        public Path toAbsolutePath(Path path) {
            throw FileSystems.forbidden(path);
        }

        @Override
        public Path toRealPath(Path path, LinkOption ... linkOptions) {
            throw FileSystems.forbidden(path);
        }

        @Override
        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) {
            throw FileSystems.forbidden(path);
        }

        @Override
        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) {
            throw FileSystems.forbidden(path);
        }

        @Override
        public void copy(Path source, Path target, CopyOption ... options) {
            throw FileSystems.forbidden(source);
        }

        @Override
        public void move(Path source, Path target, CopyOption ... options) {
            throw FileSystems.forbidden(source);
        }

        @Override
        public void createLink(Path link, Path existing) {
            throw FileSystems.forbidden(link);
        }

        @Override
        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(link);
        }

        @Override
        public Path readSymbolicLink(Path link) {
            throw FileSystems.forbidden(link);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            throw FileSystems.forbidden(currentWorkingDirectory);
        }
    }

    static final class PreInitializeContextFileSystem
    implements PolyglotFileSystem {
        private org.graalvm.polyglot.io.FileSystem delegate;
        private Function<Path, PreInitializePath> factory;

        PreInitializeContextFileSystem(String tmpDir) {
            this.delegate = FileSystems.newDefaultFileSystem(tmpDir);
            this.factory = new ImageBuildTimeFactory();
        }

        void onPreInitializeContextEnd(InternalResourceRoots internalResourceRoots, Map<String, Path> languageHomes) {
            if (this.factory == null) {
                throw new IllegalStateException("Context pre-initialization already finished.");
            }
            ((ImageBuildTimeFactory)this.factory).onPreInitializeContextEnd(internalResourceRoots, languageHomes);
            this.factory = null;
            this.delegate = INVALID_FILESYSTEM;
        }

        void onLoadPreinitializedContext(org.graalvm.polyglot.io.FileSystem newDelegate) {
            Objects.requireNonNull(newDelegate, "NewDelegate must be non null.");
            if (this.factory != null) {
                throw new IllegalStateException("Pre-initialized context already loaded.");
            }
            this.delegate = newDelegate;
            this.factory = new ImageExecutionTimeFactory();
        }

        private static void verifyImageState() {
            if (ImageInfo.inImageBuildtimeCode()) {
                throw CompilerDirectives.shouldNotReachHere("Reintroducing absolute path into an image heap.");
            }
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegate);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegate instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegate).hasNoAccess();
        }

        @Override
        public boolean isHost() {
            return this.delegate instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegate).isHost();
        }

        @Override
        public Path parsePath(URI path) {
            return this.factory.apply(this.delegate.parsePath(path));
        }

        @Override
        public Path parsePath(String path) {
            return this.factory.apply(this.delegate.parsePath(path));
        }

        @Override
        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            this.delegate.checkAccess(PreInitializePath.unwrap(path), modes, linkOptions);
        }

        @Override
        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createDirectory(PreInitializePath.unwrap(dir), attrs);
        }

        @Override
        public void delete(Path path) throws IOException {
            this.delegate.delete(PreInitializePath.unwrap(path));
        }

        @Override
        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            return this.delegate.newByteChannel(PreInitializePath.unwrap(path), options, attrs);
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            final DirectoryStream<Path> delegateStream = this.delegate.newDirectoryStream(PreInitializePath.unwrap(dir), filter);
            return new DirectoryStream<Path>(this){
                final /* synthetic */ PreInitializeContextFileSystem this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Iterator<Path> iterator() {
                    return new ForwardingPath.ForwardingPathIterator<PreInitializePath>(delegateStream.iterator(), this.this$0.factory);
                }

                @Override
                public void close() throws IOException {
                    delegateStream.close();
                }
            };
        }

        @Override
        public Path toAbsolutePath(Path path) {
            return this.factory.apply(this.delegate.toAbsolutePath(PreInitializePath.unwrap(path)));
        }

        @Override
        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            return this.factory.apply(this.delegate.toRealPath(PreInitializePath.unwrap(path), linkOptions));
        }

        @Override
        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            return this.delegate.readAttributes(PreInitializePath.unwrap(path), attributes, options);
        }

        @Override
        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            this.delegate.setAttribute(PreInitializePath.unwrap(path), attribute, value, options);
        }

        @Override
        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.copy(PreInitializePath.unwrap(source), PreInitializePath.unwrap(target), options);
        }

        @Override
        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.move(PreInitializePath.unwrap(source), PreInitializePath.unwrap(target), options);
        }

        @Override
        public void createLink(Path link, Path existing) throws IOException {
            this.delegate.createLink(PreInitializePath.unwrap(link), PreInitializePath.unwrap(existing));
        }

        @Override
        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createSymbolicLink(PreInitializePath.unwrap(link), PreInitializePath.unwrap(target), attrs);
        }

        @Override
        public Path readSymbolicLink(Path link) throws IOException {
            return this.factory.apply(this.delegate.readSymbolicLink(PreInitializePath.unwrap(link)));
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.delegate.setCurrentWorkingDirectory(PreInitializePath.unwrap(currentWorkingDirectory));
        }

        @Override
        public String getSeparator() {
            return this.delegate.getSeparator();
        }

        @Override
        public Charset getEncoding(Path path) {
            return this.delegate.getEncoding(PreInitializePath.unwrap(path));
        }

        @Override
        public String getMimeType(Path path) {
            return this.delegate.getMimeType(PreInitializePath.unwrap(path));
        }

        @Override
        public Path getTempDirectory() {
            return this.factory.apply(this.delegate.getTempDirectory());
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            return this.delegate.isSameFile(PreInitializePath.unwrap(path1), PreInitializePath.unwrap(path2), options);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof PreInitializeContextFileSystem)) {
                return false;
            }
            return this.delegate.equals(((PreInitializeContextFileSystem)other).delegate);
        }

        private final class ImageBuildTimeFactory
        extends ImageExecutionTimeFactory {
            private final Collection<Reference<PreInitializePath>> emittedPaths;

            private ImageBuildTimeFactory() {
                this.emittedPaths = new ArrayList<Reference<PreInitializePath>>();
            }

            @Override
            public PreInitializePath apply(Path path) {
                if (path == null) {
                    return null;
                }
                PreInitializePath preInitPath = super.apply(path);
                this.emittedPaths.add(new WeakReference<PreInitializePath>(preInitPath));
                return preInitPath;
            }

            void onPreInitializeContextEnd(InternalResourceRoots internalResourceRoots, Map<String, Path> languageHomes) {
                for (Reference<PreInitializePath> pathRef : this.emittedPaths) {
                    PreInitializePath path = pathRef.get();
                    if (path == null) continue;
                    path.onPreInitializeContextEnd(internalResourceRoots, languageHomes);
                }
            }
        }

        private class ImageExecutionTimeFactory
        implements Function<Path, PreInitializePath> {
            private ImageExecutionTimeFactory() {
            }

            @Override
            public PreInitializePath apply(Path path) {
                return path == null ? null : new PreInitializePath(path);
            }
        }

        private final class PreInitializePath
        extends ForwardingPath<PreInitializePath>
        implements ResetablePath {
            private volatile Object delegatePath;

            PreInitializePath(Path delegatePath) {
                this.delegatePath = delegatePath;
            }

            @Override
            PreInitializePath wrap(Path path) {
                return PreInitializeContextFileSystem.this.factory.apply(path);
            }

            @Override
            Path unwrap() {
                Path result = this.resolve(PreInitializeContextFileSystem.this.delegate);
                this.delegatePath = result;
                return result;
            }

            private Path resolve(org.graalvm.polyglot.io.FileSystem fs) {
                Object current = this.delegatePath;
                if (current instanceof Path) {
                    return (Path)current;
                }
                if (current instanceof ImageHeapPath) {
                    return ((ImageHeapPath)current).resolve(fs);
                }
                throw new IllegalStateException("Unknown delegate " + String.valueOf(current));
            }

            void onPreInitializeContextEnd(InternalResourceRoots resourceRoots, Map<String, Path> languageHomes) {
                Path internalPath = (Path)this.delegatePath;
                ImageHeapPath result = null;
                InternalResourceCache owner = resourceRoots.findInternalResource(internalPath);
                if (owner != null) {
                    String relativePath = owner.getPathOrNull().relativize(internalPath).toString();
                    result = new InternalResourceImageHeapPath(owner, relativePath);
                }
                if (result == null) {
                    for (Map.Entry<String, Path> e : languageHomes.entrySet()) {
                        if (!internalPath.startsWith(e.getValue())) continue;
                        String languageId = e.getKey();
                        String relativePath = e.getValue().relativize(internalPath).toString();
                        result = new LanguageHomeImageHeapPath(languageId, relativePath);
                    }
                }
                if (result == null) {
                    result = new PathImageHeapPath(internalPath.toString(), internalPath.isAbsolute());
                }
                this.delegatePath = result;
            }

            @Override
            public boolean isAbsolute() {
                if (PreInitializeContextFileSystem.this.delegate == INVALID_FILESYSTEM) {
                    return ((ImageHeapPath)this.delegatePath).absolute;
                }
                return super.isAbsolute();
            }

            @Override
            public String toString() {
                if (PreInitializeContextFileSystem.this.delegate == INVALID_FILESYSTEM) {
                    ImageHeapPath imageHeapPath = (ImageHeapPath)this.delegatePath;
                    assert (imageHeapPath instanceof PathImageHeapPath) : "ToString can be called only for non internal resource files located outside of language homes.";
                    return imageHeapPath.path;
                }
                return super.toString();
            }

            @Override
            public String getReinitializedPath() {
                if (PreInitializeContextFileSystem.this.delegate != INVALID_FILESYSTEM) {
                    return this.toString();
                }
                PreInitializeContextFileSystem.verifyImageState();
                return this.resolve(FileSystems.newDefaultFileSystem(null)).toString();
            }

            @Override
            public URI getReinitializedURI() {
                if (PreInitializeContextFileSystem.this.delegate != INVALID_FILESYSTEM) {
                    return this.toUri();
                }
                PreInitializeContextFileSystem.verifyImageState();
                Path resolved = this.resolve(FileSystems.newDefaultFileSystem(null));
                if (!resolved.isAbsolute()) {
                    throw new IllegalArgumentException("Path must be absolute.");
                }
                return resolved.toUri();
            }
        }

        private static final class PathImageHeapPath
        extends ImageHeapPath {
            PathImageHeapPath(String path, boolean absolute) {
                super(path, absolute);
            }

            @Override
            Path resolve(org.graalvm.polyglot.io.FileSystem fileSystem) {
                return fileSystem.parsePath(this.path);
            }
        }

        private static final class InternalResourceImageHeapPath
        extends ImageHeapPath {
            private final InternalResourceCache cache;

            InternalResourceImageHeapPath(InternalResourceCache cache, String path) {
                super(path, false);
                this.cache = cache;
            }

            @Override
            Path resolve(org.graalvm.polyglot.io.FileSystem fileSystem) {
                return fileSystem.parsePath(this.cache.getPathOrNull().toString()).resolve(this.path);
            }
        }

        private static final class LanguageHomeImageHeapPath
        extends ImageHeapPath {
            private final String languageId;

            LanguageHomeImageHeapPath(String languageId, String path) {
                super(path, false);
                this.languageId = Objects.requireNonNull(languageId, "LanguageId must be non-null");
            }

            @Override
            Path resolve(org.graalvm.polyglot.io.FileSystem fileSystem) {
                String newLanguageHome = LanguageCache.languages().get(this.languageId).getLanguageHome();
                assert (newLanguageHome != null) : "Pre-initialized language " + this.languageId + " must exist in the image execution time.";
                return fileSystem.parsePath(newLanguageHome).resolve(this.path);
            }
        }

        private static abstract class ImageHeapPath {
            final String path;
            final boolean absolute;

            ImageHeapPath(String path, boolean absolute) {
                this.path = Objects.requireNonNull(path, "Path must be non-null");
                this.absolute = absolute;
            }

            abstract Path resolve(org.graalvm.polyglot.io.FileSystem var1);
        }
    }

    static interface ResetablePath
    extends Path {
        public String getReinitializedPath();

        public URI getReinitializedURI();
    }

    private static abstract class ForwardingPath<T extends ForwardingPath<T>>
    implements Path {
        private ForwardingPath() {
        }

        abstract T wrap(Path var1);

        abstract Path unwrap();

        static Path unwrap(Path path) {
            if (path instanceof ForwardingPath) {
                ForwardingPath forwardingPath = (ForwardingPath)path;
                return forwardingPath.unwrap();
            }
            return path;
        }

        @Override
        public FileSystem getFileSystem() {
            return null;
        }

        @Override
        public boolean isAbsolute() {
            return this.unwrap().isAbsolute();
        }

        @Override
        public Path getRoot() {
            return this.wrap(this.unwrap().getRoot());
        }

        @Override
        public Path getFileName() {
            return this.wrap(this.unwrap().getFileName());
        }

        @Override
        public Path getParent() {
            return this.wrap(this.unwrap().getParent());
        }

        @Override
        public int getNameCount() {
            return this.unwrap().getNameCount();
        }

        @Override
        public Path getName(int index) {
            return this.wrap(this.unwrap().getName(index));
        }

        @Override
        public Path subpath(int beginIndex, int endIndex) {
            return this.wrap(this.unwrap().subpath(beginIndex, endIndex));
        }

        @Override
        public boolean startsWith(Path other) {
            return this.unwrap().startsWith(ForwardingPath.unwrap(other));
        }

        @Override
        public boolean startsWith(String other) {
            return this.unwrap().startsWith(other);
        }

        @Override
        public boolean endsWith(Path other) {
            return this.unwrap().endsWith(ForwardingPath.unwrap(other));
        }

        @Override
        public boolean endsWith(String other) {
            return this.unwrap().endsWith(other);
        }

        @Override
        public Path normalize() {
            return this.wrap(this.unwrap().normalize());
        }

        @Override
        public Path resolve(Path other) {
            return this.wrap(this.unwrap().resolve(ForwardingPath.unwrap(other)));
        }

        @Override
        public Path resolve(String other) {
            return this.wrap(this.unwrap().resolve(other));
        }

        @Override
        public Path resolveSibling(Path other) {
            return this.wrap(this.unwrap().resolveSibling(ForwardingPath.unwrap(other)));
        }

        @Override
        public Path resolveSibling(String other) {
            return this.wrap(this.unwrap().resolveSibling(other));
        }

        @Override
        public Path relativize(Path other) {
            return this.wrap(this.unwrap().relativize(ForwardingPath.unwrap(other)));
        }

        @Override
        public URI toUri() {
            return this.unwrap().toUri();
        }

        @Override
        public Path toAbsolutePath() {
            return this.wrap(this.unwrap().toAbsolutePath());
        }

        @Override
        public Path toRealPath(LinkOption ... options) throws IOException {
            return this.wrap(this.unwrap().toRealPath(options));
        }

        @Override
        public File toFile() {
            return this.unwrap().toFile();
        }

        @Override
        public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Path> iterator() {
            return new ForwardingPathIterator<ForwardingPath>(this.unwrap().iterator(), this::wrap);
        }

        @Override
        public int compareTo(Path other) {
            return this.unwrap().compareTo(ForwardingPath.unwrap(other));
        }

        @Override
        public int hashCode() {
            return this.unwrap().hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ForwardingPath)) {
                return false;
            }
            return this.unwrap().equals(ForwardingPath.unwrap((Path)other));
        }

        @Override
        public String toString() {
            return this.unwrap().toString();
        }

        private static final class ForwardingPathIterator<T extends ForwardingPath<T>>
        implements Iterator<Path> {
            private final Iterator<Path> delegateIterator;
            private final Function<Path, T> wrap;

            ForwardingPathIterator(Iterator<Path> delegateIterator, Function<Path, T> wrap) {
                Objects.requireNonNull(delegateIterator, "DelegateIterator must be non-null.");
                Objects.requireNonNull(delegateIterator, "Wrap function must be non-null.");
                this.delegateIterator = delegateIterator;
                this.wrap = wrap;
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Path next() {
                return (Path)this.wrap.apply(this.delegateIterator.next());
            }
        }
    }
}

