/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.fs;

import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.EDT;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/eel/impl/fs/EelEarlyAccessChecker;", "", "<init>", "()V", "poorMansBloomFilter", "", "", "[Ljava/lang/Boolean;", "varHandle", "Ljava/lang/invoke/VarHandle;", "kotlin.jvm.PlatformType", "check", "", "path", "", "Companion", "intellij.platform.eel.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEelEarlyAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelEarlyAccessChecker.kt\ncom/intellij/platform/eel/impl/fs/EelEarlyAccessChecker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,62:1\n13#2:63\n*S KotlinDebug\n*F\n+ 1 EelEarlyAccessChecker.kt\ncom/intellij/platform/eel/impl/fs/EelEarlyAccessChecker\n*L\n60#1:63\n*E\n"})
public final class EelEarlyAccessChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Boolean[] poorMansBloomFilter;
    private final VarHandle varHandle;
    @NotNull
    private static final Logger LOG;

    public EelEarlyAccessChecker() {
        int n = 0;
        Boolean[] booleanArray = new Boolean[65536];
        EelEarlyAccessChecker eelEarlyAccessChecker = this;
        while (n < 65536) {
            int n2 = n++;
            booleanArray[n2] = true;
        }
        eelEarlyAccessChecker.poorMansBloomFilter = booleanArray;
        this.varHandle = MethodHandles.arrayElementVarHandle(this.poorMansBloomFilter.getClass());
    }

    public final void check(@NotNull String path) {
        ApplicationEx application;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        int it = path.hashCode();
        boolean bl = false;
        int hash = it & 0xFFFF ^ it >>> 16 & 0xFFFF;
        if (!this.varHandle.getAndSet(this.poorMansBloomFilter, hash, false)) {
            return;
        }
        ApplicationEx applicationEx = application = ApplicationManagerEx.getApplicationEx();
        if (!(applicationEx != null ? !applicationEx.isUnitTestMode() : false)) {
            return;
        }
        if (ApplicationManagerEx.isInIntegrationTest()) {
            return;
        }
        LOG.error("Remote file system accessed before Eel initialization. The description is in the source code.");
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EelEarlyAccessChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/eel/impl/fs/EelEarlyAccessChecker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.eel.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

