/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.clt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.wordpress.WPBundle;
import com.jetbrains.php.wordpress.clt.WPCommand;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class WPCliUtils {
    private static final Logger LOG = Logger.getInstance(WPCliUtils.class);

    private WPCliUtils() {
    }

    static List<FrameworkCommand> getFrameworkCommands(String[] wpCliPath, @Nullable Project project, @NotNull ProgressIndicator pi) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        List<FrameworkCommand> commands;
        if (pi == null) {
            WPCliUtils.$$$reportNull$$$0(0);
        }
        FrameworkDescription wpCliFramework = WPCliUtils.getWPCliFrameworkDescription(wpCliPath);
        ScriptRunnerUtil.ScriptOutput commandsOutput = WPCliUtils.getCommandsDescription(wpCliPath, project);
        FrameworkUtils.checkProgress((ProgressIndicator)pi);
        String descriptiveOutput = commandsOutput.getDescriptiveOutput();
        try {
            commands = WPCliUtils.parseCommandsJson(descriptiveOutput, wpCliFramework);
        }
        catch (JsonSyntaxException e) {
            LOG.warn(descriptiveOutput, (Throwable)e);
            throw new FrameworkDescriptionProvider.FrameworkParseException(WPCliUtils.getDescriptionCommand(wpCliPath), descriptiveOutput, WPBundle.message("wp.cli.failed.to.parse.output.0", e.getMessage()));
        }
        if (commands.isEmpty()) {
            throw new FrameworkDescriptionProvider.FrameworkParseException(WPCliUtils.getDescriptionCommand(wpCliPath), descriptiveOutput, WPBundle.message("wp.cli.no.commands.found", new Object[0]));
        }
        return commands;
    }

    public static List<FrameworkCommand> parseCommandsJson(String json, @NotNull FrameworkDescription framework) {
        JsonParser parser;
        JsonElement element;
        if (framework == null) {
            WPCliUtils.$$$reportNull$$$0(1);
        }
        if (!((element = (parser = new JsonParser()).parse(json)) instanceof JsonObject)) {
            throw new JsonSyntaxException("Parsed element is not an object.");
        }
        JsonObject object = (JsonObject)element;
        ArrayList<WPCommand> commands = new ArrayList<WPCommand>();
        JsonElement subcommands = object.get("subcommands");
        if (subcommands.isJsonArray()) {
            JsonArray subcommandsArray = subcommands.getAsJsonArray();
            for (JsonElement commandElement : subcommandsArray) {
                WPCommand command = WPCommand.parseCommand(commandElement, null);
                commands.add(command);
            }
        }
        ArrayList<FrameworkCommand> result = new ArrayList<FrameworkCommand>();
        for (WPCommand command : commands) {
            result.addAll(command.transform(framework));
        }
        return result;
    }

    static String getPrimitiveString(JsonObject source, String name, boolean failFast) {
        JsonElement element = source.get(name);
        if (element != null && element.isJsonPrimitive()) {
            return element.getAsString();
        }
        if (failFast) {
            if (element == null) {
                throw new JsonSyntaxException("Failed to find element " + name + " in " + String.valueOf(source));
            }
            if (!element.isJsonPrimitive()) {
                throw new JsonSyntaxException("Failed element " + name + " is not primitive in " + String.valueOf(source));
            }
        }
        return "";
    }

    private static ScriptRunnerUtil.ScriptOutput getCommandsDescription(String[] wpCliPath, @Nullable Project project) throws ExecutionException {
        return FrameworkUtils.executeCommandWithFullOutput((String[])WPCliUtils.getDescriptionCommand(wpCliPath), null, (Project)project, (boolean)true, (boolean)false);
    }

    @NonNls
    private static String[] getDescriptionCommand(String[] wpCliPath) {
        String[] stringArray;
        switch (wpCliPath.length) {
            case 0: {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "";
                stringArray2[1] = "cli";
                stringArray = stringArray2;
                stringArray2[2] = "cmd-dump";
                break;
            }
            case 1: {
                String[] stringArray3 = new String[3];
                stringArray3[0] = wpCliPath[0];
                stringArray3[1] = "cli";
                stringArray = stringArray3;
                stringArray3[2] = "cmd-dump";
                break;
            }
            default: {
                String[] stringArray4 = new String[4];
                stringArray4[0] = wpCliPath[0];
                stringArray4[1] = wpCliPath[1];
                stringArray4[2] = "cli";
                stringArray = stringArray4;
                stringArray4[3] = "cmd-dump";
            }
        }
        return stringArray;
    }

    @NonNls
    public static FrameworkDescription getWPCliFrameworkDescription(@NonNls String[] wpCliPath) {
        Object invokeText = wpCliPath[0];
        if (invokeText != null && ((String)invokeText).contains(" ")) {
            invokeText = "\"" + (String)invokeText + "\"";
        }
        if (wpCliPath.length > 1) {
            Object pharPath = wpCliPath[1];
            if (((String)pharPath).contains(" ")) {
                pharPath = "\"" + (String)pharPath + "\"";
            }
            invokeText = (String)invokeText + " " + (String)pharPath;
        }
        return new FrameworkDescription("WP-CLI_" + FrameworkUtils.getCurrentFormattedDate(), (String)invokeText, "wp", true, "org.wp-cli", null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/wordpress/clt/WPCliUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFrameworkCommands";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseCommandsJson";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

