/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.init;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.actions.update.ComposerInstalledPackagesService;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.wordpress.WPUtil;
import com.jetbrains.php.wordpress.settings.WPConfigurable;
import com.jetbrains.php.wordpress.settings.WPDataService;
import java.util.HashSet;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WPModuleDetectionManager {
    @NonNls
    private static final String[] HEADER_ELEMENTS = new String[]{"Plugin Name:", "Plugin URI:", "Description:", "Author:", "Version:"};
    @NonNls
    public static final String HEADER_COMMENT_ELEMENTS_TEXT;
    @NonNls
    private static final String PLUGINS_DIRECTORY_NAME = "plugins";
    private static final String[] COMPOSER_TYPES;
    private static final String[] COMPOSER_KEYWORDS;
    private static final String[] COMPOSER_LIB_NAMES;

    private WPModuleDetectionManager() {
    }

    public static void offerIntegrationSetup(Project project) {
        if (project == null || project.isDefault()) {
            return;
        }
        WPDataService dataService = WPDataService.getInstance(project);
        if (dataService.isEnabled() || dataService.doNotAskAgain()) {
            return;
        }
        ReadAction.nonBlocking(() -> WPModuleDetectionManager.searchForWPModule(project)).expireWith((Disposable)WPDataService.getInstance(project)).inSmartMode(project).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private static void searchForWPModule(Project project) {
        WPDataService dataService = WPDataService.getInstance(project);
        if (dataService.isEnabled() || dataService.doNotAskAgain()) {
            return;
        }
        VirtualFile wpModule = WPModuleDetectionManager.getWPModule(project);
        if (wpModule == null) {
            wpModule = WPModuleDetectionManager.getWpModuleByComposerJson(project);
        }
        if (wpModule == null) {
            return;
        }
        WPModuleDetectionManager.enableWPSupport(project, wpModule);
    }

    private static void enableWPSupport(Project project, @NotNull VirtualFile wpModule) {
        VirtualFile root;
        String path;
        if (wpModule == null) {
            WPModuleDetectionManager.$$$reportNull$$$0(0);
        }
        String string = path = (root = WPModuleDetectionManager.getWPRoot(wpModule)) != null ? FileUtil.toSystemDependentName((String)root.getPath()) : WPDataService.getLastWPPath();
        if (path == null) {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                WPModuleDetectionManager.showWPConfigurationPanel(project);
            }
        } else {
            WPDataService dataService = WPDataService.getInstance(project);
            WPDataService.State state = dataService.getState();
            state.setEnabled(true);
            state.setWPPath(path);
            dataService.setState(state);
        }
    }

    private static void showWPConfigurationPanel(Project project) {
        ApplicationManager.getApplication().invokeLater(() -> PhpUiUtil.editConfigurable((Project)project, (Configurable)new WPConfigurable(project){

            @Override
            public void reset() {
                this.myEnabledCheckBox.setSelected(true);
                this.updateSettingsPanelEnabled();
            }
        }));
    }

    @Nullable
    private static VirtualFile getWPRoot(@NotNull VirtualFile module) {
        VirtualFile plugins;
        VirtualFile parent;
        if (module == null) {
            WPModuleDetectionManager.$$$reportNull$$$0(1);
        }
        if ((parent = module.getParent()) == null) {
            return null;
        }
        if (!PLUGINS_DIRECTORY_NAME.equals(parent.getName())) {
            VirtualFile grandparent = parent.getParent();
            if (grandparent == null || !PLUGINS_DIRECTORY_NAME.equals(grandparent.getName())) {
                return null;
            }
            plugins = grandparent;
        } else {
            plugins = parent;
        }
        VirtualFile pluginsParent = plugins.getParent();
        if (pluginsParent == null) {
            return null;
        }
        VirtualFile pluginGrandparent = pluginsParent.getParent();
        if (pluginGrandparent != null && WPUtil.validateWPFolder(pluginGrandparent.getPath()) == null) {
            return pluginGrandparent;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getWpModuleByComposerJson(@NotNull Project project) {
        VirtualFile composer;
        if (project == null) {
            WPModuleDetectionManager.$$$reportNull$$$0(2);
        }
        if ((composer = ComposerConfigManager.getInstance((Project)project).getMainConfig()) == null) {
            return null;
        }
        try {
            String text = VirtualFileUtil.readText((VirtualFile)composer);
            JsonObject json = JsonParser.parseString((String)text).getAsJsonObject();
            String type = json.get("type").getAsString();
            if (ContainerUtil.exists((Object[])COMPOSER_TYPES, t -> t.equals(type))) {
                return composer;
            }
            JsonArray keywords = json.get("keywords").getAsJsonArray();
            for (JsonElement keyword : keywords) {
                if (!ContainerUtil.exists((Object[])COMPOSER_KEYWORDS, k -> k.equals(keyword.getAsString()))) continue;
                return composer;
            }
            for (ComposerInstalledPackagesService.InstalledPackage lib : ComposerInstalledPackagesService.getAllInstalledPackages((Project)project)) {
                if (!ContainerUtil.exists((Object[])COMPOSER_LIB_NAMES, l -> l.equals(lib.name()))) continue;
                return composer;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static VirtualFile getWPModule(@NotNull Project project) {
        if (project == null) {
            WPModuleDetectionManager.$$$reportNull$$$0(3);
        }
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
        GlobalSearchScope searchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.projectScope((Project)project), (FileType[])new FileType[]{PhpFileType.INSTANCE});
        if (searchHelper.isCheapEnoughToSearch(HEADER_COMMENT_ELEMENTS_TEXT, searchScope, null) != PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES) {
            return null;
        }
        WPSearchProcessor processor = new WPSearchProcessor(project);
        searchHelper.processCandidateFilesForText(searchScope, (short)2, true, HEADER_COMMENT_ELEMENTS_TEXT, (Processor)processor);
        return processor.result;
    }

    private static boolean isModuleFile(@Nullable PsiFile file) {
        if (!(file instanceof PhpFile)) {
            return false;
        }
        PhpFile phpFile = (PhpFile)file;
        PhpPsiElement element = phpFile.getFirstPsiChild();
        if (element == null) {
            return false;
        }
        String text = element.getText();
        if (text == null || !text.startsWith("<?php")) {
            return false;
        }
        return WPModuleDetectionManager.hasProperHeader((PsiElement)element) && !WPModuleDetectionManager.isProbablyJoomlaPlugin(phpFile);
    }

    private static boolean hasProperHeader(PsiElement element) {
        Boolean checkResult;
        PsiElement elementChild = element.getFirstChild();
        Ref isCCommentShown = new Ref((Object)false);
        Ref isPhpDocShown = new Ref((Object)false);
        if (elementChild != null) {
            elementChild = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)elementChild, (boolean)true);
            while (elementChild != null) {
                checkResult = WPModuleDetectionManager.checkElement(elementChild, (Ref<Boolean>)isPhpDocShown, (Ref<Boolean>)isCCommentShown);
                if (checkResult != null) {
                    return checkResult;
                }
                elementChild = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)elementChild, (boolean)true);
            }
        }
        if (((Boolean)isCCommentShown.get()).booleanValue() && ((Boolean)isPhpDocShown.get()).booleanValue()) {
            return false;
        }
        element = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)element, (boolean)true);
        while (element != null) {
            checkResult = WPModuleDetectionManager.checkElement(element, (Ref<Boolean>)isPhpDocShown, (Ref<Boolean>)isCCommentShown);
            if (checkResult != null) {
                return checkResult;
            }
            element = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)element, (boolean)true);
        }
        return false;
    }

    private static boolean isProbablyJoomlaPlugin(PhpFile phpFile) {
        PsiDirectory parent = phpFile.getParent();
        if (parent == null) {
            return false;
        }
        String nameWithoutExtension = phpFile.getVirtualFile().getNameWithoutExtension();
        PsiFile xmlSibling = parent.findFile(nameWithoutExtension + ".xml");
        if (!(xmlSibling instanceof XmlFile)) {
            return false;
        }
        XmlTag tag = ((XmlFile)xmlSibling).getRootTag();
        return tag != null && "extension".equals(tag.getName());
    }

    @Nullable
    private static Boolean checkElement(PsiElement sibling, Ref<Boolean> isPhpDocShown, Ref<Boolean> isCCommentShown) {
        if (sibling instanceof PsiComment) {
            if (sibling instanceof PhpDocComment) {
                if (((Boolean)isPhpDocShown.get()).booleanValue()) {
                    return false;
                }
                isPhpDocShown.set((Object)true);
                if (WPModuleDetectionManager.isHeaderComment(sibling)) {
                    return true;
                }
            } else {
                IElementType type = sibling.getNode().getElementType();
                if (type == PhpTokenTypes.C_STYLE_COMMENT) {
                    if (((Boolean)isCCommentShown.get()).booleanValue()) {
                        return false;
                    }
                    isCCommentShown.set((Object)true);
                    if (WPModuleDetectionManager.isHeaderComment(sibling)) {
                        return true;
                    }
                }
            }
        } else {
            return false;
        }
        return null;
    }

    private static boolean isHeaderComment(PsiElement element) {
        String text = element.getText();
        for (String keyElement : HEADER_ELEMENTS) {
            if (text.contains(keyElement)) continue;
            return false;
        }
        return true;
    }

    static {
        HashSet words = new HashSet();
        for (String element : HEADER_ELEMENTS) {
            words.addAll(StringUtil.getWordsIn((String)element));
        }
        HEADER_COMMENT_ELEMENTS_TEXT = StringUtil.join(words, (String)" ");
        COMPOSER_TYPES = new String[]{"wordpress-plugin", "wordpress-theme"};
        COMPOSER_KEYWORDS = new String[]{"wordpress", "wp"};
        COMPOSER_LIB_NAMES = new String[]{""};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wpModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/wordpress/init/WPModuleDetectionManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "enableWPSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getWPRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getWpModuleByComposerJson";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getWPModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class WPSearchProcessor
    implements Processor<VirtualFile> {
        private final PsiManager psiManager;
        private volatile VirtualFile result;

        private WPSearchProcessor(Project project) {
            this.psiManager = PsiManager.getInstance((Project)project);
        }

        public boolean process(VirtualFile file) {
            PsiFile psiFile = this.psiManager.findFile(file);
            if (WPModuleDetectionManager.isModuleFile(psiFile)) {
                this.result = file;
                return false;
            }
            return true;
        }
    }
}

