/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.paths;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpFilePathUtils;
import com.jetbrains.php.lang.psi.elements.impl.PhpFileReferenceSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WPFileReferenceSet
extends PhpFileReferenceSet {
    public WPFileReferenceSet(@NotNull PsiElement element, @Nullable PhpPsiElement argument, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            WPFileReferenceSet.$$$reportNull$$$0(0);
        }
        super(element, argument, provider);
    }

    @NotNull
    protected List<String> getDynamicPaths() {
        return WPFileReferenceSet.returnDynamicPartOfThePath(this.argument);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static List<String> returnDynamicPartOfThePath(PhpPsiElement psiElement) {
        int lastIndexOfSlash;
        ArrayList<String> paths = new ArrayList<String>();
        String currentPath = PhpFilePathUtils.getPathToFileContaining((PsiElement)psiElement);
        while (!currentPath.isEmpty() && (lastIndexOfSlash = currentPath.lastIndexOf(47)) != -1) {
            currentPath = currentPath.substring(0, lastIndexOfSlash);
            paths.add(currentPath);
        }
        Function<PsiElement, List<String>> overrideValueSupplier = WPFileReferenceSet.getOverrideValueSupplier(paths);
        @NotNull List dynamicPaths = PhpFilePathUtils.getDynamicPaths((PhpPsiElement)psiElement, () -> PhpFilePathUtils.getFileNames((PsiElement)psiElement, (Function)overrideValueSupplier));
        List list = ContainerUtil.notNullize((List)dynamicPaths);
        if (list == null) {
            WPFileReferenceSet.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private static Function<PsiElement, List<String>> getOverrideValueSupplier(List<String> paths) {
        Function<PsiElement, List<String>> function = element -> {
            if (element instanceof FunctionReference) {
                FunctionReference functionCall = (FunctionReference)element;
                if (!(element instanceof MethodReference)) {
                    String name = functionCall.getName();
                    if (PhpLangUtil.equalsFunctionNames((CharSequence)"get_template_directory_uri", (CharSequence)name) || PhpLangUtil.equalsFunctionNames((CharSequence)"get_template_directory", (CharSequence)name) || PhpLangUtil.equalsFunctionNames((CharSequence)"get_stylesheet_directory_uri", (CharSequence)name) || PhpLangUtil.equalsFunctionNames((CharSequence)"get_stylesheet_directory", (CharSequence)name)) {
                        return paths;
                    }
                    if (PhpLangUtil.equalsFunctionNames((CharSequence)name, (CharSequence)"plugins_url")) {
                        return Stream.of("/wp-content/plugins", "/wp-content/mu-plugins").flatMap(plugins -> WPFileReferenceSet.appendPluginDirs(functionCall, plugins)).flatMap(plugins -> WPFileReferenceSet.appendPaths(functionCall, plugins)).flatMap(plugins -> paths.stream().map(path -> WPFileReferenceSet.concatPaths(path, plugins))).collect(Collectors.toList());
                    }
                }
            }
            return null;
        };
        if (function == null) {
            WPFileReferenceSet.$$$reportNull$$$0(2);
        }
        return function;
    }

    @NotNull
    private static Stream<String> appendPaths(FunctionReference functionCall, String plugins) {
        List<String> evaluate = WPFileReferenceSet.evaluate(functionCall.getParameter(0));
        if (evaluate.isEmpty()) {
            Stream<String> stream = Stream.of(plugins);
            if (stream == null) {
                WPFileReferenceSet.$$$reportNull$$$0(3);
            }
            return stream;
        }
        Stream<String> stream = evaluate.stream().map(path -> WPFileReferenceSet.concatPaths(plugins, path));
        if (stream == null) {
            WPFileReferenceSet.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @NotNull
    private static Stream<String> appendPluginDirs(FunctionReference functionCall, String plugins) {
        List<String> evaluate = WPFileReferenceSet.evaluate(functionCall.getParameter(1));
        if (evaluate.isEmpty()) {
            Stream<String> stream = Stream.of(plugins);
            if (stream == null) {
                WPFileReferenceSet.$$$reportNull$$$0(5);
            }
            return stream;
        }
        Stream<String> stream = evaluate.stream().map(WPFileReferenceSet::getDir).map(pluginDir -> WPFileReferenceSet.concatPaths(plugins, pluginDir));
        if (stream == null) {
            WPFileReferenceSet.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @NotNull
    private static List<String> evaluate(@Nullable PsiElement element) {
        if (element == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                WPFileReferenceSet.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = PhpFilePathUtils.evaluate((PsiElement)element, null, (boolean)false);
        if (list == null) {
            WPFileReferenceSet.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static String concatPaths(String f, String s) {
        String string = StringUtil.trimEnd((String)f, (char)'/') + "/" + StringUtil.trimStart((String)s, (String)"/");
        if (string == null) {
            WPFileReferenceSet.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static String getDir(String plugin) {
        int i = plugin.lastIndexOf(47);
        if (i >= 0) {
            return plugin.substring(0, i);
        }
        return plugin;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/wordpress/paths/WPFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/wordpress/paths/WPFileReferenceSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "returnDynamicPartOfThePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverrideValueSupplier";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "appendPaths";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "appendPluginDirs";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "concatPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

