/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.PsiDependentFileContent;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.StringSearcher;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNullByDefault;

@NotNullByDefault
public abstract class CucumberStepIndex
extends FileBasedIndexExtension<Boolean, List<Integer>> {
    private static final List<String> STEP_KEYWORDS = CucumberStepIndex.loadStepKeywords();
    private static final DataExternalizer<List<Integer>> DATA_EXTERNALIZER = new DataExternalizer<List<Integer>>(){

        public void save(DataOutput out, List<Integer> value) throws IOException {
            DataInputOutputUtilRt.writeSeq((DataOutput)out, value, descriptor -> DataInputOutputUtilRt.writeINT((DataOutput)out, (int)descriptor));
        }

        public List<Integer> read(DataInput in) throws IOException {
            return DataInputOutputUtilRt.readSeq((DataInput)in, () -> DataInputOutputUtilRt.readINT((DataInput)in));
        }
    };

    private static List<String> loadStepKeywords() {
        List<String> list;
        ClassLoader classLoader = CucumberStepIndex.class.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("ClassLoader not available");
        }
        String filename = "step-keywords.json";
        InputStream stream = classLoader.getResourceAsStream(filename);
        if (stream == null) {
            throw new IllegalStateException("Could not load " + filename);
        }
        InputStreamReader in = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            TypeToken<Map<String, List<String>>> typeOfMap = new TypeToken<Map<String, List<String>>>(){};
            Map fromJson = (Map)new Gson().fromJson((Reader)in, typeOfMap.getType());
            if (fromJson == null) {
                throw new IllegalStateException("Failed to parse step keywords JSON");
            }
            list = fromJson.values().stream().flatMap(Collection::stream).toList();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Logger.getInstance((String)CucumberStepIndex.class.getName()).error((Throwable)e);
                throw new IllegalStateException("Failed to read step keywords", e);
            }
        }
        ((Reader)in).close();
        return list;
    }

    public DataIndexer<Boolean, List<Integer>, FileContent> getIndexer() {
        return inputData -> {
            CharSequence text = inputData.getContentAsText();
            if (!this.hasCucumberImport(text)) {
                return Collections.emptyMap();
            }
            LighterAST lighterAst = ((PsiDependentFileContent)inputData).getLighterAST();
            List<Integer> result = this.getStepDefinitionOffsets(lighterAst, text);
            HashMap<Boolean, List<Integer>> resultMap = new HashMap<Boolean, List<Integer>>();
            resultMap.put(true, result);
            return resultMap;
        };
    }

    public KeyDescriptor<Boolean> getKeyDescriptor() {
        return BooleanDataDescriptor.INSTANCE;
    }

    public DataExternalizer<List<Integer>> getValueExternalizer() {
        return DATA_EXTERNALIZER;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    protected abstract String[] getPackagesToScan();

    private boolean hasCucumberImport(CharSequence text) {
        for (String pkg : this.getPackagesToScan()) {
            StringSearcher searcher = new StringSearcher(pkg, true, true);
            if (searcher.scan(text) <= 0) continue;
            return true;
        }
        return false;
    }

    protected static boolean isStepDefinitionCall(LighterASTNode methodName, CharSequence text) {
        String actualMethodName = text.subSequence(methodName.getStartOffset(), methodName.getEndOffset()).toString();
        return STEP_KEYWORDS.contains(actualMethodName);
    }

    protected static boolean isStringLiteral(LighterASTNode element, CharSequence text) {
        return text.charAt(element.getStartOffset()) == '\"';
    }

    protected static boolean isNumber(LighterASTNode element, CharSequence text) {
        for (int i = element.getStartOffset(); i < element.getEndOffset(); ++i) {
            if (Character.isDigit(text.charAt(i))) continue;
            return false;
        }
        return element.getTextLength() > 0;
    }

    protected abstract List<Integer> getStepDefinitionOffsets(LighterAST var1, CharSequence var2);
}

