/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.GherkinInspection;
import org.jetbrains.plugins.cucumber.psi.GherkinElementFactory;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinUtil;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;

public final class GherkinScenarioToScenarioOutlineInspection
extends GherkinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GherkinScenarioToScenarioOutlineInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GherkinScenarioToScenarioOutlineInspection.$$$reportNull$$$0(1);
        }
        return new GherkinElementVisitor(this){

            @Override
            public void visitScenario(GherkinScenario scenario) {
                if (scenario instanceof GherkinScenarioOutline) {
                    return;
                }
                if (ContainerUtil.or((Object[])scenario.getChildren(), p -> PsiUtilCore.getElementType((PsiElement)p) == GherkinElementTypes.EXAMPLES_BLOCK)) {
                    holder.registerProblem((PsiElement)scenario, scenario.getFirstChild().getTextRangeInParent(), CucumberBundle.message("inspection.gherkin.scenario.with.examples.section.error.message", new Object[0]), new LocalQuickFix[]{Holder.CONVERT_SCENARIO_TO_OUTLINE_FIX});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/cucumber/inspections/GherkinScenarioToScenarioOutlineInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConvertScenarioToOutlineFix
    implements LocalQuickFix {
        private ConvertScenarioToOutlineFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CucumberBundle.message("inspection.gherkin.scenario.with.examples.section.quickfix.name", new Object[0]);
            if (string == null) {
                ConvertScenarioToOutlineFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ConvertScenarioToOutlineFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ConvertScenarioToOutlineFix.$$$reportNull$$$0(2);
            }
            GherkinScenario scenario = (GherkinScenario)descriptor.getPsiElement();
            String language = GherkinUtil.getFeatureLanguage((GherkinFile)scenario.getContainingFile());
            GherkinKeywordTable keywordsTable = JsonGherkinKeywordProvider.getKeywordProvider().getKeywordsTable(language);
            Collection<String> scenarioKeywords = keywordsTable.getScenarioKeywords();
            String scenarioRegexp = StringUtil.join(scenarioKeywords, (String)"|");
            String scenarioOutlineKeyword = keywordsTable.getScenarioOutlineKeyword();
            String scenarioOutlineText = scenario.getText().replaceFirst(scenarioRegexp, scenarioOutlineKeyword);
            GherkinScenarioOutline scenarioOutline = (GherkinScenarioOutline)GherkinElementFactory.createScenarioFromText(project, language, scenarioOutlineText);
            scenario.replace(scenarioOutline);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/GherkinScenarioToScenarioOutlineInspection$ConvertScenarioToOutlineFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/GherkinScenarioToScenarioOutlineInspection$ConvertScenarioToOutlineFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class Holder {
        static final LocalQuickFix CONVERT_SCENARIO_TO_OUTLINE_FIX = new ConvertScenarioToOutlineFix();

        private Holder() {
        }
    }
}

