/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinPsiElement;

@NotNullByDefault
public class GherkinSimpleReference
implements PsiReference {
    private final GherkinPsiElement myElement;

    public GherkinSimpleReference(GherkinPsiElement element) {
        this.myElement = element;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.myElement.getTextLength());
    }

    @Nullable
    public PsiElement resolve() {
        return this.myElement;
    }

    public String getCanonicalText() {
        return this.myElement.getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        GherkinPsiElement gherkinPsiElement = this.myElement;
        if (gherkinPsiElement instanceof PsiNamedElement) {
            PsiNamedElement element = (PsiNamedElement)gherkinPsiElement;
            element.setName(newElementName);
        }
        return this.myElement;
    }

    public PsiElement bindToElement(PsiElement element) throws IncorrectOperationException {
        return this.myElement;
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiElement resolved;
        PsiElement myResolved = this.resolve();
        PsiElement psiElement = resolved = element.getReference() != null ? element.getReference().resolve() : null;
        if (resolved == null) {
            resolved = element;
        }
        return resolved.equals((Object)myResolved);
    }

    public boolean isSoft() {
        return false;
    }
}

