/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCheckedRenameElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinPystring;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinPsiElementBase;
import org.jetbrains.plugins.cucumber.psi.refactoring.GherkinChangeUtil;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class GherkinStepImpl
extends GherkinPsiElementBase
implements GherkinStep,
PsiCheckedRenameElement {
    private static final TokenSet TEXT_FILTER = TokenSet.create((IElementType[])new IElementType[]{GherkinTokenTypes.TEXT, GherkinElementTypes.STEP_PARAMETER, TokenType.WHITE_SPACE, GherkinTokenTypes.STEP_PARAMETER_TEXT, GherkinTokenTypes.STEP_PARAMETER_BRACE});
    private final Object LOCK;
    private List<String> mySubstitutions;

    public GherkinStepImpl(@NotNull ASTNode node) {
        if (node == null) {
            GherkinStepImpl.$$$reportNull$$$0(0);
        }
        super(node);
        this.LOCK = new Object();
    }

    public String toString() {
        return "GherkinStep:" + this.getName();
    }

    @Override
    @Nullable
    public ASTNode getKeyword() {
        return this.getNode().findChildByType((IElementType)GherkinTokenTypes.STEP_KEYWORD);
    }

    @Override
    @NotNull
    protected String getElementText() {
        ASTNode node = this.getNode();
        Object[] children = node.getChildren(TEXT_FILTER);
        String string = StringUtil.join((Object[])children, astNode -> astNode.getText(), (String)"").trim();
        if (string == null) {
            GherkinStepImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public GherkinPystring getPystring() {
        return (GherkinPystring)PsiTreeUtil.findChildOfType((PsiElement)this, GherkinPystring.class);
    }

    @Override
    @Nullable
    public GherkinTable getTable() {
        ASTNode tableNode = this.getNode().findChildByType(GherkinElementTypes.TABLE);
        return tableNode == null ? null : (GherkinTable)tableNode.getPsi();
    }

    @Override
    protected String getPresentableText() {
        ASTNode keywordNode = this.getKeyword();
        String prefix = keywordNode != null ? keywordNode.getText() + ": " : "Step: ";
        return prefix + this.getName();
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.getReferencesInner(), (Object[])new Object[]{this}));
        if (psiReferenceArray == null) {
            GherkinStepImpl.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private PsiReference[] getReferencesInner() {
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
    }

    @Override
    protected void acceptGherkin(GherkinElementVisitor gherkinElementVisitor) {
        gherkinElementVisitor.visitStep(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<String> getParamsSubstitutions() {
        Object object = this.LOCK;
        // MONITORENTER : object
        if (this.mySubstitutions == null) {
            GherkinTable table;
            String tableText;
            String pystringText;
            ArrayList<String> substitutions = new ArrayList<String>();
            String text = this.getName();
            if (StringUtil.isEmpty((String)text)) {
                List<String> list = Collections.emptyList();
                // MONITOREXIT : object
                if (list != null) return list;
                GherkinStepImpl.$$$reportNull$$$0(3);
                return list;
            }
            CucumberUtil.addSubstitutionFromText(text, substitutions);
            GherkinPystring pystring = this.getPystring();
            String string = pystringText = pystring != null ? pystring.getText() : null;
            if (!StringUtil.isEmpty((String)pystringText)) {
                CucumberUtil.addSubstitutionFromText(pystringText, substitutions);
            }
            String string2 = tableText = (table = this.getTable()) == null ? null : table.getText();
            if (tableText != null) {
                CucumberUtil.addSubstitutionFromText(tableText, substitutions);
            }
            this.mySubstitutions = substitutions.isEmpty() ? Collections.emptyList() : substitutions;
        }
        List<String> list = this.mySubstitutions;
        // MONITOREXIT : object
        if (list != null) return list;
        GherkinStepImpl.$$$reportNull$$$0(4);
        return list;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.clearCaches();
    }

    @Override
    @Nullable
    public GherkinStepsHolder getStepHolder() {
        PsiElement parent = this.getParent();
        return parent != null ? (GherkinStepsHolder)parent : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaches() {
        Object object = this.LOCK;
        synchronized (object) {
            this.mySubstitutions = null;
        }
    }

    @Override
    @Nullable
    public String getSubstitutedName() {
        GherkinStepsHolder holder = this.getStepHolder();
        if (!(holder instanceof GherkinScenarioOutline)) {
            return this.getName();
        }
        GherkinScenarioOutline outline = (GherkinScenarioOutline)holder;
        return CucumberUtil.substituteTableReferences(this.getName(), outline.getOutlineTableMap()).getSubstitution();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiFile containingFile;
        if (name == null) {
            GherkinStepImpl.$$$reportNull$$$0(5);
        }
        if ((containingFile = this.getContainingFile()) == null) {
            throw new IllegalStateException("Cannot rename step whose containing file is null");
        }
        if (!(containingFile instanceof GherkinFile)) {
            throw new IllegalStateException("Cannot rename step whose containing file isn't GherkinFile");
        }
        GherkinFile gherkinFile = (GherkinFile)containingFile;
        ASTNode keyword = this.getKeyword();
        if (keyword == null) {
            throw new IllegalStateException("Cannot rename step whose keyword is null");
        }
        GherkinStep newStep = GherkinChangeUtil.createStep(keyword.getText() + " " + name, gherkinFile, this.getProject());
        this.replace(newStep);
        return newStep;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getElementText();
        if (string == null) {
            GherkinStepImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<AbstractStepDefinition> findDefinitions() {
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        for (PsiReference reference : this.getReferences()) {
            if (!(reference instanceof CucumberStepReference)) continue;
            CucumberStepReference cucumberStepReference = (CucumberStepReference)reference;
            result.addAll(cucumberStepReference.resolveToDefinitions());
        }
        ArrayList<AbstractStepDefinition> arrayList = result;
        if (arrayList == null) {
            GherkinStepImpl.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    public boolean isRenameAllowed(@Nullable String newName) {
        Collection<AbstractStepDefinition> definitions = this.findDefinitions();
        if (definitions.isEmpty()) {
            return false;
        }
        for (AbstractStepDefinition definition : definitions) {
            if (definition.supportsRename(newName)) continue;
            return false;
        }
        return true;
    }

    public void checkSetName(String name) {
        if (!this.isRenameAllowed(name)) {
            throw new IncorrectOperationException(CucumberBundle.message("cucumber.refactor.rename.bad_symbols", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/psi/impl/GherkinStepImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/impl/GherkinStepImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamsSubstitutions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

