/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.blade.BladeLanguage;
import com.jetbrains.php.blade.html.BladeHtmlFileType;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BladeFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private static final Logger LOG = Logger.getInstance(BladeFileViewProvider.class);
    private final Language myTemplateDataLanguage;
    private static final TemplateDataElementType ourHtmlTemplateDataType = new TemplateDataElementType("HTML TEMPLATE_DATA in Blade", BladeLanguage.INSTANCE, BladeTokenTypes.TEMPLATE_HTML_TEXT, BladeElementTypes.BLADE_OUTER_TYPE){

        protected boolean isInsertionToken(@Nullable IElementType tokenType, @NotNull CharSequence tokenSequence) {
            if (tokenSequence == null) {
                1.$$$reportNull$$$0(0);
            }
            return tokenType == BladeTokenTypes.TEMPLATE_PHP_TEXT && StringUtil.startsWith((CharSequence)tokenSequence, (CharSequence)"<?=") || tokenType == BladeTokenTypes.TEXT_BLOCK_START || tokenType == BladeTokenTypes.RAW_TEXT_BLOCK_START;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenSequence", "com/jetbrains/php/blade/BladeFileViewProvider$1", "isInsertionToken"));
        }
    };

    public BladeFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
        Language language = BladeFileViewProvider.getTemplateDataLanguage(virtualFile, manager.getProject());
        this.myTemplateDataLanguage = language instanceof TemplateLanguage ? PlainTextLanguage.INSTANCE : LanguageSubstitutors.getInstance().substituteLanguage(language, virtualFile, manager.getProject());
    }

    public BladeFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical, Language templateDataLanguage) {
        super(manager, virtualFile, physical);
        this.myTemplateDataLanguage = templateDataLanguage;
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = BladeLanguage.INSTANCE;
        if (language == null) {
            BladeFileViewProvider.$$$reportNull$$$0(0);
        }
        return language;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            BladeFileViewProvider.$$$reportNull$$$0(1);
        }
        return language;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = Set.of(BladeLanguage.INSTANCE, this.getTemplateDataLanguage());
        if (set == null) {
            BladeFileViewProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        if (fileCopy == null) {
            BladeFileViewProvider.$$$reportNull$$$0(3);
        }
        return new BladeFileViewProvider((PsiManager)this.getManager(), fileCopy, false, this.myTemplateDataLanguage);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        ParserDefinition parser;
        if (lang == null) {
            BladeFileViewProvider.$$$reportNull$$$0(4);
        }
        if ((parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)) == null) {
            return null;
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)parser.createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)ourHtmlTemplateDataType);
            return file;
        }
        if (lang == this.getBaseLanguage()) {
            return parser.createFile((FileViewProvider)this);
        }
        return null;
    }

    public static Language getTemplateDataLanguage(VirtualFile virtualFile, Project project) {
        Language language = TemplateDataLanguageMappings.getInstance((Project)project).getMapping(virtualFile);
        return language == null ? BladeHtmlFileType.INSTANCE.getLanguage() : language;
    }

    @Nullable
    public static PsiElement findCorrespondingPsiElement(@NotNull PsiElement psiElementInOtherLanguage, int offset, Language newLanguage) {
        PsiFile oldPsiFile;
        if (psiElementInOtherLanguage == null) {
            BladeFileViewProvider.$$$reportNull$$$0(5);
        }
        if ((oldPsiFile = psiElementInOtherLanguage.getContainingFile()) == null) {
            return null;
        }
        FileViewProvider viewProvider = oldPsiFile.getViewProvider();
        if (!(viewProvider instanceof BladeFileViewProvider)) {
            return null;
        }
        PsiFile phpPsiFile = viewProvider.getPsi(newLanguage);
        if (phpPsiFile == null) {
            return null;
        }
        return AbstractFileViewProvider.findElementAt((PsiElement)phpPsiFile, (int)offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/BladeFileViewProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCopy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementInOtherLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/BladeFileViewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCorrespondingPsiElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

