/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.blade.completion.BladeDirectiveLookupElement;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.injection.BladeInjectionMappingService;
import com.jetbrains.php.blade.parser.BladeDirectiveStack;
import com.jetbrains.php.blade.parser.BladeDirectiveStructureData;
import com.jetbrains.php.blade.psi.BladeDirectiveElementType;
import com.jetbrains.php.blade.psi.BladeFileImpl;
import com.jetbrains.php.blade.psi.BladePsiDirective;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BladeDirectiveCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final MultiMap<IElementType, IElementType> CLOSING_PREDEFINED_ORDER = new MultiMap(new HashMap<BladeDirectiveElementType, List<BladeDirectiveElementType>>(Map.of(BladeTokenTypes.IF_DIRECTIVE, List.of(BladeTokenTypes.ENDIF_DIRECTIVE), BladeTokenTypes.ISSET_DIRECTIVE, List.of(BladeTokenTypes.ENDISSET_DIRECTIVE), BladeTokenTypes.SECTION_DIRECTIVE, List.of(BladeTokenTypes.ENDSECTION_DIRECTIVE, BladeTokenTypes.SHOW_DIRECTIVE, BladeTokenTypes.STOP_DIRECTIVE))));
    private static final MultiMap<IElementType, IElementType> OPENING_PREDEFINED_ORDER = BladeDirectiveCompletionProvider.reverse(CLOSING_PREDEFINED_ORDER);
    private static final MultiMap<IElementType, IElementType> OPENING_DIRECTIVES = BladeDirectiveCompletionProvider.reverse(BladeDirectiveStructureData.CLOSING_DIRECTIVES);
    private static final Collection<BladeDirectiveElementType> OPTIONAL_PARAMETERIZED_DIRECTIVES = List.of(BladeTokenTypes.PHP_DIRECTIVE, BladeTokenTypes.LANG_DIRECTIVE);

    BladeDirectiveCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            BladeDirectiveCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            BladeDirectiveCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            BladeDirectiveCompletionProvider.$$$reportNull$$$0(2);
        }
        Map<String, BladeInjectionInfo> infos = BladeInjectionMappingService.getInstance(parameters.getOriginalFile().getProject()).getDirectiveInfos();
        String prefix = result.getPrefixMatcher().getPrefix();
        PsiElement position = parameters.getPosition();
        int offsetInPosition = parameters.getOffset() - position.getTextRange().getStartOffset();
        boolean hasAt = offsetInPosition > prefix.length() && position.getText().charAt(offsetInPosition - prefix.length() - 1) == '@';
        MissingDirectives missingDirectives = BladeDirectiveCompletionProvider.getMissingDirectives(parameters);
        MissingDirectiveNames missingDirectiveNames = new MissingDirectiveNames(BladeDirectiveCompletionProvider.getSortedDirectiveNames(missingDirectives.closing, BladeDirectiveStructureData.CLOSING_DIRECTIVES, CLOSING_PREDEFINED_ORDER), BladeDirectiveCompletionProvider.getSortedDirectiveNames(missingDirectives.opening, OPENING_DIRECTIVES, OPENING_PREDEFINED_ORDER));
        for (BladeDirectiveElementType bladeDirectiveElementType : OPTIONAL_PARAMETERIZED_DIRECTIVES) {
            String directiveText = bladeDirectiveElementType.getText();
            if (missingDirectiveNames.opening.contains(directiveText) || !directiveText.substring(1).startsWith(prefix)) continue;
            BladeDirectiveLookupElement lookupElement = new BladeDirectiveLookupElement(directiveText, parameters, Collections.emptyList(), null, hasAt, true);
            if (hasAt) {
                lookupElement.addLookupString(prefix);
            }
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)(hasAt ? 2.0 : 0.0)));
        }
        if (hasAt) {
            infos.entrySet().stream().filter(e -> ((String)e.getKey()).substring(1).startsWith(prefix)).sorted(Map.Entry.comparingByKey()).map(e -> BladeDirectiveCompletionProvider.createBladeLookupElement(e, parameters, missingDirectives.opening, true)).peek(e -> e.addLookupString(prefix)).map(e -> BladeDirectiveCompletionProvider.prioritizeMissingDirectives(e, missingDirectiveNames, 2)).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
        }
        for (Map.Entry entry : infos.entrySet()) {
            if (hasAt && ((String)entry.getKey()).substring(1).startsWith(prefix)) continue;
            BladeDirectiveLookupElement element = BladeDirectiveCompletionProvider.createBladeLookupElement(entry, parameters, missingDirectives.opening, hasAt);
            LookupElement prioritizedElement = BladeDirectiveCompletionProvider.prioritizeMissingDirectives(element, missingDirectiveNames, hasAt ? 2 : 0);
            result.addElement(prioritizedElement);
        }
    }

    private static BladeDirectiveLookupElement createBladeLookupElement(Map.Entry<String, BladeInjectionInfo> entry, @NotNull CompletionParameters parameters, @NotNull List<BladePsiDirective> missingOpeningDirectives, boolean hasAt) {
        if (parameters == null) {
            BladeDirectiveCompletionProvider.$$$reportNull$$$0(3);
        }
        if (missingOpeningDirectives == null) {
            BladeDirectiveCompletionProvider.$$$reportNull$$$0(4);
        }
        boolean isParametrized = entry.getValue() != null && !ContainerUtil.exists(OPTIONAL_PARAMETERIZED_DIRECTIVES, d -> d.getText().equals(entry.getKey()));
        return new BladeDirectiveLookupElement(entry.getKey(), parameters, missingOpeningDirectives, hasAt, isParametrized);
    }

    @NotNull
    private static LookupElement prioritizeMissingDirectives(BladeDirectiveLookupElement element, MissingDirectiveNames missingDirectives, int basePriority) {
        int index = missingDirectives.closing.indexOf(element.getLookupString()) + 1;
        index = index == 0 ? missingDirectives.opening.indexOf(element.getLookupString()) + 1 : index;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)element, (double)(index > 0 ? (double)(index + basePriority) : (double)basePriority));
        if (lookupElement == null) {
            BladeDirectiveCompletionProvider.$$$reportNull$$$0(5);
        }
        return lookupElement;
    }

    private static List<String> getSortedDirectiveNames(List<BladePsiDirective> directives, MultiMap<IElementType, IElementType> pairedDirectives, MultiMap<IElementType, IElementType> predefinedOrder) {
        return ContainerUtil.reverse(directives).stream().map(d -> d.getFirstChild().getNode().getElementType()).flatMap(type -> pairedDirectives.get(type).stream().sorted(BladeDirectiveCompletionProvider.predefinedOrderComparator(predefinedOrder.getModifiable(type)))).map(d -> (BladeDirectiveElementType)((Object)((Object)ObjectUtils.tryCast((Object)d, BladeDirectiveElementType.class)))).filter(Objects::nonNull).map(d -> d.getText()).collect(Collectors.toList());
    }

    @NotNull
    private static MissingDirectives getMissingDirectives(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            BladeDirectiveCompletionProvider.$$$reportNull$$$0(6);
        }
        final ArrayList<BladePsiDirective> missingClosingDirectives = new ArrayList<BladePsiDirective>();
        final ArrayList<BladePsiDirective> missingOpeningDirectives = new ArrayList<BladePsiDirective>();
        BladeDirectiveStack directiveStack = new BladeDirectiveStack(){

            @Override
            protected void reportMissingOpeningProblem(BladePsiDirective directive) {
                missingOpeningDirectives.add(directive);
            }

            @Override
            protected void reportMissingClosingProblem(BladePsiDirective directive) {
                missingClosingDirectives.add(directive);
            }
        };
        BladeFileImpl bladeFile = (BladeFileImpl)((Object)ContainerUtil.findInstance((Iterable)parameters.getOriginalFile().getViewProvider().getAllFiles(), BladeFileImpl.class));
        directiveStack.handleFile(bladeFile);
        return new MissingDirectives(missingClosingDirectives, missingOpeningDirectives);
    }

    private static Comparator<IElementType> predefinedOrderComparator(@Nullable Collection<IElementType> predefinedOrder) {
        if (predefinedOrder == null) {
            return Comparator.comparing(s -> 0);
        }
        ArrayList<IElementType> list = new ArrayList<IElementType>(predefinedOrder);
        return Comparator.comparing(o -> {
            int index = list.indexOf(o);
            if (index == -1) {
                return index;
            }
            return list.size() - index;
        });
    }

    private static <V, K> MultiMap<V, K> reverse(MultiMap<K, V> source) {
        return source.entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream().map(v -> Map.entry(v, e.getKey()))).collect(() -> new MultiMap(), (acc, a) -> acc.putValue(a.getKey(), a.getValue()), (a, b) -> {});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingOpeningDirectives";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/completion/BladeDirectiveCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/completion/BladeDirectiveCompletionProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "prioritizeMissingDirectives";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createBladeLookupElement";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMissingDirectives";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private record MissingDirectives(List<BladePsiDirective> closing, List<BladePsiDirective> opening) {
    }

    private record MissingDirectiveNames(List<String> closing, List<String> opening) {
    }
}

