/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.lang;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenterUtil;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.MultipleLangCommentProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.lang.PhpCommenter;
import com.jetbrains.php.lang.PhpLanguage;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BladeMultipleLangCommentProvider
implements MultipleLangCommentProvider {
    private static final InjectedPhpCommenter REDUCED_PHP_COMMENTER = new InjectedPhpCommenter();
    private static final PhpCommenter PHP_COMMENTER = new PhpCommenter();

    @Nullable
    public Commenter getLineCommenter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Language lineStartLanguage, @NotNull Language lineEndLanguage) {
        BladePsiLanguageInjectionHost host;
        if (file == null) {
            BladeMultipleLangCommentProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BladeMultipleLangCommentProvider.$$$reportNull$$$0(1);
        }
        if (lineStartLanguage == null) {
            BladeMultipleLangCommentProvider.$$$reportNull$$$0(2);
        }
        if (lineEndLanguage == null) {
            BladeMultipleLangCommentProvider.$$$reportNull$$$0(3);
        }
        if ((host = BladeMultipleLangCommentProvider.getBladeInjectionHost(file)) != null) {
            DocumentWindow document = (DocumentWindow)ObjectUtils.tryCast((Object)editor.getDocument(), DocumentWindow.class);
            if (document == null) {
                return REDUCED_PHP_COMMENTER;
            }
            TextRange hostLine = BladeMultipleLangCommentProvider.getHostLineRange(editor.getSelectionModel().getSelectionStart(), document);
            if (BladeMultipleLangCommentProvider.hasLineOnlyPhpFragments(host, hostLine)) {
                return PHP_COMMENTER;
            }
            return REDUCED_PHP_COMMENTER;
        }
        return null;
    }

    private static boolean hasLineOnlyPhpFragments(BladePsiLanguageInjectionHost host, @NotNull TextRange line) {
        if (line == null) {
            BladeMultipleLangCommentProvider.$$$reportNull$$$0(4);
        }
        if (host.getChildren().length == 0) {
            return false;
        }
        return Arrays.stream(host.getChildren()).filter(e -> line.contains(e.getTextRange())).map(e -> PsiUtilCore.getElementType((PsiElement)e)).allMatch(t -> BladeTokenTypes.TEMPLATE_PHP_TEXT == t || BladeElementTypes.PHP_FRAGMENT == t);
    }

    @NotNull
    private static TextRange getHostLineRange(int offset, @NotNull DocumentWindow document) {
        if (document == null) {
            BladeMultipleLangCommentProvider.$$$reportNull$$$0(5);
        }
        int injectedLine = document.getLineNumber(offset);
        int hostLine = document.injectedToHostLine(injectedLine);
        return new TextRange(document.getDelegate().getLineStartOffset(hostLine), document.getDelegate().getLineEndOffset(hostLine));
    }

    public boolean canProcess(@NotNull PsiFile file, @NotNull FileViewProvider viewProvider) {
        if (file == null) {
            BladeMultipleLangCommentProvider.$$$reportNull$$$0(6);
        }
        if (viewProvider == null) {
            BladeMultipleLangCommentProvider.$$$reportNull$$$0(7);
        }
        return BladeMultipleLangCommentProvider.getBladeInjectionHost(file) != null;
    }

    @Nullable
    private static BladePsiLanguageInjectionHost getBladeInjectionHost(PsiFile file) {
        if (file.getLanguage() != PhpLanguage.INSTANCE || !InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file)) {
            return null;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file);
        return host instanceof BladePsiLanguageInjectionHost ? (BladePsiLanguageInjectionHost)host : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineStartLanguage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineEndLanguage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/blade/lang/BladeMultipleLangCommentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineCommenter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasLineOnlyPhpFragments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getHostLineRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InjectedPhpCommenter
    implements Commenter,
    SelfManagingCommenter<CommenterDataHolder> {
        private InjectedPhpCommenter() {
        }

        @Nullable
        public String getLineCommentPrefix() {
            return null;
        }

        @NotNull
        public String getBlockCommentPrefix() {
            return "/*";
        }

        @NotNull
        public String getBlockCommentSuffix() {
            return "*/";
        }

        @Nullable
        public String getCommentedBlockCommentPrefix() {
            return null;
        }

        @Nullable
        public String getCommentedBlockCommentSuffix() {
            return null;
        }

        @Nullable
        public CommenterDataHolder createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
            if (document == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(0);
            }
            if (file == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(1);
            }
            return null;
        }

        @Nullable
        public CommenterDataHolder createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
            if (document == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(2);
            }
            if (file == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(3);
            }
            return null;
        }

        public void commentLine(int line, int offset, @NotNull Document document, @Nullable CommenterDataHolder data) {
            if (document == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(4);
            }
            if (!(document instanceof DocumentWindow)) {
                return;
            }
            DocumentWindow documentWindow = (DocumentWindow)document;
            Document bladeDocument = documentWindow.getDelegate();
            int bladeLine = documentWindow.injectedToHostLine(line);
            int selectionStart = bladeDocument.getLineStartOffset(bladeLine);
            int selectionEnd = bladeDocument.getLineEndOffset(bladeLine);
            SelfManagingCommenterUtil.insertBlockComment((int)selectionStart, (int)selectionEnd, (Document)bladeDocument, (String)"{{--", (String)"--}}");
        }

        public void uncommentLine(int line, int offset, @NotNull Document document, @Nullable CommenterDataHolder data) {
            if (document == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(5);
            }
        }

        public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
            if (document == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(6);
            }
            if (data == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(7);
            }
            return false;
        }

        @Nullable
        public String getCommentPrefix(int line, @NotNull Document document, @NotNull CommenterDataHolder data) {
            if (document == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(8);
            }
            if (data == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(9);
            }
            return null;
        }

        @Nullable
        public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
            if (document == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(10);
            }
            if (data == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(11);
            }
            return SelfManagingCommenterUtil.getBlockCommentRange((int)selectionStart, (int)selectionEnd, (Document)document, (String)this.getBlockCommentPrefix(), (String)this.getBlockCommentSuffix());
        }

        @Nullable
        public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull CommenterDataHolder data) {
            if (document == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(12);
            }
            if (data == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(13);
            }
            return this.getBlockCommentPrefix();
        }

        @Nullable
        public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
            if (document == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(14);
            }
            if (data == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(15);
            }
            return this.getBlockCommentSuffix();
        }

        public void uncommentBlockComment(int startOffset, int endOffset, Document document, CommenterDataHolder data) {
            SelfManagingCommenterUtil.uncommentBlockComment((int)startOffset, (int)endOffset, (Document)document, (String)this.getBlockCommentPrefix(), (String)this.getBlockCommentSuffix());
        }

        @NotNull
        public TextRange insertBlockComment(int startOffset, int endOffset, Document document, CommenterDataHolder data) {
            TextRange textRange = SelfManagingCommenterUtil.insertBlockComment((int)startOffset, (int)endOffset, (Document)document, (String)this.getBlockCommentPrefix(), (String)this.getBlockCommentSuffix());
            if (textRange == null) {
                InjectedPhpCommenter.$$$reportNull$$$0(16);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 16 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/blade/lang/BladeMultipleLangCommentProvider$InjectedPhpCommenter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/blade/lang/BladeMultipleLangCommentProvider$InjectedPhpCommenter";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insertBlockComment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createLineCommentingState";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createBlockCommentingState";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "commentLine";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "uncommentLine";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isLineCommented";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommentPrefix";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getBlockCommentRange";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getBlockCommentPrefix";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getBlockCommentSuffix";
                    break;
                }
                case 16: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 16 -> new IllegalStateException(string);
            };
        }
    }
}

