/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.ui;

import com.intellij.DynamicBundle;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.blade.injection.BladeInjectionMappingService;
import com.jetbrains.php.blade.ui.BladeDirectivesSettingsForm;
import com.jetbrains.php.blade.ui.BladeTextBlocksSettingsForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BladeSettingsForm {
    private JPanel myMainPanel;
    private JPanel myDirectivesPanel;
    private JPanel myTextBlocksPanel;
    private JBCheckBox myDefaultsCheckBox;
    private JBTabbedPane myTabbedPane;
    private final BladeTextBlocksSettingsForm myTextForm;
    private final BladeDirectivesSettingsForm myDirectivesForm;

    public BladeSettingsForm() {
        this.$$$setupUI$$$();
        this.myTextForm = new BladeTextBlocksSettingsForm();
        this.myDirectivesForm = new BladeDirectivesSettingsForm();
        this.myDefaultsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean defaultSettings = BladeSettingsForm.this.myDefaultsCheckBox.isSelected();
                if (defaultSettings) {
                    BladeSettingsForm.this.reset(BladeInjectionMappingService.getInstance(null));
                } else {
                    UIUtil.setEnabled((Component)BladeSettingsForm.this.myTabbedPane, (boolean)true, (boolean)true);
                }
            }
        });
        this.myDirectivesPanel.add((Component)this.myDirectivesForm.createComponent(), "Center");
        this.myTextBlocksPanel.add(this.myTextForm.createComponent(), "Center");
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified(BladeInjectionMappingService mappingService) {
        BladeInjectionMappingService.BladeState state = mappingService.getState();
        if (state.isDefault() != this.myDefaultsCheckBox.isSelected()) {
            return true;
        }
        if (state.isDefault()) {
            return false;
        }
        if (this.myTextForm.isModified(state)) {
            return true;
        }
        return this.myDirectivesForm.isModified(state);
    }

    public void apply(BladeInjectionMappingService instance) {
        BladeInjectionMappingService.BladeState state = new BladeInjectionMappingService.BladeState();
        boolean isDefault = this.myDefaultsCheckBox.isSelected();
        if (!isDefault) {
            state.setDefault(false);
            this.myTextForm.apply(state);
            this.myDirectivesForm.apply(state);
        }
        instance.resetFormState(state);
    }

    public void reset(BladeInjectionMappingService instance) {
        BladeInjectionMappingService.BladeState state = instance.getState();
        this.myDefaultsCheckBox.setSelected(state.isDefault());
        UIUtil.setEnabled((Component)this.myTabbedPane, (!this.myDefaultsCheckBox.isSelected() ? 1 : 0) != 0, (boolean)true);
        this.myTextForm.reset(state);
        this.myDirectivesForm.reset(instance);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel3.add((Component)jBTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(200, 200), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/BladeBundle", BladeSettingsForm.class).getString("settings.tab.text.tags"), null, jPanel4, null);
        this.myTextBlocksPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/BladeBundle", BladeSettingsForm.class).getString("settings.tab.directives"), null, jPanel5, null);
        this.myDirectivesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDefaultsCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeSettingsForm.class).getString("checkbox.use.default.settings"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

