/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.symfony;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.composer.configData.PackageComposerConfigClient;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.symfony.SymfonyDescriptionProvider;
import com.jetbrains.php.framework.generators.symfony.SymfonyVersion;
import com.jetbrains.php.framework.generators.symfonycomponent.SymfonyComponentUtils;
import com.jetbrains.php.framework.ui.CommandLineOpenSettingsProvider;
import com.jetbrains.php.framework.ui.FrameworkPathDialog;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SymfonyCommandLineComposerConfig
extends PackageComposerConfigClient {
    @NonNls
    private static final String PACKAGE = "symfony/console";
    public static final String CONSOLE = "console";
    public static final String SYMFONY = "symfony";

    private SymfonyCommandLineComposerConfig() {
        super(PACKAGE, PACKAGE);
    }

    public void updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter, @Nullable VirtualFile config) {
        FrameworkDataService instance;
        Pair<VirtualFile, SymfonyVersion> console;
        if (project == null) {
            SymfonyCommandLineComposerConfig.$$$reportNull$$$0(0);
        }
        if ((console = SymfonyCommandLineComposerConfig.findConsole(project)) != null && !ContainerUtil.exists((instance = FrameworkDataService.getInstance(project)).getCommands(), i -> i.getFrameworkDescription().getFrameworkId().equals("com.symfony"))) {
            PhpInterpreter phpInterpreter = (PhpInterpreter)ContainerUtil.find((Iterable)PhpInterpretersManagerImpl.getInstance((Project)project).getInterpreters(), i -> !i.isRemote());
            if (phpInterpreter == null) {
                return;
            }
            SymfonyDescriptionProvider.VersionedData versionedData = new SymfonyDescriptionProvider.VersionedData(new FrameworkPathDialog.Data(((VirtualFile)console.first).getPath(), phpInterpreter.getId()), (SymfonyVersion)((Object)console.second));
            FrameworkDescription description = SymfonyComponentUtils.getFrameworkDescription(versionedData.getData(), SYMFONY, SymfonyDescriptionProvider.getFrameworkNameText(), "com.symfony", versionedData.getVersion());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    List<FrameworkCommand> commands = new SymfonyDescriptionProvider().getFrameworkCommands(versionedData, project, (ProgressIndicator)new ProgressIndicatorBase());
                    List<FrameworkDataService.FrameworkFileData> data = instance.cloneData();
                    data.add(new FrameworkDataService.FrameworkFileData(new FrameworkConfigurationDescription(description, commands), null, ((VirtualFile)console.first).getPath(), true));
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> instance.loadChanged(data));
                    this.notify(project, FrameworkBundle.message("symfony.command.line.tool.updated", new Object[0]), new CommandLineOpenSettingsProvider());
                }
                catch (FrameworkDescriptionProvider.FrameworkExecutionException | FrameworkDescriptionProvider.FrameworkParseException exception) {
                    // empty catch block
                }
            });
        }
    }

    private static Pair<VirtualFile, SymfonyVersion> findConsole(@NotNull Project project) {
        VirtualFile dir;
        if (project == null) {
            SymfonyCommandLineComposerConfig.$$$reportNull$$$0(1);
        }
        if ((dir = project.getBaseDir()) == null) {
            return null;
        }
        VirtualFile version_3 = dir.findFileByRelativePath("bin/console");
        if (version_3 != null) {
            return Pair.create((Object)version_3, (Object)((Object)SymfonyVersion.VERSION_3));
        }
        VirtualFile version_2 = dir.findFileByRelativePath("app/console");
        if (version_2 != null) {
            return Pair.create((Object)version_2, (Object)((Object)SymfonyVersion.VERSION_2_0));
        }
        VirtualFile version_13 = dir.findFileByRelativePath("data/bin/symfony.bar");
        if (version_13 != null) {
            return Pair.create((Object)version_2, (Object)((Object)SymfonyVersion.VERSION_1_3_OR_1_4));
        }
        VirtualFile version_12 = dir.findFileByRelativePath("data/bin/symfony");
        if (version_12 != null) {
            return Pair.create((Object)version_2, (Object)((Object)SymfonyVersion.VERSION_1_1_OR_1_2));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/jetbrains/php/framework/generators/symfony/SymfonyCommandLineComposerConfig";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findConsole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

