/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.parsing;

import com.intellij.openapi.util.Pair;
import com.jetbrains.php.framework.data.FrameworkOption;
import com.jetbrains.php.framework.parsing.UserInputPart;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionPart
extends UserInputPart {
    public static final OptionPart EMPTY = new OptionPart("");
    private final String valueText;
    private final boolean hasValue;

    public OptionPart(String text) {
        this(text, false, null);
    }

    public OptionPart(String text, @NotNull String valueText) {
        if (valueText == null) {
            OptionPart.$$$reportNull$$$0(0);
        }
        this(text, true, valueText);
    }

    private OptionPart(String text, boolean hasValue, String valueText) {
        super(text);
        this.valueText = valueText;
        this.hasValue = hasValue;
    }

    public String getValueText() {
        return this.valueText;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OptionPart part = (OptionPart)o;
        if (this.hasValue != part.hasValue) {
            return false;
        }
        return !(this.valueText != null ? !this.valueText.equals(part.valueText) : part.valueText != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.valueText != null ? this.valueText.hashCode() : 0);
        result = 31 * result + (this.hasValue ? 1 : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return "OptionPart{valueText='" + this.valueText + "', hasValue=" + this.hasValue + "}";
    }

    @Nullable
    public static OptionPart cutOption(List<String> parts, List<FrameworkOption> params) {
        if (parts.isEmpty()) {
            return null;
        }
        String option = parts.get(0);
        if (!OptionPart.isOption(option)) {
            return null;
        }
        parts.remove(0);
        FrameworkOption frameworkOption = OptionPart.getMatchingOption(option, params);
        if (frameworkOption == null) {
            return new OptionPart(option);
        }
        FrameworkOption.ValuePattern pattern = frameworkOption.getValuePattern();
        if (pattern == null) {
            return new OptionPart(option);
        }
        if (!pattern.hasSeparateValue()) {
            Pair<String, String> optionAndValue = pattern.parseOptionAndValue(option);
            return new OptionPart((String)optionAndValue.getFirst(), (String)optionAndValue.getSecond());
        }
        if (parts.isEmpty()) {
            return new OptionPart(option);
        }
        String value = parts.get(0);
        if (!OptionPart.isOption(value)) {
            parts.remove(0);
            return new OptionPart(option, value);
        }
        return new OptionPart(option);
    }

    @Nullable
    public static FrameworkOption getMatchingOption(String part, List<FrameworkOption> params) {
        if (part == null) {
            return null;
        }
        for (FrameworkOption param : params) {
            if (!(param.getValuePattern() == null ? OptionPart.matchByName(part, param) : param.getValuePattern().matches(param, part))) continue;
            return param;
        }
        return null;
    }

    @Nullable
    public static FrameworkOption getMatchingOptionByName(@Nullable String part, @NotNull List<FrameworkOption> params) {
        if (params == null) {
            OptionPart.$$$reportNull$$$0(1);
        }
        if (part == null) {
            return null;
        }
        for (FrameworkOption param : params) {
            if (!OptionPart.matchByName(part, param)) continue;
            return param;
        }
        return null;
    }

    private static boolean matchByName(@NotNull String part, @NotNull FrameworkOption option) {
        if (part == null) {
            OptionPart.$$$reportNull$$$0(2);
        }
        if (option == null) {
            OptionPart.$$$reportNull$$$0(3);
        }
        return part.equals(option.getName()) || option.hasShortcut() && part.equals(option.getShortcut());
    }

    private static boolean isOption(String part) {
        return part.startsWith("-");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/framework/parsing/OptionPart";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMatchingOptionByName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "matchByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

