/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComboBox;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.ui.CommandLineToolsInterpreterCombo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkEditDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myInvokeField;
    private JTextField myAliasField;
    private JBCheckBox myEnabledCheckBox;
    private JRadioButton myProjectVisibilityRadioButton;
    private JRadioButton myGlobalVisibilityRadioButton;
    private JPanel myInterpreterPlaceHolder;
    private JBLabel myInterpreterLabel;
    JTextField myInterpreterTextField;
    PhpInterpreterComboBox myInterpreterComboBox;
    String myInterpreterName;
    private final FrameworkDataService.FrameworkFileData myFileData;
    Project myProject;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected FrameworkEditDialog(@NotNull Component parent, @NotNull FrameworkDataService.FrameworkFileData fileData) {
        if (parent == null) {
            FrameworkEditDialog.$$$reportNull$$$0(0);
        }
        if (fileData == null) {
            FrameworkEditDialog.$$$reportNull$$$0(1);
        }
        super(parent, true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(FrameworkBundle.message("framework.edit.dialog.title.edit.tool", objectArray));
        this.myFileData = fileData;
        FrameworkConfigurationDescription framework = fileData.getFramework();
        String invokeText = framework.getInvokeText();
        @NlsSafe List split = invokeText != null ? StringUtil.split((String)invokeText, (String)(!invokeText.contains("\"") ? " " : "\"")) : Collections.singletonList("");
        split = ContainerUtil.filter(split, s -> !" ".equals(s));
        String path = split.size() > 1 ? (String)split.get(1) : (String)split.get(0);
        this.myInvokeField.setText(path);
        this.myProject = FrameworkUtils.getProject(parent);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor().withTitle(FrameworkBundle.message("framework.settings.table.tool.path.header", new Object[0])).withDescription(FrameworkBundle.message("framework.choose.path.to.executable", new Object[0]));
        this.myInvokeField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>((ComponentWithBrowseButton)this.myInvokeField, this.myProject, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            public void actionPerformed(ActionEvent e) {
                String interpreterName = FrameworkEditDialog.this.myInterpreterComboBox.getSelectedItemName();
                if (interpreterName == null) {
                    super.actionPerformed(e);
                    return;
                }
                PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance((Project)FrameworkEditDialog.this.myProject);
                PhpInterpreter interpreter = manager.findInterpreter(interpreterName);
                if (interpreter == null || interpreter.isRemote()) {
                    return;
                }
                super.actionPerformed(e);
            }
        });
        this.myAliasField.setText(framework.getAlias());
        this.myEnabledCheckBox.setSelected(framework.isEnabled());
        if (fileData.isProjectVisibility()) {
            this.myProjectVisibilityRadioButton.setSelected(true);
        } else {
            this.myGlobalVisibilityRadioButton.setSelected(true);
        }
        this.myInterpreterComboBox = new CommandLineToolsInterpreterCombo(this.myProject);
        List interpreters = PhpInterpretersManagerImpl.getInstance((Project)this.myProject).getInterpreters();
        String string = this.myInterpreterName = split.size() > 1 ? StringUtil.trim((String)((String)split.get(0))) : "";
        if (StringUtil.isEmpty((String)this.myInterpreterName) || this.myInterpreterName.equals("EXECUTABLE")) {
            this.myInterpreterTextField = new JTextField();
            this.myInterpreterTextField.setVisible(false);
            this.myInterpreterLabel.setVisible(false);
        } else if ("PROJECT_DEFAULT_INTERPRETER".equals(this.myInterpreterName)) {
            this.myInterpreterComboBox.setModel(interpreters, null);
        } else {
            PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance((Project)this.myProject).findInterpreterById(this.myInterpreterName);
            if (interpreter != null) {
                this.myInterpreterComboBox.setModel(interpreters, interpreter);
            } else {
                try {
                    UUID.fromString(this.myInterpreterName);
                    PhpInterpreter unknownInterpreter = new PhpInterpreter();
                    unknownInterpreter.setName(FrameworkBundle.message("framework.settings.table.interpreter.unknown", new Object[0]));
                    this.myInterpreterComboBox.setModel(interpreters, unknownInterpreter);
                }
                catch (IllegalArgumentException iae) {
                    this.myInterpreterTextField = new JTextField();
                    this.myInterpreterTextField.setText(this.myInterpreterName);
                }
            }
        }
        this.myInterpreterPlaceHolder.add(this.myInterpreterTextField != null ? this.myInterpreterTextField : this.myInterpreterComboBox);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (StringUtil.isEmpty((String)this.myInvokeField.getText())) {
            return new ValidationInfo(FrameworkBundle.message("framework.0.not.provided", FrameworkBundle.message("framework.settings.table.tool.path.header", new Object[0])), (JComponent)this.myInvokeField);
        }
        if (StringUtil.isEmpty((String)this.myAliasField.getText())) {
            return new ValidationInfo(FrameworkBundle.message("framework.0.not.provided", FrameworkBundle.message("framework.settings.table.alias.header", new Object[0])), (JComponent)this.myAliasField);
        }
        return null;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected void doOKAction() {
        Object text;
        Object interpreterName;
        FrameworkConfigurationDescription framework = this.myFileData.getFramework();
        framework.setAlias(this.myAliasField.getText());
        if (this.myInterpreterTextField != null) {
            String interpreterText = this.myInterpreterTextField.getText();
            interpreterName = StringUtil.isEmpty((String)interpreterText) ? "EXECUTABLE" : interpreterText;
        } else {
            String selectedItemName = this.myInterpreterComboBox.getSelectedItemName();
            if (selectedItemName == null) {
                interpreterName = "PROJECT_DEFAULT_INTERPRETER";
            } else if (selectedItemName.equals(FrameworkBundle.message("framework.settings.table.interpreter.unknown", new Object[0]))) {
                interpreterName = this.myInterpreterName;
            } else {
                String interpreterId = PhpInterpretersManagerImpl.getInstance((Project)this.myProject).findInterpreterId(selectedItemName);
                Object object = interpreterName = interpreterId != null ? interpreterId : this.myInterpreterName;
            }
        }
        if (((String)interpreterName).contains(" ")) {
            interpreterName = "\"" + (String)interpreterName + "\"";
        }
        if (((String)(text = this.myInvokeField.getText())).contains(" ")) {
            text = "\"" + (String)text + "\"";
        }
        framework.setInvokeText((String)interpreterName + " " + (String)text);
        framework.setEnabled(this.myEnabledCheckBox.isSelected());
        this.myFileData.setProjectVisibility(this.myProjectVisibilityRadioButton.isSelected());
        super.doOKAction();
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "FrameworkEditDialogDimensionKey";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fileData";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/framework/ui/FrameworkEditDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(10, 10, 10, 10), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkEditDialog.class).getString("framework.custom.framework.dialog.tool.path"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInvokeField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkEditDialog.class).getString("framework.custom.framework.dialog.command.alias"));
        jPanel2.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAliasField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(3, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myEnabledCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkEditDialog.class).getString("checkbox.enabled"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkEditDialog.class).getString("label.visibility"));
        jPanel2.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectVisibilityRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkEditDialog.class).getString("radio.button.current.project"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGlobalVisibilityRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkEditDialog.class).getString("radio.button.global"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(4, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInterpreterLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkEditDialog.class).getString("php.interpreter"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myInterpreterPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

