/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.global.download;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.cloudclient.QDCloudResponse;
import org.jetbrains.qodana.global.QdGlobalConfigurations;
import org.jetbrains.qodana.global.download.ConfigurationFileType;
import org.jetbrains.qodana.global.download.GlobalConfiguration;
import org.jetbrains.qodana.global.download.GlobalConfigurationFile;
import org.jetbrains.qodana.global.download.QDCloudConfigurationProjectApiV1;
import org.jetbrains.qodana.global.download.QdGlobalConfigurationDownloader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0086@\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/global/download/QdGlobalConfigurationDownloader;", "", "()V", "downloadConfiguration", "Lorg/jetbrains/qodana/global/QdGlobalConfigurations$Configuration;", "api", "Lorg/jetbrains/qodana/global/download/QDCloudConfigurationProjectApiV1$V_XXX;", "progressPrinter", "Lkotlin/Function1;", "", "", "(Lorg/jetbrains/qodana/global/download/QDCloudConfigurationProjectApiV1$V_XXX;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadFile", "downloadUrl", "targetPath", "Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configuration"})
@SourceDebugExtension(value={"SMAP\ndownload.kt\nKotlin\n*S Kotlin\n*F\n+ 1 download.kt\norg/jetbrains/qodana/global/download/QdGlobalConfigurationDownloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1747#2,3:92\n*S KotlinDebug\n*F\n+ 1 download.kt\norg/jetbrains/qodana/global/download/QdGlobalConfigurationDownloader\n*L\n37#1:92,3\n*E\n"})
public final class QdGlobalConfigurationDownloader {
    @NotNull
    public static final QdGlobalConfigurationDownloader INSTANCE = new QdGlobalConfigurationDownloader();

    private QdGlobalConfigurationDownloader() {
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadConfiguration(@NotNull QDCloudConfigurationProjectApiV1.V_XXX var1_1, @NotNull Function1<? super String, Unit> var2_2, @NotNull Continuation<? super QdGlobalConfigurations.Configuration> var3_3) {
        if (!(var3_3 instanceof downloadConfiguration.1)) ** GOTO lbl-1000
        var14_4 = var3_3;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ QdGlobalConfigurationDownloader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadConfiguration(null, null, (Continuation<? super QdGlobalConfigurations.Configuration>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = progressPrinter;
                $continuation.label = 1;
                v0 = api.getGlobalProjectConfigurations((Continuation<? super QDCloudResponse<GlobalConfiguration>>)$continuation);
                if (v0 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                progressPrinter = (Function1)$continuation.L$1;
                this = (QdGlobalConfigurationDownloader)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if (!((var6_8 = (globalConfigurationResponse = (QDCloudResponse)v0)) instanceof QDCloudResponse.Success)) {
                    if (var6_8 instanceof QDCloudResponse.Error) {
                        progressPrinter.invoke((Object)"No global configuration available - using local configuration");
                        return null;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                globalConfiguration = (GlobalConfiguration)((QDCloudResponse.Success)globalConfigurationResponse).getValue();
                v1 = globalConfiguration.getFiles();
                if (v1 == null) {
                    $i$a$-run-QdGlobalConfigurationDownloader$downloadConfiguration$files$1 = false;
                    progressPrinter.invoke((Object)"No files found in global configuration");
                    return null;
                }
                files = v1;
                $this$any$iv = files;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl44
                v2 = false;
                ** GOTO lbl51
lbl44:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (GlobalConfigurationFile)element$iv;
                    $i$a$-any-QdGlobalConfigurationDownloader$downloadConfiguration$2 = false;
                    if (!(it.getFileType() == ConfigurationFileType.QODANA_YAML)) continue;
                    v2 = true;
                    ** GOTO lbl51
                }
                v2 = false;
lbl51:
                // 3 sources

                if (!v2) {
                    progressPrinter.invoke((Object)"No qodana.yaml file found in global configuration");
                    return null;
                }
                v3 = new FileAttribute[]{};
                v4 = Files.createTempDirectory("qodana-global-configurations", Arrays.copyOf(v3, v3.length));
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"createTempDirectory(...)");
                tmpDir = v4;
                $continuation.L$0 = progressPrinter;
                $continuation.L$1 = globalConfiguration;
                $continuation.label = 2;
                v5 = SupervisorKt.supervisorScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(files, tmpDir, (Function1<? super String, Unit>)progressPrinter, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ List<GlobalConfigurationFile> $files;
                    final /* synthetic */ Path $tmpDir;
                    final /* synthetic */ Function1<String, Unit> $progressPrinter;
                    {
                        this.$files = $files;
                        this.$tmpDir = $tmpDir;
                        this.$progressPrinter = $progressPrinter;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                ResultKt.throwOnFailure((Object)object);
                                CoroutineScope $this$supervisorScope = (CoroutineScope)this.L$0;
                                Iterable iterable = this.$files;
                                Path path = this.$tmpDir;
                                Function1<String, Unit> function1 = this.$progressPrinter;
                                boolean $i$f$map = false;
                                void var7_8 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void file;
                                    GlobalConfigurationFile globalConfigurationFile = (GlobalConfigurationFile)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(BuildersKt.async$default((CoroutineScope)$this$supervisorScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(path, (GlobalConfigurationFile)file, function1, null){
                                        Object L$0;
                                        int label;
                                        final /* synthetic */ Path $tmpDir;
                                        final /* synthetic */ GlobalConfigurationFile $file;
                                        final /* synthetic */ Function1<String, Unit> $progressPrinter;
                                        {
                                            this.$tmpDir = $tmpDir;
                                            this.$file = $file;
                                            this.$progressPrinter = $progressPrinter;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object var1_1) {
                                            var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                    targetPath = this.$tmpDir.resolve(this.$file.getPath());
                                                    v0 = this.$file.getS3Url();
                                                    Intrinsics.checkNotNull((Object)targetPath);
                                                    this.L$0 = targetPath;
                                                    this.label = 1;
                                                    v1 = QdGlobalConfigurationDownloader.INSTANCE.downloadFile(v0, targetPath, (Continuation<? super Unit>)((Continuation)this));
                                                    ** if (v1 != var4_2) goto lbl15
lbl14:
                                                    // 1 sources

                                                    return var4_2;
lbl15:
                                                    // 1 sources

                                                    ** GOTO lbl27
                                                }
                                                case 1: {
                                                    targetPath = (Path)this.L$0;
                                                    try {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v1 = $result;
                                                    }
                                                    catch (IOException e) {
                                                        this.$progressPrinter.invoke((Object)("Failed to download file " + this.$file.getPath() + ": " + e.getMessage()));
                                                        return null;
                                                    }
lbl27:
                                                    // 2 sources

                                                    return this.$file.getFileType() == ConfigurationFileType.QODANA_YAML ? targetPath : null;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Path> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null));
                                }
                                this.label = 1;
                                Object object3 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                                if (object3 != object2) return CollectionsKt.firstOrNull((List)CollectionsKt.filterNotNull((Iterable)((Iterable)object3)));
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return CollectionsKt.firstOrNull((List)CollectionsKt.filterNotNull((Iterable)((Iterable)object3)));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Path> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v5 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl71
            }
            case 2: {
                globalConfiguration = (GlobalConfiguration)$continuation.L$1;
                progressPrinter = (Function1)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl71:
                // 2 sources

                if ((yamlPath = (Path)v5) == null) {
                    progressPrinter.invoke((Object)"Failed to download qodana.yaml file from server");
                    return null;
                }
                v6 = globalConfiguration.getId();
                v7 = globalConfiguration.getName();
                v8 = globalConfiguration.getDescription();
                if (v8 == null) {
                    v8 = "";
                }
                configuration = new QdGlobalConfigurations.Configuration(v6, v7, v8, yamlPath.toString());
                return configuration;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object downloadFile(@NotNull String downloadUrl, @NotNull Path targetPath, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(targetPath, downloadUrl, null){
            int label;
            final /* synthetic */ Path $targetPath;
            final /* synthetic */ String $downloadUrl;
            {
                this.$targetPath = $targetPath;
                this.$downloadUrl = $downloadUrl;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Long l;
                        ResultKt.throwOnFailure((Object)object);
                        Path path = this.$targetPath.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
                        Object object2 = path;
                        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                        InputStream inputStream = new URL(this.$downloadUrl).openStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openStream(...)");
                        object2 = inputStream;
                        int n = 8192;
                        object2 = object2 instanceof BufferedInputStream ? (BufferedInputStream)object2 : new BufferedInputStream((InputStream)object2, n);
                        Path path2 = this.$targetPath;
                        Throwable throwable = null;
                        try {
                            InputStream inputStream2;
                            BufferedInputStream inputStream3 = (BufferedInputStream)object2;
                            boolean bl = false;
                            try {
                                inputStream2 = new GZIPInputStream(inputStream3);
                                int n2 = 8192;
                                inputStream2 = inputStream2 instanceof BufferedInputStream ? inputStream2 : new BufferedInputStream(inputStream2, n2);
                            }
                            catch (Exception exception) {
                                inputStream2 = inputStream3;
                            }
                            BufferedInputStream decompressedInputStream = inputStream2;
                            OpenOption[] openOptionArray = new OpenOption[]{};
                            OutputStream outputStream = Files.newOutputStream(path2, Arrays.copyOf(openOptionArray, openOptionArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                            l = Boxing.boxLong((long)decompressedInputStream.transferTo(outputStream));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                        }
                        return l;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

