/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicPhpTypedHandler
extends TypedHandlerDelegate {
    private boolean myOpenTagStringInsideXmlTag;
    @NlsSafe
    private static final String VAR_TAG = "@var";
    private static final Set<String> EMPTY_TAGS_MAP = Set.of("area", "base", "basefont", "br", "col", "embed", "frame", "hr", "meta", "img", "input", "isindex", "link", "param", "source", "track", "wbr");
    private static final Condition<PsiElement> USE_OPERATOR_SCOPES_CONDITION = element -> element instanceof PhpFile || element instanceof PhpNamespace;

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        PsiElement element;
        if (project == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(3);
        }
        CaretModel caret = editor.getCaretModel();
        int offset = caret.getOffset();
        this.myOpenTagStringInsideXmlTag = this.isOpenTagStringInsideXmlTag(c, editor, file, offset);
        if (BasicPhpTypedHandler.redundantCharAfterOpenTag(editor, c, file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                BasicPhpTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (c == '>' && offset > 0) {
            element = file.findElementAt(offset - 1);
            if (BasicPhpPsiUtil.isOfType(element, PhpTokenTypes.ARROW)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(5);
                }
                return result;
            }
            if (BasicPhpPsiUtil.isOfType(element, PhpTokenTypes.opHASH_ARRAY) && BasicPhpPsiUtil.isOfType(element.getParent(), PhpElementTypes.HASH_ARRAY_ELEMENT)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(6);
                }
                return result;
            }
        }
        if (c == ')' && (element = file.findElementAt(offset)) != null && PhpTokenTypes.CAST_OPERATORS.contains(element.getNode().getElementType()) && element.getTextRange().getEndOffset() - 1 == offset) {
            caret.moveToOffset(offset + 1);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                BasicPhpTypedHandler.$$$reportNull$$$0(7);
            }
            return result;
        }
        if (c == ';') {
            this.tryToMoveSemicolon(file, editor);
        }
        TypedHandlerDelegate.Result result = super.beforeCharTyped(c, project, editor, file, fileType);
        if (result == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(8);
        }
        return result;
    }

    protected boolean isOpenTagStringInsideXmlTag(char c, @NotNull Editor editor, @NotNull PsiFile file, int offset) {
        if (editor == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(9);
        }
        if (file == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(10);
        }
        return false;
    }

    protected void tryToMoveSemicolon(PsiFile file, Editor editor) {
    }

    protected boolean isAutoInsertFullPhpOpenTag() {
        return true;
    }

    protected boolean isInsertClosingHtmlTagInPhpDoc() {
        return true;
    }

    protected boolean isSingleHtmlTag(@NotNull String tagName) {
        if (tagName == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(11);
        }
        return EMPTY_TAGS_MAP.contains(StringUtil.toLowerCase((String)tagName));
    }

    protected void showCompletion(Editor editor) {
    }

    @NotNull
    public String getTypePresentation(@NotNull Project project, @NotNull PhpType phpType, @Nullable PhpPsiElement scope, PhpTypeDeclaration typeDeclaration) {
        if (project == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(12);
        }
        if (phpType == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(13);
        }
        String string = phpType.toString();
        if (string == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(14);
        }
        return string;
    }

    protected TypedHandlerDelegate.Result tryToAddOneLineDocComment(Editor editor, int offset, PsiFile file, Project project) {
        if (offset > 4 && "/** ".equals(editor.getDocument().getCharsSequence().subSequence(offset - 4, offset).toString())) {
            String typeTag;
            PhpDocComment docComment;
            PhpPsiElement target;
            String varDoc;
            PhpDocComment comment = (PhpDocComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PhpDocComment.class, (boolean)false);
            if (comment != null && BasicPhpTypedHandler.isCompleteDocComment((PsiElement)comment)) {
                return TypedHandlerDelegate.Result.STOP;
            }
            PsiComment cStyleComment = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiComment.class, (boolean)false);
            if (cStyleComment == null || cStyleComment.getTokenType() != PhpTokenTypes.C_STYLE_COMMENT) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)" */");
                editor.getCaretModel().moveCaretRelatively(-3, 0, false, false, false);
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
            if ((varDoc = this.getVarDocComment((PsiElement)(target = (docComment = (PhpDocComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset = editor.getCaretModel().getOffset()), PhpDocComment.class, (boolean)false)) != null ? docComment.getNextPsiSibling() : null), project, typeTag = VAR_TAG)) != null) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)varDoc);
                int additionalOffset = typeTag.length() + 1;
                if (target instanceof ForeachStatement && varDoc.startsWith("\n")) {
                    additionalOffset = 8;
                }
                if (target instanceof Statement) {
                    editor.getCaretModel().moveToOffset(offset + additionalOffset);
                } else {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)" ");
                }
                if (target instanceof ForeachStatement) {
                    PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
                    psiDocumentManager.commitDocument(editor.getDocument());
                    if (offset < target.getTextOffset()) {
                        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file, offset, target.getTextOffset());
                    }
                }
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @Nullable
    public String getVarDocComment(PsiElement target, Project project, @NotNull String typeTag) {
        if (typeTag == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(15);
        }
        if (target == null || target.getNode() == null) {
            return null;
        }
        StringBuilder commentBuf = new StringBuilder();
        commentBuf.append(typeTag);
        if (BasicPhpPsiUtil.isOfType(target, PhpElementTypes.CLASS_FIELDS, PhpElementTypes.CLASS_CONSTANTS)) {
            Field field = (Field)PsiTreeUtil.getChildOfType((PsiElement)target, Field.class);
            if (field == null) {
                return null;
            }
            PhpType type = BasicPhpTypedHandler.globalPreserving$This(field.getType(), field);
            PhpTypeDeclaration typeDeclaration = field.getTypeDeclaration();
            PhpPsiElement scopeForUseOperator = (PhpPsiElement)BasicPhpPsiUtil.getParentByCondition((PsiElement)field, false, USE_OPERATOR_SCOPES_CONDITION);
            String fieldType = this.getTypePresentation(project, type, scopeForUseOperator, typeDeclaration);
            if (!fieldType.isEmpty()) {
                commentBuf.append(' ').append(fieldType);
            }
        } else {
            Statement expr;
            if (target instanceof GroupStatement) {
                expr = (Statement)PsiTreeUtil.getChildOfType((PsiElement)target, Statement.class);
                if (expr == null) {
                    return null;
                }
            } else if (target instanceof Statement) {
                expr = (Statement)target;
            } else {
                return null;
            }
            if (expr instanceof ForeachStatement) {
                List<PsiElement> declarations = BasicPhpPsiUtil.getChildren((PsiElement)expr, (Condition<? super PsiElement>)((Condition)element -> element instanceof Variable && ((Variable)element).isDeclaration()));
                if (!declarations.isEmpty()) {
                    if (declarations.size() == 1) {
                        PsiReference ref;
                        PsiElement variable = declarations.get(0);
                        if (variable == null || (ref = variable.getReference()) == null) {
                            return null;
                        }
                        commentBuf.append("  ").append(ref.getCanonicalText());
                    } else {
                        boolean isFirst = true;
                        commentBuf.insert(0, "\n* ");
                        for (PsiElement variable : declarations) {
                            PsiReference ref;
                            if (!isFirst) {
                                commentBuf.append("\n* ");
                                commentBuf.append(typeTag);
                            }
                            if (variable == null || (ref = variable.getReference()) == null) {
                                return null;
                            }
                            commentBuf.append("  ").append(ref.getCanonicalText());
                            isFirst = false;
                        }
                    }
                }
            } else {
                PsiReference ref;
                PhpPsiElement assignment = expr.getFirstPsiChild();
                if (assignment == null || !BasicPhpPsiUtil.isOfType((PsiElement)assignment, PhpElementTypes.ASSIGNMENT_EXPRESSION)) {
                    return null;
                }
                PhpPsiElement variable = ((AssignmentExpression)assignment).getVariable();
                if (variable == null || (ref = variable.getReference()) == null) {
                    return null;
                }
                commentBuf.append("  ").append(ref.getCanonicalText());
            }
        }
        return commentBuf.toString();
    }

    private static boolean redundantCharAfterOpenTag(@NotNull Editor editor, char c, @Nullable PsiFile file) {
        if (editor == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(16);
        }
        if (c == 'p' || c == 'h') {
            return BasicPhpPsiUtil.findFullPhpTagAtOffset(file, editor.getCaretModel().getOffset()) != null;
        }
        return false;
    }

    public boolean isImmediatePaintingEnabled(@NotNull Editor editor, char c, @NotNull DataContext context) {
        if (editor == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(17);
        }
        if (context == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(18);
        }
        return !BasicPhpTypedHandler.redundantCharAfterOpenTag(editor, c, (PsiFile)context.getData(CommonDataKeys.PSI_FILE));
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(20);
        }
        if (file == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(21);
        }
        int offset = editor.getCaretModel().getOffset();
        if (!this.myOpenTagStringInsideXmlTag && editor.getCaretModel().getCaretCount() == 1 && c == '?' && offset > 1 && '<' == editor.getDocument().getCharsSequence().charAt(offset - 2) && this.isAutoInsertFullPhpOpenTag()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement prevElement = file.findElementAt(offset - 1);
            if (BasicPhpPsiUtil.isOfType(prevElement, PhpTokenTypes.PHP_OPENING_TAG) && prevElement.getText().equals("<?")) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"php");
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
        }
        if (!(file instanceof PhpFile)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                BasicPhpTypedHandler.$$$reportNull$$$0(22);
            }
            return result;
        }
        switch (c) {
            case '=': {
                PsiElement possibleArrayValue = BasicPhpPsiUtil.getPrevSiblingIgnoreWhitespace(file.findElementAt(offset - 1), true);
                if (!BasicPhpPsiUtil.isOfType(possibleArrayValue, PhpElementTypes.ARRAY_VALUE)) break;
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                PsiElement typedEquals = file.findElementAt(offset - 1);
                if (typedEquals == null || !BasicPhpPsiUtil.isOfType(typedEquals.getParent(), PhpElementTypes.ASSIGNMENT_EXPRESSION) || !BasicPhpPsiUtil.isOfType(typedEquals.getParent().getParent(), PhpElementTypes.ARRAY_VALUE)) break;
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)">");
                break;
            }
            case '-': {
                if (offset > 6 && "$this-".equals(editor.getDocument().getCharsSequence().subSequence(offset - 6, offset).toString())) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)">");
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    this.showCompletion(editor);
                }
            }
            case ' ': {
                TypedHandlerDelegate.Result result = this.tryToAddOneLineDocComment(editor, offset, file, project);
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(23);
                }
                return result;
            }
            case '{': {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.DEFAULT;
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(24);
                }
                return result;
            }
            case ':': {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                PsiElement currElement = file.findElementAt(offset);
                if (currElement != null) {
                    currElement = currElement.getParent();
                    IElementType parentType = PsiUtilCore.getElementType((PsiElement)currElement);
                    if (currElement != null && (parentType == PhpElementTypes.CASE || parentType == PhpElementTypes.CASE_DEFAULT)) {
                        CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, currElement.getTextOffset());
                    }
                }
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(25);
                }
                return result;
            }
            case ';': {
                BasicPhpTypedHandler.autoIndentBreak(project, editor, file, offset);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(26);
                }
                return result;
            }
            case '@': {
                if (BasicPhpTypedHandler.isInDocComment(project, editor, file, offset)) {
                    BasicPhpTypedHandler.stripExtraSpaces(editor, offset);
                }
            }
            case '>': {
                this.insertClosingHtmlTagInPhpDoc(project, editor, file);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(27);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(28);
        }
        return result;
    }

    private void insertClosingHtmlTagInPhpDoc(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(29);
        }
        if (editor == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(30);
        }
        if (file == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(31);
        }
        if (!this.isInsertClosingHtmlTagInPhpDoc()) {
            return;
        }
        PsiDocumentManager psiDocManager = PsiDocumentManager.getInstance((Project)project);
        Document document = editor.getDocument();
        psiDocManager.commitDocument(document);
        int offset = editor.getCaretModel().getOffset();
        if (document.getText().length() <= offset) {
            return;
        }
        PsiElement element = file.findElementAt(offset - 1);
        if (!BasicPhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_HTML_TAG) || BasicPhpTypedHandler.isClosingHtmlTag(element)) {
            return;
        }
        String tagName = BasicPhpTypedHandler.getTagName(element);
        if (tagName == null) {
            return;
        }
        Object nextHtmlTagWithSameName = BasicPhpPsiUtil.getNextSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)e -> tagName.equals(BasicPhpTypedHandler.getTagName(e))));
        if (BasicPhpTypedHandler.isClosingHtmlTag(nextHtmlTagWithSameName) || this.isSingleHtmlTag(tagName)) {
            return;
        }
        String closingTag = "</" + tagName + ">";
        document.insertString(offset, (CharSequence)closingTag);
    }

    @Nullable
    private static String getTagName(@NotNull PsiElement tag) {
        if (tag == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(32);
        }
        if (!BasicPhpPsiUtil.isOfType(tag, PhpDocTokenTypes.DOC_HTML_TAG)) {
            return null;
        }
        String prefix = StringUtil.substringBefore((String)tag.getText(), (String)">");
        if (prefix == null) {
            return null;
        }
        return BasicPhpTypedHandler.isClosingHtmlTag(tag) ? StringUtil.substringAfter((String)prefix, (String)"</") : StringUtil.substringAfter((String)prefix, (String)"<");
    }

    private static boolean isClosingHtmlTag(@Nullable PsiElement element) {
        return BasicPhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_HTML_TAG) && element.getText().startsWith("</");
    }

    private static void autoIndentBreak(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int offset) {
        boolean indentBreak;
        if (project == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(33);
        }
        if (editor == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(34);
        }
        if (file == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(35);
        }
        if (!(indentBreak = CodeStyle.getLanguageSettings((PsiFile)file, (Language)PhpLanguage.INSTANCE).INDENT_BREAK_FROM_CASE)) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement currElement = file.findElementAt(offset - 1);
            if (currElement != null && BasicPhpPsiUtil.isOfType(currElement = currElement.getParent(), PhpElementTypes.BREAK)) {
                PsiElement parent = currElement.getParent();
                if (parent instanceof GroupStatement) {
                    parent = parent.getParent();
                }
                if (BasicPhpPsiUtil.isOfType(parent, PhpElementTypes.CASE)) {
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, currElement.getTextOffset());
                }
            }
        }
    }

    private static void stripExtraSpaces(Editor editor, int atOffset) {
        int lineEnd;
        int line;
        int lineStart;
        Document document = editor.getDocument();
        String original = document.getText(new TextRange(lineStart = document.getLineStartOffset(line = document.getLineNumber(atOffset)), lineEnd = document.getLineEndOffset(line)));
        Object replacement = original.substring(0, original.length() - 1);
        if ("*".equals(((String)replacement).trim())) {
            int starPos = ((String)replacement).indexOf(42);
            replacement = ((String)replacement).substring(0, starPos + 1) + " @";
            document.replaceString(lineStart, lineEnd, (CharSequence)replacement);
        }
    }

    private static boolean isInDocComment(Project project, Editor editor, PsiFile file, int offset) {
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement currElement = file.findElementAt(offset);
        if (currElement != null) {
            PsiElement parent = currElement.getParent();
            return parent instanceof PhpDocComment;
        }
        return false;
    }

    protected static boolean isCompleteDocComment(PsiElement docComment) {
        for (PsiElement child = docComment.getFirstChild(); child != null; child = child.getNextSibling()) {
            ASTNode childNode = child.getNode();
            if (childNode == null) {
                return false;
            }
            IElementType elementType = childNode.getElementType();
            if (child instanceof PsiErrorElement || elementType == PhpDocTokenTypes.DOC_IGNORED) {
                return false;
            }
            if (elementType != PhpDocTokenTypes.DOC_COMMENT_END) continue;
            return true;
        }
        return true;
    }

    @NotNull
    public static PhpType globalPreserving$This(@NotNull PhpType type, @NotNull PsiElement context) {
        if (type == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(36);
        }
        if (context == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(37);
        }
        PhpType global = new PhpType();
        for (String s : type.getTypes()) {
            global.add(BasicPhpTypedHandler.getGlobalPreservingPolymorphicType(s, context));
        }
        PhpType phpType = global;
        if (phpType == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(38);
        }
        return phpType;
    }

    @Nullable
    private static String getGlobalPreservingPolymorphicType(String type, @NotNull PsiElement context) {
        if (context == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(39);
        }
        if (context instanceof Method) {
            if (PhpTypeSignatureKey.SELF_CLASS.isSigned(type)) {
                return "self";
            }
            return PhpTypeSignatureKey.POLYMORPHIC_CLASS.isSigned(type) ? (((Method)context).isStatic() ? "static" : "$this") : type;
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 14, 22, 23, 24, 25, 26, 27, 28, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 16: 
            case 17: 
            case 20: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 10: 
            case 21: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/editor/BasicPhpTypedHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeTag";
                break;
            }
            case 18: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/editor/BasicPhpTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypePresentation";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "globalPreserving$This";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 38: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isOpenTagStringInsideXmlTag";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSingleHtmlTag";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypePresentation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVarDocComment";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "redundantCharAfterOpenTag";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isImmediatePaintingEnabled";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "insertClosingHtmlTagInPhpDoc";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTagName";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "autoIndentBreak";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "globalPreserving$This";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalPreservingPolymorphicType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 14, 22, 23, 24, 25, 26, 27, 28, 38 -> new IllegalStateException(string);
        };
    }
}

