/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.editor;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import org.jetbrains.annotations.NotNull;

public final class PhpDeleteAttributePartBackspaceHandler
extends BackspaceHandlerDelegate {
    private boolean myDeleteAttributeStart;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            PhpDeleteAttributePartBackspaceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpDeleteAttributePartBackspaceHandler.$$$reportNull$$$0(1);
        }
        this.myDeleteAttributeStart = c == '[' && file instanceof PhpFile && PhpDeleteAttributePartBackspaceHandler.isEmptyAttribute(file, editor);
    }

    private static boolean isEmptyAttribute(@NotNull PsiFile file, @NotNull Editor editor) {
        int offset;
        if (file == null) {
            PhpDeleteAttributePartBackspaceHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PhpDeleteAttributePartBackspaceHandler.$$$reportNull$$$0(3);
        }
        if ((offset = editor.getCaretModel().getOffset()) < 2) {
            return false;
        }
        CharSequence documentChars = editor.getDocument().getCharsSequence();
        if (documentChars.charAt(offset - 2) != '#') {
            return false;
        }
        PsiElement at = file.findElementAt(offset - 1);
        return BasicPhpPsiUtil.isOfType(at, PhpTokenTypes.ATTRIBUTE_START) && BasicPhpPsiUtil.isOfType(at.getNextSibling(), PhpTokenTypes.chRBRACKET);
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            PhpDeleteAttributePartBackspaceHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            PhpDeleteAttributePartBackspaceHandler.$$$reportNull$$$0(5);
        }
        if (this.myDeleteAttributeStart) {
            int offset = editor.getCaretModel().getOffset();
            editor.getDocument().deleteString(offset - 1, offset + 1);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/editor/PhpDeleteAttributePartBackspaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEmptyAttribute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

