/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpAlignmentProcessor;
import com.jetbrains.php.lang.formatter.PhpBlock;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpSpacingProcessor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSyntheticBlock
implements Block,
PhpAlignmentProcessor.ProcessorContainer {
    private final List<Block> myChildBlocks;
    private final TextRange myTextRange;
    private final Indent myIndent;
    private final PhpCodeStyleSettings myPhpSettings;
    private final PhpSpacingProcessor mySpacingProcessor;
    private final PhpAlignmentProcessor myAlignmentProcessor;

    public PhpSyntheticBlock(List<Block> childBlocks, CodeStyleSettings settings, @NotNull XmlFormattingPolicy xmlFormattingPolicy) {
        if (xmlFormattingPolicy == null) {
            PhpSyntheticBlock.$$$reportNull$$$0(0);
        }
        assert (!childBlocks.isEmpty()) : "Attempt to create an empty PhpSyntheticBlock";
        this.myPhpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        this.myChildBlocks = childBlocks;
        Block startBlock = this.myChildBlocks.get(0);
        Block endBlock = this.myChildBlocks.get(this.myChildBlocks.size() - 1);
        this.myTextRange = new TextRange(startBlock.getTextRange().getStartOffset(), endBlock.getTextRange().getEndOffset());
        this.myIndent = startBlock.getIndent();
        this.processIndents(childBlocks);
        ASTNode parentNode = ((PhpBlock)startBlock).getNode().getTreeParent();
        this.mySpacingProcessor = new PhpSpacingProcessor(parentNode, settings.getCommonSettings((Language)PhpLanguage.INSTANCE), this.myPhpSettings, xmlFormattingPolicy);
        this.myAlignmentProcessor = new PhpAlignmentProcessor(this, parentNode, settings.getCommonSettings((Language)PhpLanguage.INSTANCE), this.myPhpSettings);
    }

    private void processIndents(List<Block> blocks) {
        for (Block block : blocks) {
            assert (block instanceof PhpBlock) : "PhpSyntheticBlock must contain only PhpBlocks, found " + String.valueOf(block.getClass());
            if (BasicPhpPsiUtil.isOfType(((PhpBlock)block).getNode(), PhpTokenTypes.PHP_OPENING_TAG, PhpTokenTypes.PHP_ECHO_OPENING_TAG, PhpTokenTypes.PHP_CLOSING_TAG, PhpElementTypes.NON_LAZY_GROUP_STATEMENT)) {
                ((PhpBlock)block).setIndent(Indent.getNoneIndent());
                continue;
            }
            ((PhpBlock)block).setIndent(this.myPhpSettings.INDENT_CODE_IN_PHP_TAGS ? Indent.getNormalIndent() : Indent.getNoneIndent());
        }
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            PhpSyntheticBlock.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.myChildBlocks;
        if (list == null) {
            PhpSyntheticBlock.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return null;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            PhpSyntheticBlock.$$$reportNull$$$0(3);
        }
        return this.mySpacingProcessor.getSpacing(child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(this.myPhpSettings.INDENT_CODE_IN_PHP_TAGS ? Indent.getNormalIndent() : Indent.getNoneIndent(), null);
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public PhpAlignmentProcessor getAlignmentProcessor() {
        return this.myAlignmentProcessor;
    }

    public BlockWithParent getParent() {
        return null;
    }

    public void setParent(BlockWithParent newParent) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFormattingPolicy";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpSyntheticBlock";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpSyntheticBlock";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

