/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions.logical;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.expressions.AssignmentExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.logical.AndExpression;
import com.jetbrains.php.lang.parser.parsing.functions.Function;

public final class OrExpression {
    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker fun = builder.mark();
        IElementType result = Function.parse(builder, true);
        if (result == PhpStubElementTypes.FUNCTION) {
            fun.done(PhpElementTypes.CLOSURE);
            return PhpElementTypes.CLOSURE;
        }
        fun.drop();
        PsiBuilder.Marker marker = builder.mark();
        result = AndExpression.parse(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            if (builder.compareAndEat(PhpTokenTypes.opOR)) {
                result = AssignmentExpression.parseWithoutPriority(builder);
                if (result == PhpElementTypes.EMPTY_INPUT) {
                    result = AndExpression.parse(builder);
                }
                if (result == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.getExpressionExpectedMessage());
                }
                PsiBuilder.Marker newMarker = marker.precede();
                marker.done(PhpElementTypes.LOGICAL_EXPRESSION);
                result = PhpElementTypes.LOGICAL_EXPRESSION;
                if (builder.compareAndEat(PhpTokenTypes.opOR)) {
                    OrExpression.subParse(builder, newMarker);
                } else {
                    newMarker.drop();
                }
            } else {
                marker.drop();
            }
        } else {
            marker.drop();
        }
        return result;
    }

    private static IElementType subParse(PhpPsiBuilder builder, PsiBuilder.Marker marker) {
        IElementType result = AssignmentExpression.parseWithoutPriority(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            result = AndExpression.parse(builder);
        }
        if (result == PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.getExpressionExpectedMessage());
        }
        PsiBuilder.Marker newMarker = marker.precede();
        marker.done(PhpElementTypes.LOGICAL_EXPRESSION);
        if (builder.compareAndEat(PhpTokenTypes.opOR)) {
            OrExpression.subParse(builder, newMarker);
        } else {
            newMarker.drop();
        }
        return PhpElementTypes.LOGICAL_EXPRESSION;
    }
}

