/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BasicPhpPsiUtil {
    private static final Condition<PsiElement> SKIP_INSIDE_NAMED_ARGUMENT_PART = Conditions.or(PsiWhiteSpace.class::isInstance, PsiComment.class::isInstance);

    private BasicPhpPsiUtil() {
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable ASTNode node, @NotNull IElementType type) {
        if (type == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(0);
        }
        return PsiUtilCore.getElementType((ASTNode)node) == type;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable ASTNode node, @NotNull TokenSet types) {
        if (types == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(1);
        }
        return types.contains(PsiUtilCore.getElementType((ASTNode)node));
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable ASTNode node, IElementType ... aType) {
        IElementType elementType;
        if (aType == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(2);
        }
        return (elementType = PsiUtilCore.getElementType((ASTNode)node)) != null && ArrayUtil.contains((Object)elementType, (Object[])aType);
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable PsiElement element, IElementType ... aType) {
        IElementType elementType;
        if (aType == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(3);
        }
        return (elementType = PsiUtilCore.getElementType((PsiElement)element)) != null && ArrayUtil.contains((Object)elementType, (Object[])aType);
    }

    @Nullable
    public static ASTNode getLastChildByType(@NotNull ASTNode astNode, IElementType type) {
        if (astNode == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(4);
        }
        for (ASTNode element = astNode.getLastChildNode(); element != null; element = element.getTreePrev()) {
            if (element.getElementType() != type) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public static PhpPsiElement findPrevPhpPsiElement(PsiElement element) {
        while (element != null) {
            if (element.getNode() instanceof CompositeElement) {
                return element instanceof PhpPsiElement ? (PhpPsiElement)element : null;
            }
            element = element.getPrevSibling();
        }
        return null;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable PsiElement element, @NotNull IElementType type) {
        if (type == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(5);
        }
        return PsiUtilCore.getElementType((PsiElement)element) == type;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable PsiElement element, @NotNull TokenSet types) {
        if (types == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(6);
        }
        return types.contains(PsiUtilCore.getElementType((PsiElement)element));
    }

    @Nullable
    public static PsiElement findFullPhpTagAtOffset(@Nullable PsiFile file, int offset) {
        if (offset > 0 && file != null) {
            PsiElement openTagAt = file.findElementAt(offset - 1);
            return BasicPhpPsiUtil.isOfType(openTagAt, PhpTokenTypes.PHP_OPENING_TAG) && openTagAt.getTextLength() == 5 ? openTagAt : null;
        }
        return null;
    }

    @Deprecated
    @Contract(value="null, _ -> null", pure=true)
    @ApiStatus.Internal
    @Nullable
    public static <T extends PsiElement> T getParentByCondition(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(7);
        }
        return BasicPhpPsiUtil.getParentByCondition(element, condition, null);
    }

    @Contract(value="null, _, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getParentByCondition(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition, @Nullable Condition<? super PsiElement> stopAt) {
        if (condition == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(8);
        }
        for (PsiElement curElement = element; curElement != null; curElement = curElement.getParent()) {
            if (stopAt != null && stopAt.value((Object)curElement)) {
                return null;
            }
            if (condition.value((Object)curElement)) {
                return (T)curElement;
            }
            if (!(curElement instanceof PsiFile)) continue;
            return null;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static <T extends PsiElement> T getNextSiblingByCondition(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(9);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement nextSibling = element.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (!condition.value((Object)nextSibling)) continue;
            return (T)nextSibling;
        }
        return null;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static PsiElement getPrevSiblingIgnoreWhitespace(@Nullable PsiElement element, boolean strict) {
        if (element == null) {
            return null;
        }
        PsiElement prevSibling = strict ? element.getPrevSibling() : element;
        while (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        return prevSibling;
    }

    public static boolean isArgumentUnpacking(@Nullable PsiElement argument) {
        return argument != null && BasicPhpPsiUtil.isOfType(argument.getPrevSibling(), PhpTokenTypes.opVARIADIC);
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getNextSiblingIgnoreWhitespace(@Nullable PsiElement element, boolean strict) {
        if (element == null) {
            return null;
        }
        PsiElement nextSibling = strict ? element.getNextSibling() : element;
        while (nextSibling instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        return (T)nextSibling;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getChildOfType(@Nullable PsiElement element, @NotNull IElementType type) {
        ASTNode childNode;
        if (type == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(10);
        }
        if (element == null) {
            return null;
        }
        ASTNode elementNode = element.getNode();
        if (elementNode != null && (childNode = elementNode.findChildByType(type)) != null) {
            return childNode.getPsi();
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getChildOfType(@Nullable PsiElement element, @NotNull TokenSet type) {
        ASTNode childNode;
        if (type == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(11);
        }
        if (element == null) {
            return null;
        }
        ASTNode elementNode = element.getNode();
        if (elementNode != null && (childNode = elementNode.findChildByType(type)) != null) {
            return childNode.getPsi();
        }
        return null;
    }

    @Contract(value="null, _, _, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getParentByCondition(@Nullable PsiElement element, boolean strict, @NotNull Condition<? super PsiElement> condition, @Nullable Condition<? super PsiElement> stopAt) {
        if (condition == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(12);
        }
        PsiElement curElement = strict ? PsiTreeUtil.getStubOrPsiParent((PsiElement)element) : element;
        while (curElement != null) {
            if (stopAt != null && stopAt.value((Object)curElement)) {
                return null;
            }
            if (condition.value((Object)curElement)) {
                return (T)curElement;
            }
            if (curElement instanceof PsiFile) {
                return null;
            }
            curElement = PsiTreeUtil.getStubOrPsiParent((PsiElement)curElement);
        }
        return null;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getParentOfClass(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(13);
        }
        return BasicPhpPsiUtil.getParentOfClass(element, true, aClass);
    }

    @Contract(value="null, _, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getParentOfClass(@Nullable PsiElement element, boolean strict, @NotNull Class<T> aClass) {
        if (aClass == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(14);
        }
        Condition stopAt = PhpExpression.class.isAssignableFrom(aClass) ? Statement.class::isInstance : null;
        return BasicPhpPsiUtil.getParentByCondition(element, strict, (Condition<? super PsiElement>)((Condition)aClass::isInstance), (Condition<? super PsiElement>)stopAt);
    }

    @Contract(pure=true)
    @Nullable
    public static <T extends PsiElement> T getPrevSiblingByCondition(@NotNull PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        if (element == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(15);
        }
        if (condition == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(16);
        }
        for (PsiElement prevSibling = element.getPrevSibling(); prevSibling != null; prevSibling = prevSibling.getPrevSibling()) {
            if (!condition.value((Object)prevSibling)) continue;
            return (T)prevSibling;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement findNextSiblingOfAnyType(@NotNull PsiElement element, IElementType ... types) {
        ASTNode elementNode;
        if (element == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(17);
        }
        if (types == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(18);
        }
        if ((elementNode = element.getNode()) == null) {
            return null;
        }
        for (ASTNode curNext = elementNode.getTreeNext(); curNext != null; curNext = curNext.getTreeNext()) {
            IElementType curType = curNext.getElementType();
            for (IElementType type : types) {
                if (!curType.equals(type)) continue;
                return curNext.getPsi();
            }
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement findPrevSiblingOfAnyType(@Nullable PsiElement element, IElementType ... types) {
        ASTNode elementNode;
        ASTNode aSTNode = elementNode = element != null ? element.getNode() : null;
        if (elementNode == null) {
            return null;
        }
        for (ASTNode curPrev = elementNode.getTreePrev(); curPrev != null; curPrev = curPrev.getTreePrev()) {
            IElementType curType = curPrev.getElementType();
            for (IElementType type : types) {
                if (!curType.equals(type)) continue;
                return curPrev.getPsi();
            }
        }
        return null;
    }

    @Contract(pure=true)
    public static PhpPsiElement @NotNull [] getPhpPsiElementsInRange(@NotNull PsiElement beginRange, @NotNull PsiElement endRange) {
        if (beginRange == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(19);
        }
        if (endRange == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(20);
        }
        ArrayList<PhpPsiElement> elements = new ArrayList<PhpPsiElement>();
        if (beginRange == endRange) {
            if (PhpPsiElement.EMPTY_ARRAY == null) {
                BasicPhpPsiUtil.$$$reportNull$$$0(21);
            }
            return PhpPsiElement.EMPTY_ARRAY;
        }
        for (PsiElement curChild = beginRange.getNextSibling(); curChild != null && curChild != endRange; curChild = curChild.getNextSibling()) {
            if (!(curChild instanceof PhpPsiElement)) continue;
            elements.add((PhpPsiElement)curChild);
        }
        if (elements.isEmpty()) {
            if (PhpPsiElement.EMPTY_ARRAY == null) {
                BasicPhpPsiUtil.$$$reportNull$$$0(22);
            }
            return PhpPsiElement.EMPTY_ARRAY;
        }
        PhpPsiElement[] phpPsiElementArray = elements.toArray(PhpPsiElement.EMPTY_ARRAY);
        if (phpPsiElementArray == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(23);
        }
        return phpPsiElementArray;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getChildByCondition(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(24);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child.getNode() instanceof CompositeElement) || !condition.value((Object)child)) continue;
            return (T)child;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getChildOfType(@NotNull PsiElement element, @NotNull IElementType type, @NotNull PsiElement anchor) {
        ASTNode childNode;
        if (element == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(25);
        }
        if (type == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(26);
        }
        if (anchor == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(27);
        }
        ASTNode elementNode = element.getNode();
        ASTNode anchorNode = anchor.getNode();
        if (anchorNode == null) {
            return null;
        }
        anchorNode = anchorNode.getTreeNext();
        if (elementNode != null && anchorNode != null && (childNode = elementNode.findChildByType(TokenSet.create((IElementType[])new IElementType[]{type}), anchorNode)) != null) {
            return childNode.getPsi();
        }
        return null;
    }

    @Deprecated
    @Contract(value="null, _, _ -> null", pure=true)
    @ApiStatus.Internal
    @Nullable
    public static <T extends PsiElement> T getParentByCondition(@Nullable PsiElement element, boolean strict, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(28);
        }
        return BasicPhpPsiUtil.getParentByCondition(element, strict, condition, null);
    }

    @Contract(pure=true)
    @NotNull
    public static <T extends PsiElement> List<T> getChildren(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition, @NotNull Condition<? super PsiElement> stopAt) {
        if (condition == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(29);
        }
        if (stopAt == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(30);
        }
        if (element == null) {
            List list = Collections.emptyList();
            if (list == null) {
                BasicPhpPsiUtil.$$$reportNull$$$0(31);
            }
            return list;
        }
        SmartList result = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNode() instanceof CompositeElement && condition.value((Object)child)) {
                if (result == null) {
                    result = new SmartList();
                }
                result.add(child);
                continue;
            }
            if (stopAt.value((Object)child)) break;
        }
        SmartList smartList = result != null ? result : Collections.emptyList();
        if (smartList == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(32);
        }
        return smartList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T extends PsiElement> List<T> getChildren(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(33);
        }
        return BasicPhpPsiUtil.getChildren(element, condition, (Condition<? super PsiElement>)((Condition)e -> false));
    }

    @Contract(pure=true)
    @Nullable
    public static PhpDocComment getDocCommentFor(@NotNull PhpPsiElement element) {
        if (element == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(34);
        }
        return BasicPhpPsiUtil.getDocCommentFor(element, e -> e);
    }

    @Contract(pure=true)
    @Nullable
    public static PhpDocComment getDocCommentFor(@NotNull PhpPsiElement element, Function<? super PhpPsiElement, ? extends PhpPsiElement> docHolderExtractor) {
        PhpAttributesOwner attributesOwner;
        if (element == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(35);
        }
        if (element instanceof PsiFile) {
            return null;
        }
        PhpPsiElement docHolder = docHolderExtractor.apply(element);
        PhpDocComment comment = BasicPhpPsiUtil.getPrevPsiSibling((PsiElement)docHolder);
        if (comment != null) {
            return comment;
        }
        if (docHolder instanceof PhpAttributesOwner && !(attributesOwner = (PhpAttributesOwner)docHolder).getAttributes().isEmpty()) {
            return (PhpDocComment)ObjectUtils.tryCast(BasicPhpPsiUtil.getNextSiblingByCondition(attributesOwner.getFirstChild(), (Condition<? super PsiElement>)((Condition)e -> e instanceof PsiWhiteSpace || e instanceof PhpAttributesList)), PhpDocComment.class);
        }
        return null;
    }

    @Nullable
    private static PhpDocComment getPrevPsiSibling(@Nullable PsiElement searchFrom) {
        if (searchFrom == null) {
            return null;
        }
        PhpPsiElement prevPsiSibling = BasicPhpPsiUtil.findPrevPhpPsiElement(searchFrom.getPrevSibling());
        while (prevPsiSibling instanceof PhpAttributesList) {
            prevPsiSibling = prevPsiSibling.getPrevPsiSibling();
        }
        return (PhpDocComment)ObjectUtils.tryCast((Object)prevPsiSibling, PhpDocComment.class);
    }

    @Contract(pure=true)
    @NotNull
    public static List<PsiElement> getChildrenOfType(@Nullable PsiElement element, @NotNull TokenSet set) {
        if (set == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(36);
        }
        if (element == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                BasicPhpPsiUtil.$$$reportNull$$$0(37);
            }
            return list;
        }
        ArrayList<PsiElement> res = new ArrayList<PsiElement>();
        ASTNode elementNode = element.getNode();
        if (elementNode == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                BasicPhpPsiUtil.$$$reportNull$$$0(38);
            }
            return list;
        }
        for (ASTNode child = elementNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PsiElement psi;
            if (!set.contains(child.getElementType()) || (psi = child.getPsi()) == null) continue;
            res.add(psi);
        }
        ArrayList<PsiElement> arrayList = res;
        if (arrayList == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    @Nullable
    public static PhpPsiElement findNextPhpPsiElement(PsiElement element) {
        while (element != null) {
            if (element.getNode() instanceof CompositeElement) {
                return element instanceof PhpPsiElement ? (PhpPsiElement)element : null;
            }
            element = element.getNextSibling();
        }
        return null;
    }

    public static PsiElement @NotNull [] getChildren(@NotNull PsiElement element) {
        PsiElement psiChild;
        if (element == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(40);
        }
        if ((psiChild = element.getFirstChild()) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                BasicPhpPsiUtil.$$$reportNull$$$0(41);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        while (psiChild != null) {
            if (psiChild.getNode() instanceof CompositeElement) {
                result.add(psiChild);
            }
            psiChild = psiChild.getNextSibling();
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
        if (psiElementArray == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(42);
        }
        return psiElementArray;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getChildOfClass(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(43);
        }
        return BasicPhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)((Condition)aClass::isInstance));
    }

    @SafeVarargs
    @Contract(pure=true)
    @Nullable
    public static PsiElement getPrevSibling(@Nullable PsiElement element, Condition<PsiElement> ... ignored) {
        PsiElement prevSibling;
        if (ignored == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(44);
        }
        if (element == null) {
            return null;
        }
        for (prevSibling = element.getPrevSibling(); prevSibling != null && BasicPhpPsiUtil.appliesAtLeastOne(prevSibling, ignored); prevSibling = prevSibling.getPrevSibling()) {
        }
        return prevSibling;
    }

    @Contract(pure=true)
    public static boolean appliesAtLeastOne(@NotNull PsiElement child, Condition<PsiElement> ... conditions) {
        if (child == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(45);
        }
        if (conditions == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(46);
        }
        for (Condition<PsiElement> condition : conditions) {
            if (!condition.value((Object)child)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReadonlyKeyword(ASTNode node) {
        if (BasicPhpPsiUtil.isOfType(node, PhpTokenTypes.IDENTIFIER) && "readonly".equals(node.getText())) {
            PsiElement psi = node.getPsi();
            return psi != null && !(psi.getParent() instanceof ParameterList);
        }
        return false;
    }

    @Nullable
    public static PsiElement getNameIdentifier(@Nullable PsiElement argument) {
        if (argument == null) {
            return null;
        }
        PsiElement colon = BasicPhpPsiUtil.getPrevSibling(argument, SKIP_INSIDE_NAMED_ARGUMENT_PART);
        if (!BasicPhpPsiUtil.isOfType(colon, PhpTokenTypes.opCOLON)) {
            return null;
        }
        PsiElement identifier = BasicPhpPsiUtil.getPrevSibling(colon, SKIP_INSIDE_NAMED_ARGUMENT_PART);
        return BasicPhpPsiUtil.isOfType(identifier, PhpTokenTypes.IDENTIFIER) ? identifier : null;
    }

    public static boolean isSetOperationModifier(ASTNode node) {
        ASTNode sibling;
        if (!BasicPhpPsiUtil.isOfType(node, PhpTokenTypes.tsVISIBILITY_MODIFIERS)) {
            return false;
        }
        for (sibling = node.getTreeNext(); sibling != null && (sibling instanceof PsiWhiteSpace || BasicPhpPsiUtil.isOfType(sibling, PhpTokenTypes.chRPAREN, PhpTokenTypes.chLPAREN)); sibling = sibling.getTreeNext()) {
        }
        return sibling != null && sibling.getElementType() == PhpTokenTypes.kwSET;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getParentByElementTypeCondition(@Nullable PsiElement element, IElementType elementType) {
        for (PsiElement curElement = element; curElement != null; curElement = curElement.getParent()) {
            if (BasicPhpPsiUtil.isOfType(curElement, elementType)) {
                return (T)curElement;
            }
            if (!(curElement instanceof PsiFile)) continue;
            return null;
        }
        return null;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getParentByElementTypeCondition(@Nullable PsiElement element, TokenSet elementType) {
        for (PsiElement curElement = element; curElement != null; curElement = curElement.getParent()) {
            if (BasicPhpPsiUtil.isOfType(curElement, elementType)) {
                return (T)curElement;
            }
            if (!(curElement instanceof PsiFile)) continue;
            return null;
        }
        return null;
    }

    @Contract(value="null, _, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getParentByElementTypeCondition(@Nullable PsiElement element, IElementType elementType, IElementType stopAt) {
        for (PsiElement curElement = element; curElement != null; curElement = curElement.getParent()) {
            if (stopAt != null && BasicPhpPsiUtil.isOfType(curElement, stopAt)) {
                return null;
            }
            if (BasicPhpPsiUtil.isOfType(curElement, elementType)) {
                return (T)curElement;
            }
            if (!(curElement instanceof PsiFile)) continue;
            return null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 22, 23, 31, 32, 37, 38, 39, 41, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 24: 
            case 28: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 13: 
            case 14: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 15: 
            case 17: 
            case 25: 
            case 34: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beginRange";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endRange";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/BasicPhpPsiUtil";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/BasicPhpPsiUtil";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpPsiElementsInRange";
                break;
            }
            case 31: 
            case 32: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isOfType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLastChildByType";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getParentByCondition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNextSiblingByCondition";
                break;
            }
            case 10: 
            case 11: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getChildOfType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfClass";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSiblingByCondition";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findNextSiblingOfAnyType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPhpPsiElementsInRange";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getChildByCondition";
                break;
            }
            case 29: 
            case 30: 
            case 33: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentFor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getChildOfClass";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSibling";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "appliesAtLeastOne";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21, 22, 23, 31, 32, 37, 38, 39, 41, 42 -> new IllegalStateException(string);
        };
    }
}

