/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFlexibleHeredocHelper {
    @NotNull
    public static String getEndTagIndent(@NotNull StringLiteralExpression heredoc) {
        TextRange rangeInClosingTag;
        if (heredoc == null) {
            PhpFlexibleHeredocHelper.$$$reportNull$$$0(0);
        }
        if ((rangeInClosingTag = PhpFlexibleHeredocHelper.getEndTagIndentRangeInClosingTag(heredoc)) == null) {
            return "";
        }
        String string = rangeInClosingTag.substring(heredoc.getLastChild().getText());
        if (string == null) {
            PhpFlexibleHeredocHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static @Nullable Pair<TextRange, @Nls String> validateHeredocIndentation(@NotNull StringLiteralExpression heredoc) {
        TextRange endTagIndentRangeInClosingTag;
        if (heredoc == null) {
            PhpFlexibleHeredocHelper.$$$reportNull$$$0(2);
        }
        if ((endTagIndentRangeInClosingTag = PhpFlexibleHeredocHelper.getEndTagIndentRangeInClosingTag(heredoc)) != null) {
            String endTagIndentString = PhpFlexibleHeredocHelper.getEndTagIndent(heredoc);
            String endTagIndentionError = PhpFlexibleHeredocHelper.validateEndTagIndent(endTagIndentString);
            String heredocText = heredoc.getText();
            String[] lines = heredocText.split("\n");
            if (endTagIndentionError != null) {
                return new Pair((Object)PhpFlexibleHeredocHelper.getIndentRangeInHeredoc(heredoc, heredocText, lines.length - 1), (Object)endTagIndentionError);
            }
            for (int i = 1; i < lines.length; ++i) {
                if (lines[i].isEmpty() || lines[i].startsWith(endTagIndentString)) continue;
                return new Pair((Object)PhpFlexibleHeredocHelper.getIndentRangeInHeredoc(heredoc, heredocText, i), (Object)PhpFrontBackBundle.message("php.annotator.heredoc.indent.validation.wrong.content.indent", new Object[0]));
            }
        }
        return null;
    }

    @Nullable
    private static TextRange getEndTagIndentRangeInClosingTag(@NotNull StringLiteralExpression heredoc) {
        int index;
        if (heredoc == null) {
            PhpFlexibleHeredocHelper.$$$reportNull$$$0(3);
        }
        assert (heredoc.isHeredoc());
        PsiElement heredocClosingTag = heredoc.getLastChild();
        String name = heredoc.getName();
        if (name != null && (index = heredocClosingTag.getText().indexOf(name)) >= 1) {
            return new TextRange(1, index);
        }
        return null;
    }

    @NotNull
    private static TextRange getIndentRangeInHeredoc(StringLiteralExpression heredoc, String heredocText, int indentNumber) {
        int indexOf = 0;
        for (int i = indentNumber; i > 0; --i) {
            indexOf = heredocText.indexOf("\n", indexOf + 1);
        }
        int endIndex = heredocText.indexOf("\n", indexOf + 1);
        endIndex = endIndex == -1 ? heredoc.getTextRange().shiftLeft(heredoc.getTextRange().getStartOffset()).getEndOffset() : endIndex;
        return new TextRange(indexOf, endIndex);
    }

    @Nullable
    @Nls
    public static String validateEndTagIndent(@Nullable String endTagIndent) {
        if (endTagIndent == null || endTagIndent.isEmpty()) {
            return null;
        }
        char spaceType = endTagIndent.charAt(0);
        for (char it : endTagIndent.toCharArray()) {
            if (it == spaceType) continue;
            return PhpFrontBackBundle.message("php.annotator.heredoc.indent.validation.mixed.space.and.tab.characters", new Object[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heredoc";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/util/PhpFlexibleHeredocHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/util/PhpFlexibleHeredocHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndTagIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEndTagIndent";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validateHeredocIndentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEndTagIndentRangeInClosingTag";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

