/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import ai.grazie.gec.model.problem.Problem;
import ai.grazie.gec.model.problem.ProblemFix;
import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Example;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.NodeRuleMatch;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.RuleMatch;
import ai.grazie.rules.document.Delimiter;
import ai.grazie.rules.document.DocumentRule;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.settings.RuleSetting;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.settings.TextStyle;
import ai.grazie.rules.toolkit.LanguageToolkit;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.Parameter;
import ai.grazie.rules.tree.Tree;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.inspection.auto.AutoFix;
import com.intellij.grazie.ide.inspection.rephrase.RephraseAction;
import com.intellij.grazie.ide.ui.configurable.StyleConfigurable;
import com.intellij.grazie.rule.ParsedSentence;
import com.intellij.grazie.rule.RuleIdeClient;
import com.intellij.grazie.rule.SentenceBatcher;
import com.intellij.grazie.rule.SentenceTokenizer;
import com.intellij.grazie.style.ConfigureSuggestedParameter;
import com.intellij.grazie.style.TextLevelFix;
import com.intellij.grazie.text.ChangeLanguageVariant;
import com.intellij.grazie.text.GrazieProblem;
import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.HighlightingUtil;
import com.intellij.grazie.utils.Text;
import com.intellij.grazie.utils.TextStyleDomain;
import com.intellij.grazie.utils.TextUtilsKt;
import com.intellij.grazie.utils.UtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringOperation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeRuleChecker {
    private static final Logger LOG = Logger.getInstance(TreeRuleChecker.class);
    public static final String EN_STYLE_CATEGORY = "Style";
    private static final Map<String, String> punctuationCategories = Map.of("en", "Punctuation", "ru", "\u041f\u0443\u043d\u043a\u0442\u0443\u0430\u0446\u0438\u044f", "uk", "\u041f\u0443\u043d\u043a\u0442\u0443\u0430\u0446\u0456\u044f", "de", "Interpunktion");
    private static final Map<String, String> grammarCategories = Map.of("en", "Grammar", "ru", "\u0413\u0440\u0430\u043c\u043c\u0430\u0442\u0438\u043a\u0430", "uk", "\u0413\u0440\u0430\u043c\u0430\u0442\u0438\u043a\u0430", "de", "Grammatik");
    private static final Map<String, String> styleCategories = Map.of("en", "Style", "ru", "\u0421\u0442\u0438\u043b\u044c", "uk", "\u0421\u0442\u0438\u043b\u044c", "de", "Stil");
    private static final Map<String, String> semanticCategories = Map.of("en", "Semantics", "ru", "\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438", "uk", "\u041b\u043e\u0433\u0456\u0447\u043d\u0456 \u043f\u043e\u043c\u0438\u043b\u043a\u0438", "de", "Semantische Unstimmigkeiten");
    private static final Map<String, String> typographyCategories = Map.of("en", "Typography", "ru", "\u0422\u0438\u043f\u043e\u0433\u0440\u0430\u0444\u0438\u043a\u0430", "uk", "\u0422\u0438\u043f\u043e\u0433\u0440\u0430\u0444\u0456\u044f", "de", "Typografie");
    private static final Map<String, String> spellingCategories = Map.of("en", "Possible Typo", "ru", "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0438\u0438", "uk", "\u041e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0456\u044f", "de", "M\u00f6gliche Tippfehler");
    @ApiStatus.Internal
    public static final String SMART_APOSTROPHE = "Grazie.RuleEngine.En.Typography.SMART_APOSTROPHE";

    public static List<Rule> getRules(Language language) {
        if (!StyleConfigurable.getRuleEngineLanguages().contains(language) || SentenceBatcher.findInstalledLTLanguage(language) == null) {
            return List.of();
        }
        LanguageToolkit toolkit = LanguageToolkit.forLanguage((Language)language);
        return ContainerUtil.map((Collection)toolkit.publishedRules(), rule -> TreeRuleChecker.toGrazieRule(rule));
    }

    public static Rule toGrazieRule(final ai.grazie.rules.Rule rule) {
        final String langCode = rule.language().getIso().toString();
        String category = rule.id.startsWith("Style.") ? styleCategories.get(langCode) : (rule.id.startsWith("Typography.") ? typographyCategories.get(langCode) : (rule.id.startsWith("Punctuation.") ? punctuationCategories.get(langCode) : (rule.id.startsWith("Semantics.") ? semanticCategories.get(langCode) : (rule.id.startsWith("Spelling.") ? spellingCategories.get(langCode) : grammarCategories.get(langCode)))));
        String id = rule.globalId();
        final List<String> categories = rule.isStyleLike() ? List.of(styleCategories.get(langCode)) : List.of(category);
        return new Rule(id, rule.language(), rule.displayName, categories.getFirst()){

            @Override
            public List<String> getCategories() {
                return categories;
            }

            @Override
            @NotNull
            public String getDescription() {
                List examples = rule.getExamples((RuleClient)RuleIdeClient.INSTANCE);
                String result = rule.getDescription((RuleClient)RuleIdeClient.INSTANCE) + "<br><br>";
                if (!examples.isEmpty()) {
                    result = result + "<p style='padding-bottom:5px;'>" + GrazieBundle.message("grazie.settings.grammar.rule.examples", new Object[0]) + "</p><table style='width:100%;' cellspacing=0 cellpadding=0>\n";
                    for (Example example : examples) {
                        String corrections = StreamEx.of((Collection)example.correctedTexts()).map(s -> s + "<br>").joining();
                        result = result + TreeRuleChecker.renderExampleRow(example, corrections);
                    }
                    result = result + "</table><br/>";
                }
                if (!"en".equals(langCode)) {
                    result = result + GrazieBundle.message("grazie.settings.grammar.cloud.only.rule", new Object[0]) + "<br><br>";
                }
                String string = result;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean isEnabledByDefault(TextStyleDomain domain) {
                return rule.isRuleEnabledByDefault(GrazieConfig.Companion.get().getTextStyle(domain), (RuleClient)RuleIdeClient.INSTANCE);
            }

            @Override
            public Setting getFeaturedSetting() {
                return new RuleSetting(rule, new Parameter[0]);
            }

            @Override
            @Nullable
            public URL getUrl() {
                return rule.url;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/grazie/text/TreeRuleChecker$1", "getDescription"));
            }
        };
    }

    private static String renderExampleRow(Example example, String corrections) {
        String result = "<tr><td valign='top' style='padding-bottom: 5px; padding-right: 5px; color: gray;'>" + GrazieBundle.message("grazie.settings.grammar.rule.incorrect", new Object[0]) + "&nbsp;</td><td style='padding-bottom: 5px; width: 100%'>" + GrazieProblem.visualizeSpace(example.errorText()) + "</td></tr>";
        if (!corrections.isEmpty()) {
            return result + "<tr><td valign='top' style='padding-bottom: 10px; padding-right: 5px; color: gray;'>" + GrazieBundle.message("grazie.settings.grammar.rule.correct", new Object[0]) + "</td><td style='padding-bottom: 10px; width: 100%;'>" + GrazieProblem.visualizeSpace(corrections) + "</td></tr>";
        }
        return result;
    }

    private static List<MatchingResult> doCheck(TextContent text, List<ParsedSentence> sentences2) {
        if (sentences2.isEmpty()) {
            return List.of();
        }
        AtomicReference ref = (AtomicReference)CachedValuesManager.getManager((Project)text.getContainingFile().getProject()).getCachedValue((UserDataHolder)text, () -> CachedValueProvider.Result.create(new AtomicReference(), (Object[])new Object[]{HighlightingUtil.grazieConfigTracker()}));
        try {
            record Cached(List<ParsedSentence> sentences, List<MatchingResult> matches) {
            }
            Cached cached = (Cached)ref.get();
            if (cached == null || !cached.sentences.equals(sentences2)) {
                Tree.ParameterValues parameters = TreeRuleChecker.calcParameters(sentences2);
                List trees2 = ContainerUtil.map(sentences2, s -> s.tree.withParameters(parameters));
                List<ai.grazie.rules.Rule> rules = TreeRuleChecker.enabledRules((Tree)trees2.getFirst(), text);
                List<MatchingResult> matches = TreeRuleChecker.matchTrees(trees2, rules);
                cached = new Cached(sentences2, matches);
                ref.set(cached);
            }
            return cached.matches;
        }
        catch (Throwable e) {
            Throwable cause = ExceptionUtil.getRootCause((Throwable)e);
            if (cause instanceof ProcessCanceledException) {
                ProcessCanceledException pce = (ProcessCanceledException)cause;
                throw pce;
            }
            throw e;
        }
    }

    private static List<ai.grazie.rules.Rule> enabledRules(Tree sampleTree, TextContent content) {
        Language language = sampleTree.treeSupport().getGrazieLanguage();
        LanguageToolkit toolkit = LanguageToolkit.forLanguage((Language)language);
        boolean flat = sampleTree.isFlat();
        return ContainerUtil.filter((Collection)toolkit.publishedRules(), r -> (!flat || r.supportsFlatTrees()) && TreeRuleChecker.toGrazieRule(r).isCurrentlyEnabled(content));
    }

    private static List<MatchingResult> matchTrees(List<Tree> trees2, List<ai.grazie.rules.Rule> rules) {
        return ContainerUtil.map(trees2, tree -> {
            ArrayList<MatchingResult> mrs = new ArrayList<MatchingResult>(rules.size());
            for (ai.grazie.rules.Rule rule : rules) {
                ProgressManager.checkCanceled();
                mrs.add(rule.match(List.of(tree)));
            }
            return MatchingResult.concat(mrs);
        });
    }

    private static Tree.ParameterValues calcParameters(List<ParsedSentence> sentences2) {
        String[] countries;
        HashMap<String, String> parameters = new HashMap<String, String>();
        org.languagetool.Language ltLanguage = sentences2.getFirst().tree.language();
        Language language = sentences2.getFirst().tree.treeSupport().getGrazieLanguage();
        TextContent content = sentences2.getFirst().extractedText;
        LanguageToolkit toolkit = LanguageToolkit.forLanguage((Language)language);
        toolkit.allParameters((RuleClient)RuleIdeClient.INSTANCE).forEach(p -> parameters.put(p.id(), TreeRuleChecker.getParamValue(p, language, content)));
        if ((language == Language.ENGLISH || language == Language.GERMAN) && (countries = ltLanguage.getCountries()).length > 0) {
            String variant = countries[0];
            if (language == Language.ENGLISH && variant.equals("GB") && GrazieConfig.Companion.get().getUseOxfordSpelling()) {
                variant = "GB-oxendict";
            }
            parameters.put("variant", variant);
        }
        return new Tree.ParameterValues(parameters);
    }

    @Nullable
    private static String getParamValue(Parameter param, Language language, TextContent content) {
        TextStyleDomain domain = TextUtilsKt.getTextDomain(content);
        String value = GrazieConfig.Companion.get().paramValue(domain, language, param);
        if (value == null || !ContainerUtil.exists((Iterable)param.possibleValues((RuleClient)RuleIdeClient.INSTANCE), v -> value.equals(v.id()))) {
            TextStyle textStyle = TextStyle.styles((RuleClient)RuleIdeClient.INSTANCE).stream().filter(it -> it.id().equals(domain.name())).findFirst().orElseGet(() -> GrazieConfig.Companion.get().getTextStyle());
            return param.defaultValue(textStyle, (RuleClient)RuleIdeClient.INSTANCE).id();
        }
        return value;
    }

    public static List<TreeProblem> checkTextLevelProblems(PsiFile file) {
        List<SentenceWithContent> doc = TreeRuleChecker.obtainDocument(file);
        if (doc.isEmpty()) {
            return List.of();
        }
        List<TreeProblem> result = TreeRuleChecker.documentProblems(file, doc);
        List ignored = ContainerUtil.findAll(result, p -> TreeRuleChecker.findIgnoringFilter(p) != null);
        if (ignored.isEmpty()) {
            return result;
        }
        Set docIgnoredRanges = ContainerUtil.map2Set((Collection)ignored, p -> ai.grazie.rules.tree.TextRange.spanRanges(p.match.reportedRanges().stream()));
        List<TreeProblem> secondPassResult = TreeRuleChecker.documentProblems(file, ContainerUtil.map(doc, swc -> new SentenceWithContent(swc.sentence.withSuppressions(TreeRuleChecker.union(swc.sentence.suppressions, TreeRuleChecker.sentenceRanges(docIgnoredRanges, (DocumentSentence)swc.sentence, swc.docSentenceOffset))), swc.content, swc.contentStart, swc.docSentenceOffset)));
        return ContainerUtil.findAll(secondPassResult, p -> TreeRuleChecker.findIgnoringFilter(p) == null);
    }

    private static Set<ai.grazie.rules.tree.TextRange> union(Set<ai.grazie.rules.tree.TextRange> firstSet, Set<ai.grazie.rules.tree.TextRange> secondSet) {
        LinkedHashSet<ai.grazie.rules.tree.TextRange> union = new LinkedHashSet<ai.grazie.rules.tree.TextRange>(firstSet);
        union.addAll(secondSet);
        return union;
    }

    private static Set<ai.grazie.rules.tree.TextRange> sentenceRanges(Set<ai.grazie.rules.tree.TextRange> docRanges, DocumentSentence sentence, int sentenceOffset) {
        TextRange sentenceRange = TextRange.from((int)sentenceOffset, (int)sentence.text.length());
        return ((StreamEx)StreamEx.of(docRanges).filter(r -> sentenceRange.containsRange(r.start(), r.end()))).map(r -> r.shiftLeft(sentenceRange.getStartOffset())).toSet();
    }

    private static List<TreeProblem> documentProblems(PsiFile file, List<SentenceWithContent> doc) {
        String docText = StreamEx.of(doc).map(swc -> swc.sentence.text).joining();
        ArrayList<TreeProblem> result = new ArrayList<TreeProblem>();
        MatchingResult mr = TreeRuleChecker.checkDocument(doc);
        for (RuleMatch match : mr.matches) {
            List reportedRanges = match.reportedRanges();
            ai.grazie.rules.tree.TextRange firstRange = (ai.grazie.rules.tree.TextRange)reportedRanges.getFirst();
            SentenceWithContent sentence = TreeRuleChecker.findSentence(doc, firstRange.start(), firstRange.end());
            TextContent content = sentence.content;
            List<ProblemFix> fixes = TreeRuleChecker.asciiAwareFixes(match, content, docText);
            if (fixes == null) continue;
            Problem source = GrazieProblem.copyWithFixes(match.toProblem((RuleClient)RuleIdeClient.INSTANCE), List.of());
            TreeProblem problem = new TreeProblem(source.withOffset(-sentence.contentStart), match, content);
            result.add(problem.withCustomFixes(ContainerUtil.map(fixes, fix -> new TextLevelFix((PsiElement)file, GrazieProblem.getQuickFixText(fix), TreeRuleChecker.fileLevelChanges(fix, doc)))));
        }
        return result;
    }

    private static List<StringOperation> fileLevelChanges(ProblemFix fix, List<SentenceWithContent> doc) {
        return Arrays.stream(fix.getChanges()).map(c -> {
            SentenceWithContent sentence = TreeRuleChecker.findSentence(doc, c.getRange().getStart(), c.getRange().getEndExclusive());
            return StringOperation.replace((TextRange)sentence.content.textRangeToFile(UtilsKt.ijRange(c).shiftLeft(sentence.contentStart)), (CharSequence)c.getText());
        }).toList();
    }

    private static SentenceWithContent findSentence(List<SentenceWithContent> doc, int docStart, int docEnd) {
        ProgressManager.checkCanceled();
        SentenceWithContent sentence = (SentenceWithContent)ContainerUtil.find(doc, s -> s.docSentenceOffset <= docStart && docEnd <= s.docSentenceOffset + s.sentence.text.length());
        assert (sentence != null);
        return sentence;
    }

    private static MatchingResult checkDocument(List<SentenceWithContent> doc) {
        LinkedHashMap<Language, List<ai.grazie.rules.Rule>> rules = new LinkedHashMap<Language, List<ai.grazie.rules.Rule>>();
        for (SentenceWithContent ds : doc) {
            Language language = ds.sentence.language;
            if (rules.containsKey(language) || !StyleConfigurable.getRuleEngineLanguages().contains(language)) continue;
            rules.put(language, TreeRuleChecker.enabledRules(ds.sentence.treeOrThrow(), ds.content));
        }
        return MatchingResult.concat((StreamEx)((StreamEx)StreamEx.of(rules.values()).flatCollection(Function.identity()).filter(ai.grazie.rules.Rule::isStyleLike)).select(DocumentRule.class).map(r -> {
            ProgressManager.checkCanceled();
            return r.checkDocument(ContainerUtil.map((Collection)doc, SentenceWithContent::sentence));
        }));
    }

    private static Map<String, Set<ai.grazie.rules.tree.TextRange>> suppressedRanges() {
        HashMap<String, Set<ai.grazie.rules.tree.TextRange>> result = new HashMap<String, Set<ai.grazie.rules.tree.TextRange>>();
        int counter = 0;
        block0: for (String pattern : GrazieConfig.Companion.get().getSuppressingContext().getSuppressed()) {
            int sep = pattern.indexOf(124);
            if (sep < 2) continue;
            String fragment = pattern.substring(0, sep);
            String sentence = pattern.substring(sep + 1);
            int index = -1;
            while (true) {
                if (counter++ % 1024 == 0) {
                    ProgressManager.checkCanceled();
                }
                if ((index = sentence.indexOf(fragment, index + 1)) < 0) continue block0;
                result.computeIfAbsent(sentence, k -> new HashSet()).add(ai.grazie.rules.tree.TextRange.fromLength((int)index, (int)fragment.length()));
            }
        }
        return result;
    }

    private static List<SentenceWithContent> obtainDocument(PsiFile file) {
        Map<String, Set<ai.grazie.rules.tree.TextRange>> suppressedRanges = TreeRuleChecker.suppressedRanges();
        ArrayList<SentenceWithContent> doc = new ArrayList<SentenceWithContent>();
        int offset = 0;
        for (Map.Entry<TextContent, List<ParsedSentence>> entry : ParsedSentence.getAllCheckedSentences(file.getViewProvider()).entrySet()) {
            TextContent content = entry.getKey();
            List<ParsedSentence> sentences2 = entry.getValue();
            if (sentences2.isEmpty()) continue;
            List<MatchingResult> matches = TreeRuleChecker.doCheck(content, sentences2);
            for (int i = 0; i < sentences2.size(); ++i) {
                ParsedSentence parsed = sentences2.get(i);
                TextRange untrimmedRange = parsed.untrimmedRange;
                String untrimmedText = untrimmedRange.substring(content.toString());
                String trimmed = untrimmedText.trim();
                int trimmedStart = untrimmedText.indexOf(trimmed);
                Set suppressions = ContainerUtil.map2Set((Collection)suppressedRanges.getOrDefault(trimmed, Set.of()), r -> r.shiftRight(trimmedStart));
                DocumentSentence.Analyzed ds = new DocumentSentence(untrimmedText, parsed.tree.treeSupport().getGrazieLanguage()).withIntro(i == 0 ? TreeRuleChecker.getIntro(content) : List.of()).withExclusions(SentenceTokenizer.rangeExclusions(content, untrimmedRange)).withSuppressions(suppressions).withTree(parsed.tree.withStartOffset(offset)).withMetadata(matches.get((int)i).metadata);
                doc.add(new SentenceWithContent(ds, content, offset, offset + untrimmedRange.getStartOffset()));
            }
            offset += content.length();
        }
        return doc;
    }

    private static List<Delimiter> getIntro(TextContent content) {
        ArrayList<Delimiter> intros = new ArrayList<Delimiter>(List.of(Delimiter.fragmentBoundary));
        switch (content.getDomain()) {
            case COMMENTS: {
                intros.add(Delimiter.codeCommentStart);
                break;
            }
            case DOCUMENTATION: {
                intros.add(Delimiter.codeDocumentationStart);
                break;
            }
            case LITERALS: {
                intros.add(Delimiter.stringLiteralStart);
                break;
            }
        }
        return intros;
    }

    private static ProblemFilter findIgnoringFilter(TreeProblem p) {
        return ProblemFilter.allIgnoringFilters(p).findFirst().orElse(null);
    }

    static List<TreeProblem> check(TextContent text, List<ParsedSentence> sentences2) {
        List<MatchingResult> mr = TreeRuleChecker.doCheck(text, sentences2);
        List<TreeProblem> problems = TreeRuleChecker.checkPlainProblems(text, mr);
        AutoFix.consider(text, problems);
        return problems;
    }

    private static List<TreeProblem> checkPlainProblems(TextContent text, List<MatchingResult> matchingResults) {
        ArrayList<TreeProblem> problems = new ArrayList<TreeProblem>();
        for (RuleMatch match : ContainerUtil.flatMap(matchingResults, mr -> mr.matches)) {
            NodeRuleMatch nrm;
            ProgressManager.checkCanceled();
            if (match instanceof NodeRuleMatch && TreeRuleChecker.touchesUnknownFragments(text, (nrm = (NodeRuleMatch)match).result().touchedRange(), match.rule())) continue;
            ContainerUtil.addIfNotNull(problems, (Object)TreeRuleChecker.createProblem(text, match));
        }
        return problems;
    }

    @Nullable
    private static TreeProblem createProblem(TextContent text, RuleMatch match) {
        ai.grazie.rules.Rule rule = match.rule();
        if (TreeRuleChecker.shouldSuppressByPlace(rule, text)) {
            return null;
        }
        List<ProblemFix> fixes = TreeRuleChecker.asciiAwareFixes(match, text, text.toString());
        if (fixes == null) {
            return null;
        }
        if (rule.language() == Language.ENGLISH && rule.id.equals("Typography.VARIANT_QUOTE_PUNCTUATION") && text.getDomain() != TextContent.TextDomain.PLAIN_TEXT && match.reportedRanges().size() == 1 && ((ai.grazie.rules.tree.TextRange)match.reportedRanges().getFirst()).substring(text.toString()).matches(".*['\"]\\p{P}")) {
            return null;
        }
        return new TreeProblem(GrazieProblem.copyWithFixes(match.toProblem((RuleClient)RuleIdeClient.INSTANCE), fixes), match, text);
    }

    @Nullable
    private static List<ProblemFix> asciiAwareFixes(RuleMatch match, TextContent content, String fullText) {
        if (TreeRuleChecker.isAsciiContext(content)) {
            if (match.rule().id.endsWith(".ASCII_APPROXIMATIONS")) {
                return null;
            }
            return match.asciiContextFixes(fullText);
        }
        return match.problemFixes();
    }

    private static boolean isAsciiContext(TextContent text) {
        return text.getDomain() != TextContent.TextDomain.PLAIN_TEXT || text.getContainingFile() instanceof PsiPlainTextFile;
    }

    private static boolean shouldSuppressByPlace(ai.grazie.rules.Rule rule, TextContent text) {
        TextStyleDomain domain = TextUtilsKt.getTextDomain(text);
        if (domain == TextStyleDomain.Other) {
            return false;
        }
        return domain.getTextStyle().disabledRules().contains(rule.globalId());
    }

    private static boolean touchesUnknownFragments(TextContent text, ai.grazie.rules.tree.TextRange range, ai.grazie.rules.Rule rule) {
        TextRange ruleRangeInText = TreeRuleChecker.toIdeaRange(range);
        if (ruleRangeInText.getEndOffset() > text.length()) {
            LOG.error("Invalid match range " + String.valueOf(ruleRangeInText) + " for rule " + String.valueOf(rule) + " in a text of length " + text.length(), new Attachment[]{new Attachment("text.txt", text.toString())});
            return true;
        }
        return text.hasUnknownFragmentsIn(Text.expandToTouchWords(text, ruleRangeInText));
    }

    public static TextRange toIdeaRange(ai.grazie.rules.tree.TextRange reported) {
        return new TextRange(reported.start(), reported.end());
    }

    private record SentenceWithContent(DocumentSentence.Analyzed sentence, TextContent content, int contentStart, int docSentenceOffset) {
    }

    public static class TreeProblem
    extends GrazieProblem {
        public final RuleMatch match;
        private final List<LocalQuickFix> customFixes;
        private final TextStyleDomain domain;

        TreeProblem(Problem problem, RuleMatch match, TextContent text) {
            this(problem, TreeRuleChecker.toGrazieRule(match.rule()), text, match, List.of());
        }

        private TreeProblem(Problem problem, @NotNull Rule ideaRule, @NotNull TextContent text, RuleMatch match, List<LocalQuickFix> customFixes) {
            if (text == null) {
                TreeProblem.$$$reportNull$$$0(0);
            }
            if (ideaRule == null) {
                TreeProblem.$$$reportNull$$$0(1);
            }
            super(problem, ideaRule, text);
            this.match = match;
            this.customFixes = customFixes;
            this.domain = TextUtilsKt.getTextDomain(text);
        }

        @Override
        @InspectionMessage
        @NotNull
        public String getDescriptionTemplate(boolean isOnTheFly) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String string = this.match.rule().globalId();
                if (string == null) {
                    TreeProblem.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = super.getDescriptionTemplate(isOnTheFly);
            if (string == null) {
                TreeProblem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public List<LocalQuickFix> getCustomFixes() {
            List list = ContainerUtil.concat(this.customFixes, (List)ContainerUtil.mapNotNull((Collection)this.match.actions(), sug -> {
                if (sug instanceof ActionSuggestion.ChangeParameter) {
                    ActionSuggestion.ChangeParameter $b$0 = (ActionSuggestion.ChangeParameter)sug;
                    try {
                        String patt3$temp;
                        String patt2$temp;
                        Parameter patt1$temp;
                        Parameter parameter = patt1$temp = $b$0.parameter();
                        String suggestedValue = patt2$temp = $b$0.suggestedValue();
                        String quickFixText = patt3$temp = $b$0.quickFixText();
                        if (!parameter.id().equals("variant")) return new ConfigureSuggestedParameter(parameter, this.domain, this.match.rule().language(), quickFixText);
                        return ChangeLanguageVariant.create(this.match.rule().language(), Objects.requireNonNull(suggestedValue), quickFixText);
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                if (sug != ActionSuggestion.REPHRASE) return null;
                return new RephraseAction();
            }));
            if (list == null) {
                TreeProblem.$$$reportNull$$$0(4);
            }
            return list;
        }

        public TreeProblem withCustomFixes(List<? extends LocalQuickFix> fixes) {
            return new TreeProblem(this.getSource(), this.getRule(), this.getText(), this.match, ContainerUtil.concat(this.customFixes, fixes));
        }

        @Override
        public boolean fitsGroup(@NotNull RuleGroup group) {
            if (group == null) {
                TreeProblem.$$$reportNull$$$0(5);
            }
            Set<String> rules = group.getRules();
            NodeMatch.SuppressableKind kind = this.match.suppressableKind();
            if (rules.contains("INCOMPLETE_SENTENCE") && kind == NodeMatch.SuppressableKind.INCOMPLETE_SENTENCE) {
                return true;
            }
            if (rules.contains("UPPERCASE_SENTENCE_START") && kind == NodeMatch.SuppressableKind.UPPERCASE_SENTENCE_START) {
                return true;
            }
            if (rules.contains("PUNCTUATION_PARAGRAPH_END") && kind == NodeMatch.SuppressableKind.UNFINISHED_SENTENCE) {
                return true;
            }
            if (rules.contains("UNDECORATED_SENTENCE_SEPARATION") && kind == NodeMatch.SuppressableKind.UNDECORATED_SENTENCE_SEPARATION) {
                return true;
            }
            if (rules.contains("UNLIKELY_OPENING_PUNCTUATION") && kind == NodeMatch.SuppressableKind.UNLIKELY_OPENING_PUNCTUATION) {
                return true;
            }
            return super.fitsGroup(group);
        }

        @Override
        public boolean isStyleLike() {
            return this.match.rule().isStyleLike();
        }

        @Override
        public boolean shouldSuppressInCodeLikeFragments() {
            return this.match.rule().shouldSuppressInCodeLikeFragments();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ideaRule";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/grazie/text/TreeRuleChecker$TreeProblem";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/grazie/text/TreeRuleChecker$TreeProblem";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptionTemplate";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCustomFixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "fitsGroup";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class DocProblemFilter
    extends ProblemFilter {
        private static final Pattern PY_DOC_PARAM = Pattern.compile("[a-z0-9_]+\\s*:\\s+\\p{L}+( or \\p{L}+)*");

        @Override
        public boolean shouldIgnore(@NotNull TextProblem problem) {
            TextContent text;
            if (problem == null) {
                DocProblemFilter.$$$reportNull$$$0(0);
            }
            if ((text = problem.getText()).getDomain() == TextContent.TextDomain.DOCUMENTATION) {
                List<TextRange> ranges = problem.getHighlightRanges();
                String psiClass = text.getCommonParent().getClass().getName();
                if (psiClass.equals("com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl")) {
                    Matcher matcher = PY_DOC_PARAM.matcher(text);
                    while (matcher.find()) {
                        if (!ContainerUtil.exists(ranges, r -> r.intersects(matcher.start(), matcher.end()))) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problem", "com/intellij/grazie/text/TreeRuleChecker$DocProblemFilter", "shouldIgnore"));
        }
    }
}

