/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.codeFixes;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSSuppressByCommentFix;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptServiceRelatedAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class TypeScriptSuppressByCommentFix
extends BaseIntentionAction
implements LowPriorityAction,
TypeScriptServiceRelatedAction {
    private final Class<? extends JSSuppressionHolder> myHolderClass;

    public TypeScriptSuppressByCommentFix(Class<? extends JSSuppressionHolder> aClass) {
        this.myHolderClass = aClass;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"intention.family.name.suppress.with.ts.ignore", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptSuppressByCommentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            TypeScriptSuppressByCommentFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            TypeScriptSuppressByCommentFix.$$$reportNull$$$0(2);
        }
        return psiFile instanceof JSFile;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        int offset;
        PsiElement element2;
        if (project == null) {
            TypeScriptSuppressByCommentFix.$$$reportNull$$$0(3);
        }
        if ((element2 = PsiUtilCore.getElementAtOffset((PsiFile)psiFile, (int)(offset = editor.getCaretModel().getOffset()))) instanceof PsiFile) {
            return;
        }
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)element2, this.myHolderClass);
        if (container == null) {
            return;
        }
        JSSuppressByCommentFix.suppressByComment(project, element2, container, "@ts-ignore");
    }

    @Override
    public int getIndex() {
        return Integer.MAX_VALUE;
    }

    public boolean isSuppressByComment() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptSuppressByCommentFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptSuppressByCommentFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

