/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.helm;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"TEMPLATES_DIR_NAME", "", "hasYamlExtension", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasJsonExtension", "isHelmTemplateFile", "intellij.yaml.backend"})
public final class UtilKt {
    @NotNull
    public static final String TEMPLATES_DIR_NAME = "templates";

    @ApiStatus.Internal
    public static final boolean hasYamlExtension(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getExtension(), (Object)"yaml") || Intrinsics.areEqual((Object)file.getExtension(), (Object)"yml");
    }

    @ApiStatus.Internal
    public static final boolean hasJsonExtension(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getExtension(), (Object)"json");
    }

    @ApiStatus.Internal
    public static final boolean isHelmTemplateFile(@NotNull VirtualFile file) {
        VirtualFile chartDirCandidate;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = VfsUtilCore.findContainingDirectory((VirtualFile)VirtualFileUtil.originalFileOrSelf((VirtualFile)file), (CharSequence)TEMPLATES_DIR_NAME);
        Object object = chartDirCandidate = virtualFile != null ? virtualFile.getParent() : null;
        while (chartDirCandidate != null) {
            ProgressManager.checkCanceled();
            if (!chartDirCandidate.isValid()) {
                return false;
            }
            if (chartDirCandidate.findChild("Chart.yaml") != null) {
                return true;
            }
            if (Intrinsics.areEqual((Object)chartDirCandidate.getName(), (Object)".helm")) {
                return true;
            }
            VirtualFile virtualFile2 = VfsUtilCore.findContainingDirectory((VirtualFile)VirtualFileUtil.originalFileOrSelf((VirtualFile)chartDirCandidate), (CharSequence)TEMPLATES_DIR_NAME);
            chartDirCandidate = virtualFile2 != null ? virtualFile2.getParent() : null;
        }
        return false;
    }
}

