/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.model.properties.references;

import com.intellij.database.dialects.mysqlbase.model.MysqlBaseCollation;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseModel;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlBaseCharsetReference
implements BasicReference {
    public final String charsetName;

    private MysqlBaseCharsetReference(@NotNull String charsetName) {
        if (charsetName == null) {
            MysqlBaseCharsetReference.$$$reportNull$$$0(0);
        }
        this.charsetName = charsetName;
    }

    @NotNull
    public <S extends BasicElement, T extends BasicElement> JBIterable<T> multiResolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull BasicResolveAssistant assistant) {
        MysqlBaseModel model;
        if (source == null) {
            MysqlBaseCharsetReference.$$$reportNull$$$0(1);
        }
        if (meta == null) {
            MysqlBaseCharsetReference.$$$reportNull$$$0(2);
        }
        if (assistant == null) {
            MysqlBaseCharsetReference.$$$reportNull$$$0(3);
        }
        if ((model = (MysqlBaseModel)ObjectUtils.tryCast((Object)source.getModel(), MysqlBaseModel.class)) == null || meta.tryCast(MysqlBaseCollation.class) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                MysqlBaseCharsetReference.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        JBIterable jBIterable = model.getRoot().getCollations().jbi().filter(c -> c.isDefaultForCharset() && this.charsetName.equalsIgnoreCase(c.getCharset())).filter(meta.valueClass);
        if (jBIterable == null) {
            MysqlBaseCharsetReference.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @Nullable
    public String getName() {
        return null;
    }

    public long getObjectId() {
        return Long.MIN_VALUE;
    }

    public boolean isPortable() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MysqlBaseCharsetReference)) {
            return false;
        }
        MysqlBaseCharsetReference reference = (MysqlBaseCharsetReference)o;
        return this.charsetName.equals(reference.charsetName);
    }

    public int hashCode() {
        return Objects.hash(this.charsetName);
    }

    public <S extends BasicElement, T extends BasicElement> boolean matches(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull T target) {
        if (source == null) {
            MysqlBaseCharsetReference.$$$reportNull$$$0(6);
        }
        if (meta == null) {
            MysqlBaseCharsetReference.$$$reportNull$$$0(7);
        }
        if (target == null) {
            MysqlBaseCharsetReference.$$$reportNull$$$0(8);
        }
        return target instanceof MysqlBaseCollation && this.charsetName.equals(((MysqlBaseCollation)target).getCharset());
    }

    @Nullable
    public static MysqlBaseCharsetReference create(String charsetName) {
        return MysqlBaseCharsetReference.isDefault(charsetName) ? null : new MysqlBaseCharsetReference(charsetName);
    }

    public static boolean isDefault(String charsetName) {
        return StringUtil.isEmpty((String)charsetName);
    }

    public void exportProperties(@NotNull NameValueConsumer<? super String> consumer) {
        if (consumer == null) {
            MysqlBaseCharsetReference.$$$reportNull$$$0(9);
        }
        if (!MysqlBaseCharsetReference.isDefault(this.charsetName)) {
            consumer.accept("Charset", (Object)this.charsetName);
        }
    }

    @Nullable
    public static BasicReference importProperties(@NotNull NameValueGetter<String> properties) {
        if (properties == null) {
            MysqlBaseCharsetReference.$$$reportNull$$$0(10);
        }
        return MysqlBaseCharsetReference.create((String)properties.get("Charset"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsetName";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assistant";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysqlbase/model/properties/references/MysqlBaseCharsetReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysqlbase/model/properties/references/MysqlBaseCharsetReference";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

