/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.symfony.asset.mapper;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.lang.javascript.inspections.DownloadLibraryQuickFix;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.symfony.SymfonyBundle;
import com.intellij.symfony.asset.mapper.SymfonyAssetMapperManager;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a<\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\fH\u0002\u001a\u0018\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000e"}, d2={"downloadLibraryIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "moduleName", "", "runImportMapCommand", "file", "Lcom/intellij/psi/PsiFile;", "command", "", "postActivity", "Lkotlin/Function0;", "getUrl", "intellij.symfony"})
@SourceDebugExtension(value={"SMAP\nSymfonyImportMapModuleIsNotInstalledInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymfonyImportMapModuleIsNotInstalledInspection.kt\ncom/intellij/symfony/asset/mapper/SymfonyImportMapModuleIsNotInstalledInspectionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public final class SymfonyImportMapModuleIsNotInstalledInspectionKt {
    private static final void downloadLibraryIfNeeded(Project project, String moduleName) {
        SymfonyAssetMapperManager assetManager = SymfonyAssetMapperManager.Companion.getInstance(project);
        VirtualFile[] virtualFileArray = new VirtualFile[]{assetManager.getAssetsVendorDir()};
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
        virtualFileArray = new VirtualFile[]{assetManager.getImportMap()};
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])virtualFileArray);
        Document document = (Document)ReadAction.nonBlocking(() -> SymfonyImportMapModuleIsNotInstalledInspectionKt.downloadLibraryIfNeeded$lambda$0(assetManager)).executeSynchronously();
        if (document != null) {
            ApplicationManager.getApplication().invokeAndWait(() -> SymfonyImportMapModuleIsNotInstalledInspectionKt.downloadLibraryIfNeeded$lambda$1(project, document));
        }
        String string = (String)ReadAction.nonBlocking(() -> SymfonyImportMapModuleIsNotInstalledInspectionKt.downloadLibraryIfNeeded$lambda$2(project, moduleName)).executeSynchronously();
        if (string == null) {
            return;
        }
        String url = string;
        new DownloadLibraryQuickFix().download(FileEditorManager.getInstance((Project)project).getSelectedTextEditor(), project, null, url, ".js");
    }

    private static final void runImportMapCommand(PsiFile file, Project project, String moduleName, List<String> command, Function0<Unit> postActivity) {
        VirtualFile console = SymfonyAssetMapperManager.Companion.getInstance(project).findFile("bin/console");
        if (console == null) {
            Notifications.Bus.notify((Notification)new Notification("Symfony Asset Mapper", SymfonyBundle.INSTANCE.message("symfony.asset.mapper.symfony.runtime.is.missing", new Object[0]), NotificationType.ERROR));
            return;
        }
        String string = console.getCanonicalPath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            command.add(0, it);
        }
        GeneralCommandLine cmd = new GeneralCommandLine(command);
        OSProcessHandler handler = new OSProcessHandler(cmd);
        Ref.ObjectRef errorMessage = new Ref.ObjectRef();
        Object[] objectArray = new Object[]{moduleName};
        errorMessage.element = SymfonyBundle.INSTANCE.message("symfony.asset.mapper.unable.install.module", objectArray);
        handler.addProcessListener(new ProcessListener((Ref.ObjectRef<String>)errorMessage, project, moduleName, postActivity, file){
            final /* synthetic */ Ref.ObjectRef<String> $errorMessage;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $moduleName;
            final /* synthetic */ Function0<Unit> $postActivity;
            final /* synthetic */ PsiFile $file;
            {
                this.$errorMessage = $errorMessage;
                this.$project = $project;
                this.$moduleName = $moduleName;
                this.$postActivity = $postActivity;
                this.$file = $file;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Symfony Runtime is missing", (boolean)false, (int)2, null)) {
                    this.$errorMessage.element = SymfonyBundle.INSTANCE.message("symfony.asset.mapper.symfony.runtime.is.missing", new Object[0]);
                }
                super.onTextAvailable(event, outputType);
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getExitCode() != 0) {
                    Notifications.Bus.notify((Notification)new Notification("Symfony Asset Mapper", (String)this.$errorMessage.element, NotificationType.ERROR));
                    return;
                }
                SymfonyImportMapModuleIsNotInstalledInspectionKt.access$downloadLibraryIfNeeded(this.$project, this.$moduleName);
                this.$postActivity.invoke();
                DaemonCodeAnalyzer.getInstance((Project)this.$project).restart(this.$file, (Object)this);
            }
        });
        handler.startNotify();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            handler.waitFor();
        }
    }

    @Nullable
    public static final String getUrl(@NotNull Project project, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Map<String, Map<String, Object>> modules = SymfonyAssetMapperManager.Companion.getInstance(project).getModules();
        Map<String, Object> map = modules.get(moduleName);
        if (map == null) {
            return null;
        }
        Map<String, Object> moduleInfo = map;
        if (moduleInfo.get("path") != null || moduleInfo.get("downloaded_to") != null) {
            return null;
        }
        return (String)moduleInfo.get("url");
    }

    private static final Document downloadLibraryIfNeeded$lambda$0(SymfonyAssetMapperManager $assetManager) {
        VirtualFile virtualFile = $assetManager.getImportMap();
        return virtualFile != null ? VirtualFileUtil.findDocument((VirtualFile)virtualFile) : null;
    }

    private static final void downloadLibraryIfNeeded$lambda$1(Project $project, Document $document) {
        PsiDocumentManager.getInstance((Project)$project).commitDocument($document);
    }

    private static final String downloadLibraryIfNeeded$lambda$2(Project $project, String $moduleName) {
        return SymfonyImportMapModuleIsNotInstalledInspectionKt.getUrl($project, $moduleName);
    }

    public static final /* synthetic */ void access$runImportMapCommand(PsiFile file, Project project, String moduleName, List command, Function0 postActivity) {
        SymfonyImportMapModuleIsNotInstalledInspectionKt.runImportMapCommand(file, project, moduleName, command, (Function0<Unit>)postActivity);
    }

    public static final /* synthetic */ void access$downloadLibraryIfNeeded(Project project, String moduleName) {
        SymfonyImportMapModuleIsNotInstalledInspectionKt.downloadLibraryIfNeeded(project, moduleName);
    }
}

