/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.config.PhpLanguageLevel;

public final class PhpLanguageLevelChangeUsageCollector
extends CounterUsagesCollector {
    static final EventLogGroup GROUP = new EventLogGroup("php.code.analysis", 3);
    static final EventField<String> OLD_LEVEL = EventFields.StringValidatedByRegexpReference((String)"old_level", (String)"version");
    static final EventField<String> NEW_LEVEL = EventFields.StringValidatedByRegexpReference((String)"new_level", (String)"version");
    static final EventId2<String, String> LEVEL_CHANGED = GROUP.registerEvent("level_automatically_changed", OLD_LEVEL, NEW_LEVEL);
    static final EventField<String> REVERT_FROM_LEVEL = EventFields.StringValidatedByRegexpReference((String)"revert_from_level", (String)"version");
    static final EventField<String> REVERT_TO_LEVEL = EventFields.StringValidatedByRegexpReference((String)"revert_to_level", (String)"version");
    static final EventId2<String, String> LEVEL_REVERTED = GROUP.registerEvent("level_automatic_change_reverted", REVERT_FROM_LEVEL, REVERT_TO_LEVEL);

    public static void triggerLanguageLevelChanged(Project project, PhpLanguageLevel oldLevel, PhpLanguageLevel newLevel) {
        LEVEL_CHANGED.log(project, (Object)oldLevel.getVersionString(), (Object)newLevel.getVersionString());
    }

    public static void triggerLanguageLevelChangeReverted(Project project, PhpLanguageLevel revertFromLevel, PhpLanguageLevel revertToLevel) {
        LEVEL_REVERTED.log(project, (Object)revertFromLevel.getVersionString(), (Object)revertToLevel.getVersionString());
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }
}

